/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.exception.UnableToForwardPortException;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFRemoteServices;

public abstract class TCFConnectionBase
implements IRemoteConnection {
    private final TCFRemoteServices fRemoteServices;
    private String fWorkingDirectory = "/";

    public TCFConnectionBase(TCFRemoteServices tcfServices) {
        this.fRemoteServices = tcfServices;
    }

    public final int compareTo(IRemoteConnection o) {
        return this.getName().compareTo(o.getName());
    }

    public final String getProperty(String key) {
        return (String)this.getAttributes().get(key);
    }

    public final String getEnv(String name) {
        return (String)this.getEnv().get(name);
    }

    public final TCFRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    public final String getWorkingDirectory() {
        return this.fWorkingDirectory;
    }

    public final void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.TCFConnectionBase_errorNoPortForwarding);
    }

    public final int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.TCFConnectionBase_errorNoPortForwarding);
    }

    public final void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.TCFConnectionBase_errorNoPortForwarding);
    }

    public final int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.TCFConnectionBase_errorNoPortForwarding);
    }

    public final void removeLocalPortForwarding(int port) {
    }

    public final void removeRemotePortForwarding(int port) {
    }

    public final void setWorkingDirectory(String path) {
        if (new Path(path).isAbsolute()) {
            this.fWorkingDirectory = path;
        }
    }

    public final boolean supportsTCPPortForwarding() {
        return false;
    }

    public final String toString() {
        String str = String.valueOf(this.getName()) + " [" + this.getAddress();
        int port = this.getPort();
        if (port >= 0 && port != 1756) {
            str = String.valueOf(str) + ":" + port;
        }
        return String.valueOf(str) + "]";
    }
}

