/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.remote.core.nls.Messages;

public final class PeerInfo
implements IChannel.IChannelListener {
    private IFileSystem fFileSystem;
    private boolean fPendingOpen;
    private List<DoneGetFileSystem> fCallbacks = Collections.emptyList();
    private User fUser;

    public void getFileSystem(IPeerNode peerNode, DoneGetFileSystem callback) {
        assert (Protocol.isDispatchThread());
        if (peerNode.getConnectState() != 11) {
            callback.done(null, this.errorStatus(MessageFormat.format(Messages.PeerInfo_errorPeerNotConnected, peerNode.getName()), null));
        } else if (this.fFileSystem != null) {
            callback.done(this.fFileSystem, Status.OK_STATUS);
        } else {
            this.openChannel(peerNode, callback);
        }
    }

    public void openChannel(IPeerNode peerNode, DoneGetFileSystem callback) {
        if (this.fCallbacks.isEmpty()) {
            this.fCallbacks = Collections.singletonList(callback);
        } else {
            if (this.fCallbacks.size() == 1) {
                this.fCallbacks = new ArrayList<DoneGetFileSystem>(this.fCallbacks);
            }
            this.fCallbacks.add(callback);
        }
        if (this.fPendingOpen) {
            return;
        }
        this.fPendingOpen = true;
        final IPeer peer = peerNode.getPeer();
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("channel.noPathMap", Boolean.TRUE);
        flags.put("channel.forceNew", Boolean.TRUE);
        Tcf.getChannelManager().openChannel(peer, flags, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                PeerInfo.this.fPendingOpen = false;
                IStatus fsStatus = Status.OK_STATUS;
                if (error != null) {
                    fsStatus = PeerInfo.this.errorStatus(MessageFormat.format(Messages.PeerInfo_errorCannotOpenChannel, peer.getName()), error);
                } else {
                    channel.addChannelListener((IChannel.IChannelListener)PeerInfo.this);
                    PeerInfo.this.fFileSystem = (IFileSystem)channel.getRemoteService(IFileSystem.class);
                    if (PeerInfo.this.fFileSystem == null) {
                        fsStatus = PeerInfo.this.errorStatus(MessageFormat.format(Messages.PeerInfo_errorNoFileSystemService, peer.getName()), null);
                    }
                }
                for (DoneGetFileSystem callback : PeerInfo.this.fCallbacks) {
                    callback.done(PeerInfo.this.fFileSystem, fsStatus);
                }
            }
        });
    }

    private IStatus errorStatus(String msg, Throwable cause) {
        return new Status(4, CoreBundleActivator.getUniqueIdentifier(), msg, cause);
    }

    public void congestionLevel(int level) {
    }

    public void onChannelOpened() {
    }

    public void onChannelClosed(Throwable error) {
        this.fFileSystem = null;
        this.fCallbacks = Collections.emptyList();
    }

    public void getUser(IFileSystem fs, final DoneGetUser callback) {
        assert (Protocol.isDispatchThread());
        if (this.fUser != null) {
            callback.done(this.fUser, Status.OK_STATUS);
            return;
        }
        fs.user(new IFileSystem.DoneUser(){

            public void doneUser(IToken token, IFileSystem.FileSystemException error, int realUID, int effectiveUID, int realGID, int effectiveGID, String home) {
                if (error != null) {
                    callback.done(null, PeerInfo.this.errorStatus(error.getMessage(), (Throwable)error));
                } else {
                    PeerInfo.this.fUser = new User(effectiveUID, effectiveGID);
                    callback.done(PeerInfo.this.fUser, Status.OK_STATUS);
                }
            }
        });
    }

    public static interface DoneGetFileSystem {
        public void done(IFileSystem var1, IStatus var2);
    }

    public static interface DoneGetUser {
        public void done(User var1, IStatus var2);
    }

    public final class User {
        public final int fEffectiveGID;
        public final int fEffectiveUID;

        User(int effectiveUID, int effectiveGID) {
            this.fEffectiveUID = effectiveUID;
            this.fEffectiveGID = effectiveGID;
        }
    }
}

