/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.nls.Messages;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperation;

public abstract class TCFFileStoreOperation<T>
extends TCFOperation<T> {
    private static final Map<String, PeerInfo> fPeerInfos = new HashMap<String, PeerInfo>();
    private final TCFFileStore fFileStore;

    protected TCFFileStoreOperation(TCFFileStore fileStore) {
        this.fFileStore = fileStore;
    }

    protected final TCFFileStore getFileStore() {
        return this.fFileStore;
    }

    protected final String getPath() {
        return this.fFileStore.getPath().toString();
    }

    protected final IPeerNode getPeerNode() {
        return this.fFileStore.getConnection().getPeerNode();
    }

    private final PeerInfo getPeerInfo(IPeerNode peerNode) {
        String key = peerNode.getName();
        PeerInfo result = fPeerInfos.get(key);
        if (result == null) {
            result = new PeerInfo();
            fPeerInfos.put(key, result);
        }
        return result;
    }

    protected final void getFileSystem(PeerInfo.DoneGetFileSystem callback) {
        IPeerNode peerNode = this.getPeerNode();
        if (peerNode == null) {
            this.setError((IStatus)this.createStatus(MessageFormat.format(Messages.TCFFileStoreOperation_errorNotConnected, this.fFileStore.getConnection().getName()), null));
        } else {
            this.getPeerInfo(peerNode).getFileSystem(peerNode, callback);
        }
    }

    protected final void getUser(IFileSystem fileSystem, PeerInfo.DoneGetUser callback) {
        IPeerNode peerNode = this.getPeerNode();
        if (peerNode == null) {
            this.setError((IStatus)this.createStatus(MessageFormat.format(Messages.TCFFileStoreOperation_errorNotConnected, this.fFileStore.getConnection().getName()), null));
        } else {
            this.getPeerInfo(peerNode).getUser(fileSystem, callback);
        }
    }

    protected final void stat(IFileSystem fileSystem, TCFFileStore fileStore, IFileSystem.DoneStat doneStat) {
        IFileSystem.FileAttrs attrs = fileStore.getAttributes();
        if (attrs != null) {
            doneStat.doneStat(null, null, attrs);
        } else {
            fileSystem.stat(fileStore.getPath().toString(), doneStat);
        }
    }
}

