/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFFileStoreOperation;

public final class TCFOperationFetchInfo
extends TCFFileStoreOperation<IFileInfo> {
    public TCFOperationFetchInfo(TCFFileStore filestore) {
        super(filestore);
    }

    @Override
    protected void doExecute() {
        this.getFileSystem(new PeerInfo.DoneGetFileSystem(){

            @Override
            public void done(final IFileSystem fileSystem, IStatus status) {
                if (TCFOperationFetchInfo.this.shallAbort(status)) {
                    return;
                }
                TCFOperationFetchInfo.this.getUser(fileSystem, new PeerInfo.DoneGetUser(){

                    @Override
                    public void done(final PeerInfo.User user, IStatus status) {
                        if (TCFOperationFetchInfo.this.shallAbort(status)) {
                            return;
                        }
                        TCFOperationFetchInfo.this.stat(fileSystem, TCFOperationFetchInfo.this.getFileStore(), new IFileSystem.DoneStat(){

                            public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                                if (error != null) {
                                    if (error.getStatus() == 65538) {
                                        FileInfo result = new FileInfo(TCFOperationFetchInfo.this.getFileStore().getName());
                                        result.setExists(false);
                                        TCFOperationFetchInfo.this.setResult(result);
                                    } else {
                                        TCFOperationFetchInfo.this.setError((Throwable)error);
                                    }
                                } else {
                                    TCFOperationFetchInfo.this.getFileStore().setAttributes(attrs);
                                    TCFOperationFetchInfo.this.setResult(user, attrs);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    protected final void setResult(PeerInfo.User user, IFileSystem.FileAttrs attrs) {
        FileInfo result = new FileInfo(this.getFileStore().getName());
        result.setExists(true);
        int flags = attrs.flags;
        if ((flags & 1) != 0) {
            result.setLength(attrs.size);
        }
        if ((flags & 8) != 0) {
            result.setLastModified(attrs.mtime);
        }
        if ((flags & 4) != 0) {
            int p = attrs.permissions;
            boolean writable = attrs.uid == user.fEffectiveUID && (p & 0x80) != 0 || attrs.gid == user.fEffectiveGID && (p & 0x10) != 0 || (p & 2) != 0;
            result.setAttribute(2, !writable);
            result.setAttribute(0x400000, (p & 0x100) != 0);
            result.setAttribute(0x800000, (p & 0x80) != 0);
            result.setAttribute(0x1000000, (p & 0x40) != 0);
            result.setAttribute(0x2000000, (p & 0x20) != 0);
            result.setAttribute(0x4000000, (p & 0x10) != 0);
            result.setAttribute(0x8000000, (p & 8) != 0);
            result.setAttribute(0x10000000, (p & 4) != 0);
            result.setAttribute(0x20000000, (p & 2) != 0);
            result.setAttribute(0x40000000, (p & 1) != 0);
            result.setDirectory((p & 0xF000) == 16384);
        }
        this.setResult(result);
    }
}

