/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.ui.breakpoints.AbstractToggleBreakpointAdapter;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFDisassemblyToggleBreakpointAdapter;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.ui.IWorkbenchPart;

public class TCFToggleBreakpointAdapter
extends AbstractToggleBreakpointAdapter {
    private final String TOGGLE_TYPE;
    private final TCFDisassemblyToggleBreakpointAdapter fDisassemblyToggleDelegate;

    TCFToggleBreakpointAdapter(String toggle_type) {
        this.TOGGLE_TYPE = toggle_type;
        this.fDisassemblyToggleDelegate = new TCFDisassemblyToggleBreakpointAdapter(toggle_type);
    }

    static IStructuredSelection getDebugContext(IWorkbenchPart part) {
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    static boolean isDefaultBPContextQueryEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.tcf.cdt.ui", "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.setDefaultTriggerScopeEnabled", false, null);
    }

    static String getDefaultBPContextQuery() {
        return Platform.getPreferencesService().getString("org.eclipse.tcf.cdt.ui", "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.defaultTriggerExpression", null, null);
    }

    static Map<String, Object> getDefaultAttributes(IWorkbenchPart part, String toggleType) {
        Object obj;
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        if (part != null && ((obj = TCFToggleBreakpointAdapter.getDebugContext(part).getFirstElement()) instanceof TCFNode || obj instanceof TCFLaunch) && toggleType.length() != 0) {
            attributes.clear();
            if (TCFToggleBreakpointAdapter.isDefaultBPContextQueryEnabled()) {
                String query = TCFToggleBreakpointAdapter.getDefaultBPContextQuery();
                attributes.put("org.eclipse.tcf.debug.ContextQuery", query);
            }
        }
        return attributes;
    }

    protected ICLineBreakpoint findLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        return CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
    }

    protected void createLineBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(part, this.TOGGLE_TYPE);
        ICLineBreakpoint lineBp = CDIDebugModel.createBlankLineBreakpoint();
        CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
        if (!interactive) {
            CDIDebugModel.createBreakpointMarker((ICBreakpoint)lineBp, (IResource)resource, attributes, (boolean)true);
        } else {
            this.openBreakpointPropertiesDialog((ICBreakpoint)lineBp, part, resource, attributes);
        }
    }

    protected ICFunctionBreakpoint findFunctionBreakpoint(String sourceHandle, IResource resource, String functionName) throws CoreException {
        return CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)resource, (String)functionName);
    }

    protected void createFunctionBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, String functionName, int charStart, int charEnd, int lineNumber) throws CoreException {
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(part, this.TOGGLE_TYPE);
        ICFunctionBreakpoint bp = CDIDebugModel.createBlankFunctionBreakpoint();
        CDIDebugModel.setFunctionBreakpointAttributes(attributes, (String)sourceHandle, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"");
        if (!interactive) {
            CDIDebugModel.createBreakpointMarker((ICBreakpoint)bp, (IResource)resource, attributes, (boolean)true);
        } else {
            this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
        }
    }

    protected ICWatchpoint findWatchpoint(String sourceHandle, IResource resource, String expression) throws CoreException {
        return CDIDebugModel.watchpointExists((String)sourceHandle, (IResource)resource, (String)expression);
    }

    protected int getBreakpointType() {
        return 0;
    }

    protected void createWatchpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, String expression, String memorySpace, String range) throws CoreException {
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(part, this.TOGGLE_TYPE);
        ICWatchpoint bp = CDIDebugModel.createBlankWatchpoint();
        CDIDebugModel.setWatchPointAttributes(attributes, (String)sourceHandle, (IResource)resource, (boolean)true, (boolean)false, (String)expression, (String)memorySpace, (BigInteger)new BigInteger(range), (boolean)true, (int)0, (String)"");
        this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
    }

    protected void createEventBreakpoint(boolean interactive, IWorkbenchPart part, IResource resource, String type, String arg) throws CoreException {
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(part, this.TOGGLE_TYPE);
        ICEventBreakpoint bp = CDIDebugModel.createBlankEventBreakpoint();
        CDIDebugModel.setEventBreakpointAttributes(attributes, (String)type, (String)arg);
        this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof IDisassemblyPart) {
            this.fDisassemblyToggleDelegate.toggleLineBreakpoints(part, selection);
        } else {
            super.toggleLineBreakpoints(part, selection);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IDisassemblyPart) {
            return this.fDisassemblyToggleDelegate.canToggleLineBreakpoints(part, selection);
        }
        return super.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof IDisassemblyPart) {
            this.fDisassemblyToggleDelegate.toggleBreakpoints(part, selection);
        } else {
            super.toggleBreakpoints(part, selection);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IDisassemblyPart) {
            return this.fDisassemblyToggleDelegate.canToggleBreakpoints(part, selection);
        }
        return super.canToggleBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        if (part instanceof IDisassemblyPart) {
            this.fDisassemblyToggleDelegate.toggleBreakpointsWithEvent(part, selection, event);
        } else {
            super.toggleBreakpointsWithEvent(part, selection, event);
        }
    }

    public void createLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof IDisassemblyPart) {
            this.fDisassemblyToggleDelegate.createLineBreakpointsInteractive(part, selection);
        } else {
            super.createLineBreakpointsInteractive(part, selection);
        }
    }

    public boolean canCreateLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IDisassemblyPart) {
            return this.fDisassemblyToggleDelegate.canCreateLineBreakpointsInteractive(part, selection);
        }
        return super.canCreateLineBreakpointsInteractive(part, selection);
    }
}

