/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.RunControl;
import org.eclipse.tcf.internal.debug.tests.TestAttachTerminate;
import org.eclipse.tcf.internal.debug.tests.TestEcho;
import org.eclipse.tcf.internal.debug.tests.TestEchoERR;
import org.eclipse.tcf.internal.debug.tests.TestEchoFP;
import org.eclipse.tcf.internal.debug.tests.TestExpressions;
import org.eclipse.tcf.internal.debug.tests.TestFileSystem;
import org.eclipse.tcf.internal.debug.tests.TestPathMap;
import org.eclipse.tcf.internal.debug.tests.TestRCBP1;
import org.eclipse.tcf.internal.debug.tests.TestStreams;
import org.eclipse.tcf.internal.debug.tests.TestSysMonitor;
import org.eclipse.tcf.internal.debug.tests.TestTerminals;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;

public class TCFTestSuite {
    static final int NUM_CHANNELS = 4;
    private final TestListener listener;
    private final IChannel[] channels;
    private final Map<IChannel, RunControl> run_controls = new HashMap<IChannel, RunControl>();
    private final LinkedList<Runnable> pending_tests = new LinkedList();
    private final Collection<Throwable> errors = new ArrayList<Throwable>();
    private final Map<ITCFTest, IChannel> active_tests = new HashMap<ITCFTest, IChannel>();
    private static final HashMap<String, String> cancel_test_ids = new HashMap();
    private int count_total;
    private int count_done;
    boolean cancel;
    boolean canceled;
    boolean target_lock;

    public TCFTestSuite(final IPeer peer, final TestListener listener, final List<IPathMap.PathMapRule> path_map, final Map<String, ArrayList<IMemoryMap.MemoryRegion>> mem_map) throws IOException {
        this.listener = listener;
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Echo Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestEcho(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Echo FP Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestEchoFP(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Echo ERR Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestEchoERR(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Path Map Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestPathMap(TCFTestSuite.this, channel, path_map), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Debugger Attach/Terminate Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestAttachTerminate(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Expressions Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestExpressions(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel, mem_map), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Streams Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestStreams(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Sys monitor Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestSysMonitor(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Terminals Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestTerminals(TCFTestSuite.this, channel), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Run Control Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestRCBP1(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel, i++, path_map, mem_map), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running File System Test...", n, TCFTestSuite.this.count_total);
                IChannel[] iChannelArray = TCFTestSuite.this.channels;
                int n2 = iChannelArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IChannel channel = iChannelArray[n3];
                    TCFTestSuite.this.active_tests.put(new TestFileSystem(TCFTestSuite.this, channel, i++), channel);
                    ++n3;
                }
            }
        });
        this.pending_tests.add(new Runnable(){

            @Override
            public void run() {
                TCFTestSuite tCFTestSuite = TCFTestSuite.this;
                int n = tCFTestSuite.count_done;
                tCFTestSuite.count_done = n + 1;
                listener.progress("Running Interability Test...", n, TCFTestSuite.this.count_total);
                Random rnd = new Random();
                int i = 0;
                while (i < TCFTestSuite.this.channels.length) {
                    IChannel channel = TCFTestSuite.this.channels[i];
                    ITCFTest test = null;
                    switch (rnd.nextInt(11)) {
                        case 0: {
                            test = new TestEcho(TCFTestSuite.this, channel);
                            break;
                        }
                        case 1: {
                            test = new TestEchoERR(TCFTestSuite.this, channel);
                            break;
                        }
                        case 2: {
                            test = new TestEchoFP(TCFTestSuite.this, channel);
                            break;
                        }
                        case 3: {
                            test = new TestAttachTerminate(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel);
                            break;
                        }
                        case 4: {
                            test = new TestExpressions(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel, mem_map);
                            break;
                        }
                        case 5: {
                            test = new TestRCBP1(TCFTestSuite.this, (RunControl)TCFTestSuite.this.run_controls.get(channel), channel, i, path_map, mem_map);
                            break;
                        }
                        case 6: {
                            test = new TestFileSystem(TCFTestSuite.this, channel, i);
                            break;
                        }
                        case 7: {
                            test = new TestPathMap(TCFTestSuite.this, channel, path_map);
                            break;
                        }
                        case 8: {
                            test = new TestStreams(TCFTestSuite.this, channel);
                            break;
                        }
                        case 9: {
                            test = new TestSysMonitor(TCFTestSuite.this, channel);
                            break;
                        }
                        case 10: {
                            test = new TestTerminals(TCFTestSuite.this, channel);
                        }
                    }
                    TCFTestSuite.this.active_tests.put(test, channel);
                    ++i;
                }
            }
        });
        this.count_total = this.pending_tests.size() * 5;
        this.channels = new IChannel[4];
        Protocol.invokeLater((Runnable)new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block6: {
                    try {
                        TCFTestSuite.access$6(TCFTestSuite.this, peer);
                        break block6;
                    }
                    catch (Throwable x) {
                        TCFTestSuite.access$7(TCFTestSuite.this).add(x);
                        cnt = 0;
                        i = 0;
                        ** while (i < TCFTestSuite.access$3((TCFTestSuite)TCFTestSuite.this).length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (TCFTestSuite.access$3(TCFTestSuite.this)[i] != null) {
                            if (TCFTestSuite.access$3(TCFTestSuite.this)[i].getState() != 2) {
                                TCFTestSuite.access$3(TCFTestSuite.this)[i].close();
                            }
                            ++cnt;
                        }
                        ++i;
                        continue;
                    }
lbl16:
                    // 1 sources

                    if (cnt == 0) {
                        listener.done(TCFTestSuite.access$7(TCFTestSuite.this));
                    }
                }
            }
        });
    }

    private void openChannels(IPeer peer) {
        this.listener.progress("Opening communication channels...", this.count_done, this.count_total);
        int i = 0;
        while (i < this.channels.length) {
            final IChannel channel = this.channels[i] = peer.openChannel();
            channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    int i = 0;
                    while (i < TCFTestSuite.this.channels.length) {
                        if (TCFTestSuite.this.channels[i] == null) {
                            return;
                        }
                        if (TCFTestSuite.this.channels[i].getState() != 1) {
                            return;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < TCFTestSuite.this.channels.length) {
                        TCFTestSuite.this.run_controls.put(TCFTestSuite.this.channels[i], new RunControl(TCFTestSuite.this, TCFTestSuite.this.channels[i], i));
                        ++i;
                    }
                    TCFTestSuite.this.runNextTest();
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    channel.removeChannelListener((IChannel.IChannelListener)this);
                    if (!(error != null || !TCFTestSuite.this.errors.isEmpty() || TCFTestSuite.this.active_tests.isEmpty() && TCFTestSuite.this.pending_tests.isEmpty() || TCFTestSuite.this.cancel)) {
                        error = new IOException("Remote peer closed connection before all tests finished");
                    }
                    int cnt = 0;
                    int i = 0;
                    while (i < TCFTestSuite.this.channels.length) {
                        if (TCFTestSuite.this.channels[i] == channel) {
                            ((TCFTestSuite)TCFTestSuite.this).channels[i] = null;
                            if (error != null && TCFTestSuite.this.errors.isEmpty()) {
                                TCFTestSuite.this.errors.add(error);
                            }
                            Iterator n = TCFTestSuite.this.active_tests.keySet().iterator();
                            while (n.hasNext()) {
                                if (TCFTestSuite.this.active_tests.get(n.next()) != channel) continue;
                                n.remove();
                            }
                        }
                        if (TCFTestSuite.this.channels[i] != null) {
                            if ((error != null || TCFTestSuite.this.active_tests.isEmpty() && TCFTestSuite.this.pending_tests.isEmpty()) && TCFTestSuite.this.channels[i].getState() != 2) {
                                TCFTestSuite.this.channels[i].close();
                            }
                            ++cnt;
                        }
                        ++i;
                    }
                    if (cnt == 0) {
                        TCFTestSuite.this.listener.done(TCFTestSuite.this.errors);
                    }
                }
            });
            ++i;
        }
    }

    public void cancel() {
        this.cancel = true;
        if (this.canceled) {
            return;
        }
        for (final ITCFTest t : this.active_tests.keySet()) {
            if (!(t instanceof TestRCBP1)) continue;
            ((TestRCBP1)t).cancel(new Runnable(){

                @Override
                public void run() {
                    if (!$assertionsDisabled && TCFTestSuite.this.active_tests.get(t) != null) {
                        throw new AssertionError();
                    }
                    TCFTestSuite.this.cancel();
                }
            });
            return;
        }
        this.canceled = true;
        IChannel[] iChannelArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannel c = iChannelArray[n2];
            if (c != null && c.getState() != 2) {
                c.close();
            }
            ++n2;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    boolean isActive(ITCFTest test) {
        return this.active_tests.get(test) != null;
    }

    Collection<ITCFTest> getActiveTests() {
        return this.active_tests.keySet();
    }

    ITCFTest getActiveTest(IChannel channel) {
        for (Map.Entry<ITCFTest, IChannel> e : this.active_tests.entrySet()) {
            if (e.getValue() != channel) continue;
            return e.getKey();
        }
        return null;
    }

    Map<String, String> getCanceledTests() {
        return cancel_test_ids;
    }

    boolean canResume(String id) {
        for (RunControl r : this.run_controls.values()) {
            if (r.canResume(id)) continue;
            return false;
        }
        for (ITCFTest t : this.active_tests.keySet()) {
            if (t.canResume(id)) continue;
            return false;
        }
        return true;
    }

    void done(ITCFTest test, Throwable error) {
        assert (this.active_tests.get(test) != null);
        if (error != null && !this.canceled) {
            this.errors.add(error);
        }
        this.active_tests.remove(test);
        this.listener.progress(null, this.count_done++, this.count_total);
        if (this.active_tests.isEmpty()) {
            this.runNextTest();
        }
    }

    private void runNextTest() {
        while (this.active_tests.isEmpty()) {
            ITCFTest[] lst;
            int n;
            if (this.cancel || this.errors.size() > 0 || this.pending_tests.size() == 0) {
                IChannel[] iChannelArray = this.channels;
                n = this.channels.length;
                int n2 = 0;
                while (n2 < n) {
                    IChannel channel = iChannelArray[n2];
                    if (channel != null && channel.getState() != 2) {
                        if (this.errors.size() > 0) {
                            channel.terminate((Throwable)new Exception("Test failed"));
                        } else {
                            channel.close();
                        }
                    }
                    ++n2;
                }
                return;
            }
            this.pending_tests.removeFirst().run();
            ITCFTest[] iTCFTestArray = lst = this.active_tests.keySet().toArray(new ITCFTest[this.active_tests.size()]);
            int n3 = lst.length;
            n = 0;
            while (n < n3) {
                ITCFTest test = iTCFTestArray[n];
                test.start();
                ++n;
            }
        }
    }

    static /* synthetic */ void access$6(TCFTestSuite tCFTestSuite, IPeer iPeer) {
        tCFTestSuite.openChannels(iPeer);
    }

    public static interface TestListener {
        public void progress(String var1, int var2, int var3);

        public void done(Collection<Throwable> var1);
    }
}

