/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;

class TestEchoFP
implements ITCFTest,
IDiagnostics.DoneEchoFP {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final LinkedList<BigDecimal> msgs = new LinkedList();
    private final Random rnd = new Random();
    private int count = 0;
    private long start_time;

    TestEchoFP(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
    }

    @Override
    public void start() {
        if (this.diag == null) {
            this.test_suite.done(this, null);
        } else {
            this.start_time = System.currentTimeMillis();
            int i = 0;
            while (i < 32) {
                this.sendMessage();
                ++i;
            }
        }
    }

    private void sendMessage() {
        BigDecimal n = BigDecimal.valueOf(this.rnd.nextInt(), this.rnd.nextInt(61) - 30);
        this.msgs.add(n);
        this.diag.echoFP(n, (IDiagnostics.DoneEchoFP)this);
        ++this.count;
    }

    private boolean cmp(double x, double y) {
        return (float)x == (float)y;
    }

    public void doneEchoFP(IToken token, Throwable error, BigDecimal b) {
        BigDecimal s = this.msgs.removeFirst();
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (error != null) {
            this.test_suite.done(this, error);
        } else if (!this.cmp(s.doubleValue(), b.doubleValue())) {
            this.test_suite.done(this, new Exception("EchoFP test failed: " + s + " != " + b));
        } else if (this.count < 2048) {
            this.sendMessage();
            if (this.count % 16 == 0 && System.currentTimeMillis() - this.start_time >= 4000L) {
                this.count = 2048;
            }
        } else if (this.msgs.isEmpty()) {
            this.test_suite.done(this, null);
        }
    }

    @Override
    public boolean canResume(String id) {
        return true;
    }
}

