/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.nodes;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.contexts.AsyncRefreshableCtxAdapter;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;

public class ProcessContextNode
extends ContainerModelNode
implements IProcessContextNode,
IPeerNodeProvider,
IFilterable {
    private IProcesses.ProcessContext pContext = null;
    private ISysMonitor.SysMonitorContext sContext = null;
    private IProcessContextNode.TYPE type = IProcessContextNode.TYPE.Unknown;
    private final IAsyncRefreshableCtx refreshableCtxAdapter = new AsyncRefreshableCtxAdapter();

    public ProcessContextNode() {
        this.setChangeEventsEnabled(true);
        this.refreshableCtxAdapter.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
    }

    protected boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    public String getName() {
        String file;
        String name;
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        String string = name = this.pContext != null ? this.pContext.getName() : null;
        if (name != null && ("".equals(name.trim()) || name.equals(this.pContext.getID()))) {
            name = null;
        }
        String string2 = file = this.sContext != null ? this.sContext.getFile() : null;
        if (file != null && !"".equals(file)) {
            Path path = new Path(file);
            name = path.getDevice() != null && path.getDevice().endsWith(":") && path.getDevice().length() == 2 ? path.lastSegment() : file;
        }
        if (name == null || "".equals(name.trim())) {
            String string3 = name = this.pContext != null ? this.pContext.getID() : null;
        }
        if (name == null || "".equals(name.trim())) {
            name = this.getStringProperty("name");
        }
        if (name == null || "".equals(name.trim())) {
            name = this.getStringProperty("id");
        }
        return name != null && !"".equals(name.trim()) ? name.trim() : super.getName();
    }

    @Override
    public void setType(IProcessContextNode.TYPE type) {
        Assert.isNotNull((Object)((Object)type));
        this.type = type;
    }

    @Override
    public IProcessContextNode.TYPE getType() {
        return this.type;
    }

    @Override
    public final void setProcessContext(IProcesses.ProcessContext context) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.pContext = context;
    }

    @Override
    public final IProcesses.ProcessContext getProcessContext() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.pContext;
    }

    @Override
    public void setSysMonitorContext(ISysMonitor.SysMonitorContext context) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.sContext = context;
    }

    @Override
    public ISysMonitor.SysMonitorContext getSysMonitorContext() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.sContext;
    }

    public IPeerNode getPeerNode() {
        return (IPeerNode)this.getAdapter(IPeerNode.class);
    }

    @Override
    public boolean isComplete() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (this.getProcessContext() != null || this.getSysMonitorContext() != null) {
            return true;
        }
        boolean complete = true;
        String id = this.getStringProperty("id");
        return complete &= id != null && !"".equals(id);
    }

    public Object getAdapter(final Class adapter) {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(ProcessContextNode.this.doGetAdapter(adapter));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return object.get() != null ? object.get() : super.getAdapter(adapter);
    }

    protected Object doGetAdapter(Class<?> adapter) {
        IModel model;
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (IProcesses.ProcessContext.class.isAssignableFrom(adapter)) {
            return this.pContext;
        }
        if (ISysMonitor.SysMonitorContext.class.isAssignableFrom(adapter)) {
            return this.sContext;
        }
        if (IPeerNodeProvider.class.isAssignableFrom(adapter) && (model = (IModel)this.getParent(IModel.class)) instanceof IPeerNodeProvider) {
            return model;
        }
        if ((IPeerNode.class.isAssignableFrom(adapter) || IConnectable.class.isAssignableFrom(adapter)) && (model = (IModel)this.getParent(IModel.class)) instanceof IPeerNodeProvider) {
            return ((IPeerNodeProvider)model).getPeerNode();
        }
        if (IAsyncRefreshableCtx.class.isAssignableFrom(adapter)) {
            return this.refreshableCtxAdapter;
        }
        return null;
    }

    public String toString() {
        final AtomicReference<String> toString = new AtomicReference<String>(super.toString());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StringBuilder buffer = new StringBuilder((String)toString.get());
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.append(", system monitor properties=");
                buffer.append(ProcessContextNode.this.getSysMonitorContext() != null ? ProcessContextNode.this.getSysMonitorContext().toString() : "{}");
                buffer.append(", process properties=");
                buffer.append(ProcessContextNode.this.getProcessContext() != null ? ProcessContextNode.this.getProcessContext().toString() : "{}");
                buffer.append("}");
                toString.set(buffer.toString());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return toString.get();
    }
}

