/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.Editor;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.tcf.te.ui.views.extensions.LabelProviderDelegateExtensionPointManager;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.menus.IMenuService;

public abstract class AbstractCustomFormToolkitEditorPage
extends AbstractEditorPage {
    private CustomFormToolkit toolkit = null;
    private IToolBarManager toolBarManager = null;

    protected final CustomFormToolkit getFormToolkit() {
        return this.toolkit;
    }

    protected final void setFormToolkit(CustomFormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public void dispose() {
        IMenuService service = (IMenuService)this.getSite().getService(IMenuService.class);
        if (service != null && this.toolBarManager instanceof ContributionManager) {
            service.releaseContributions((ContributionManager)this.toolBarManager);
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Assert.isNotNull((Object)managedForm);
        this.toolkit = new CustomFormToolkit(managedForm.getToolkit());
        this.configureManagedForm(managedForm);
        this.doCreateFormContent(managedForm.getForm().getBody(), this.getFormToolkit());
        managedForm.reflow(true);
    }

    protected void configureManagedForm(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)false, (int)1));
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.getContextHelpId());
        }
        this.getFormToolkit().getFormToolkit().decorateFormHeading(managedForm.getForm().getForm());
        String title = this.getFormTitle();
        if (title != null) {
            this.setFormTitle(title);
        }
        managedForm.getForm().getForm().setImage(this.getFormImage());
        this.toolBarManager = managedForm.getForm().getForm().getToolBarManager();
        this.toolBarManager.add((IContributionItem)new Separator("additions"));
        this.createToolbarContributionItems(this.toolBarManager);
        IMenuService service = (IMenuService)this.getSite().getService(IMenuService.class);
        if (service != null && this.toolBarManager instanceof ContributionManager) {
            service.populateContributionManager((ContributionManager)this.toolBarManager, "toolbar:" + this.getId());
        }
        this.toolBarManager.update(true);
    }

    protected String getContextHelpId() {
        return null;
    }

    protected String getFormTitle() {
        return null;
    }

    public String getFormTitleStateDecoration() {
        return null;
    }

    protected Image getFormImage() {
        Image image = null;
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(this.getEditorInputNode(), false);
        if (delegates != null && delegates.length > 0 && (image = delegates[0].getImage(this.getEditorInputNode())) != null && delegates[0] instanceof ILabelDecorator) {
            image = ((ILabelDecorator)delegates[0]).decorateImage(image, this.getEditorInputNode());
        }
        return image;
    }

    public void setFormTitle(String title) {
        String oldTitle;
        Assert.isNotNull((Object)title);
        String fullTitle = title;
        String titleStateDecoration = this.getFormTitleStateDecoration();
        if (titleStateDecoration != null) {
            fullTitle = String.valueOf(fullTitle) + " " + titleStateDecoration;
        }
        if (!fullTitle.equals(oldTitle = this.getManagedForm().getForm().getText())) {
            this.getManagedForm().getForm().setText(fullTitle);
        }
    }

    public void setFormImage(Image image) {
        this.getManagedForm().getForm().setImage(image);
        if (this.getEditor() instanceof Editor) {
            ((Editor)this.getEditor()).setTitleImage(image);
        }
    }

    protected void createToolbarContributionItems(IToolBarManager manager) {
        Action helpAction;
        Assert.isNotNull((Object)manager);
        manager.add((IContributionItem)new Separator("group.connect"));
        manager.add((IContributionItem)new Separator("group.launch"));
        manager.add((IContributionItem)new GroupMarker("group.launch.rundebug"));
        manager.add((IContributionItem)new GroupMarker("group.launch.additions"));
        manager.add((IContributionItem)new Separator("group.additions"));
        manager.add((IContributionItem)new Separator("group.additions.control"));
        manager.add((IContributionItem)new Separator("group.help"));
        IContributionItem linkContribution = this.doCreateLinkContribution(manager);
        if (linkContribution != null) {
            manager.add(linkContribution);
        }
        if (this.getContextHelpId() != null && (helpAction = this.doCreateHelpAction(this.getContextHelpId())) != null) {
            manager.add((IAction)helpAction);
        }
        MenuManager mgr = new MenuManager();
        mgr.add((IContributionItem)new Separator("group.launch"));
        mgr.add((IContributionItem)new GroupMarker("group.launch.rundebug"));
        mgr.add((IContributionItem)new Separator("group.launch.additions"));
        mgr.add((IContributionItem)new Separator("group.delete"));
        mgr.add((IContributionItem)new Separator("group.additions"));
        final IMenuService service = (IMenuService)this.getSite().getService(IMenuService.class);
        if (service != null) {
            service.populateContributionManager((ContributionManager)mgr, "menu:" + this.getId());
        }
        if (mgr.getSize() > 5) {
            this.toolBarManager.add((IContributionItem)new ControlContribution("toolbarmenu"){

                protected Control createControl(Composite parent) {
                    final ToolBar tb = new ToolBar(parent, 0x800000);
                    ToolItem item = new ToolItem(tb, 8);
                    item.setImage(UIPlugin.getImage("MenuAction"));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MenuManager mgr = new MenuManager();
                            mgr.add((IContributionItem)new Separator("group.launch"));
                            mgr.add((IContributionItem)new GroupMarker("group.launch.rundebug"));
                            mgr.add((IContributionItem)new Separator("group.launch.additions"));
                            mgr.add((IContributionItem)new Separator("group.delete"));
                            mgr.add((IContributionItem)new Separator("group.additions"));
                            service.populateContributionManager((ContributionManager)mgr, "menu:" + AbstractCustomFormToolkitEditorPage.this.getId());
                            Menu menu = mgr.createContextMenu((Control)tb);
                            menu.setVisible(true);
                        }
                    });
                    return tb;
                }
            });
        }
    }

    protected Action doCreateHelpAction(String contextHelpId) {
        Assert.isNotNull((Object)contextHelpId);
        return new HelpAction(contextHelpId);
    }

    protected IContributionItem doCreateLinkContribution(IToolBarManager tbManager) {
        return null;
    }

    protected abstract void doCreateFormContent(Composite var1, CustomFormToolkit var2);

    protected static class HelpAction
    extends Action {
        final String helpID;

        public HelpAction(String helpID) {
            super(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_label, 1);
            Assert.isNotNull((Object)helpID);
            this.helpID = helpID;
            this.setToolTipText(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_tooltip);
            this.setImageDescriptor(UIPlugin.getImageDescriptor("HelpAction"));
        }

        public void run() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IContext context = HelpSystem.getContext((String)HelpAction.this.helpID);
                    if (context != null) {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
                    } else {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp();
                    }
                }
            });
        }
    }
}

