/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildChain;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.WorkspaceBuild;

@Named(value="Build all projects")
public class TaskBuildWorkspace {
    @Execute
    public IStatus build(IEclipseContext taskContext, TaskingLog log, TaskProgressTracker tracker, WorkspaceBuild wb, TeaBuildConfig config) throws Exception {
        IStatus result;
        TeaBuildChain chain = TeaBuildChain.make(taskContext, Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        if (config.batchCompile) {
            this.setWorkspaceBuildOrder(null);
        }
        if ((result = chain.execute(tracker, config.failureThreshold)).getSeverity() > 2) {
            log.error("Errors during build: " + result);
        }
        return result;
    }

    private void setWorkspaceBuildOrder(List<String> buildOrder) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setBuildOrder(buildOrder == null ? null : buildOrder.toArray(new String[buildOrder.size()]));
        description.setMaxBuildIterations(3);
        workspace.setDescription(description);
    }
}

