/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tea.core.annotations.TaskReloadConfiguration;
import org.eclipse.tea.core.services.TaskingLog;
import org.osgi.service.prefs.BackingStoreException;

@TaskReloadConfiguration
public class TaskImportPreferences {
    private final File file;
    private final boolean force;

    public TaskImportPreferences(File file, boolean force) {
        this.file = file;
        this.force = force;
    }

    @Execute
    public void importFile(TaskingLog log) {
        try {
            FileInputStream in = new FileInputStream(this.file.getAbsolutePath());
            IPreferencesService preferencesService = Platform.getPreferencesService();
            IExportedPreferences readPreferences = preferencesService.readPreferences((InputStream)in);
            final PreferenceVisitor visitor = new PreferenceVisitor();
            readPreferences.accept((IPreferenceNodeVisitor)visitor);
            IPreferenceFilter filter = new IPreferenceFilter(){

                public String[] getScopes() {
                    String[] scopes = new String[visitor.filteredNodes.keySet().size()];
                    scopes = visitor.filteredNodes.keySet().toArray(scopes);
                    return scopes;
                }

                public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
                    return visitor.filteredNodes.get(scope);
                }
            };
            Display.getDefault().syncExec(() -> {
                try {
                    preferencesService.applyPreferences((IEclipsePreferences)readPreferences, new IPreferenceFilter[]{filter});
                }
                catch (CoreException e) {
                    log.error("Error importing preferences: " + this.file, (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error importing preferences: " + this.file, (Throwable)e);
        }
    }

    public String toString() {
        return "Import Preferences from " + this.file;
    }

    private class PreferenceVisitor
    implements IPreferenceNodeVisitor {
        public Map<String, Map<String, PreferenceFilterEntry[]>> filteredNodes = new HashMap<String, Map<String, PreferenceFilterEntry[]>>();

        public PreferenceVisitor() {
            this.filteredNodes.put("instance", new HashMap());
            this.filteredNodes.put("configuration", new HashMap());
        }

        private List<IEclipsePreferences> getPath(IEclipsePreferences leaf) {
            ArrayList<IEclipsePreferences> result = new ArrayList<IEclipsePreferences>();
            IEclipsePreferences current = leaf;
            while (current != null) {
                result.add(current);
                current = (IEclipsePreferences)current.parent();
            }
            Collections.reverse(result);
            if (result.size() < 2) {
                return Collections.emptyList();
            }
            return result.subList(2, result.size());
        }

        private IEclipsePreferences getScopeNode(IScopeContext scope, List<IEclipsePreferences> path) {
            IEclipsePreferences node = scope.getNode(path.get(0).name());
            int i = 1;
            while (i < path.size()) {
                node = (IEclipsePreferences)node.node(path.get(i).name());
                ++i;
            }
            return node;
        }

        private String getPathString(List<IEclipsePreferences> path) {
            String pathString = "";
            for (IEclipsePreferences node : path) {
                pathString = String.valueOf(pathString) + node.name() + "/";
            }
            pathString = pathString.substring(0, pathString.length() - 1);
            return pathString;
        }

        public boolean visit(IEclipsePreferences node) throws BackingStoreException {
            if (node.keys().length == 0) {
                return true;
            }
            List<IEclipsePreferences> path = this.getPath(node);
            if (path.isEmpty()) {
                return true;
            }
            IScopeContext setContext = null;
            if (node.absolutePath().startsWith("/instance")) {
                setContext = InstanceScope.INSTANCE;
            } else if (node.absolutePath().startsWith("/configuration")) {
                setContext = ConfigurationScope.INSTANCE;
            } else {
                return true;
            }
            IEclipsePreferences setNode = this.getScopeNode(setContext, path);
            IEclipsePreferences defNode = this.getScopeNode(DefaultScope.INSTANCE, path);
            ArrayList<PreferenceFilterEntry> preferenceFilterEntries = new ArrayList<PreferenceFilterEntry>();
            String[] stringArray = node.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String setValue = setNode.get(key, null);
                String defValue = defNode.get(key, null);
                if (setValue != null && !TaskImportPreferences.this.force) {
                    if (defValue != null && setValue.equals(defValue)) {
                        preferenceFilterEntries.add(new PreferenceFilterEntry(key));
                    }
                } else {
                    preferenceFilterEntries.add(new PreferenceFilterEntry(key));
                }
                ++n2;
            }
            if (preferenceFilterEntries.size() > 0) {
                PreferenceFilterEntry[] preferenceFilters = new PreferenceFilterEntry[preferenceFilterEntries.size()];
                preferenceFilters = preferenceFilterEntries.toArray(preferenceFilters);
                this.filteredNodes.get(setContext.getName()).put(this.getPathString(path), preferenceFilters);
            }
            return true;
        }
    }
}

