/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.PrintWriter;
import org.eclipse.actf.model.internal.dom.sgml.IPrintXML;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLCharacterData;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class SGMLText
extends SGMLCharacterData
implements Text,
IPrintXML {
    private static final long serialVersionUID = -579697061500329505L;
    private boolean isWhitespace = false;

    public SGMLText(String string, Document document) {
        super(string, document);
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public Text splitText(int n) throws DOMException {
        SGMLText sGMLText;
        try {
            sGMLText = new SGMLText(this.text.substring(n), this.ownerDocument);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMException(1, stringIndexOutOfBoundsException.getMessage()){
                private static final long serialVersionUID = -1750553827974411478L;
            };
        }
        sGMLText.previousSibling = this;
        sGMLText.parent = this.parent;
        this.nextSibling = sGMLText;
        this.text = this.text.substring(n);
        return this;
    }

    public String toString() {
        SGMLDocument sGMLDocument = (SGMLDocument)this.getOwnerDocument();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.text.length()) {
            char c = this.text.charAt(n);
            Character c2 = new Character(c);
            String string = sGMLDocument.getEntityOrigin(c2);
            if (string != null) {
                stringBuffer.append(String.valueOf('&') + string + ';');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toXMLString() {
        SGMLDocument sGMLDocument = (SGMLDocument)this.getOwnerDocument();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.text.length()) {
            char c = this.text.charAt(n);
            Character c2 = new Character(c);
            String string = sGMLDocument.getEntityOrigin(c2);
            if (string != null) {
                stringBuffer.append("&#" + c + ';');
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void printAsXML(PrintWriter printWriter, int n, boolean bl) {
        printWriter.print(this.toXMLString());
    }

    public void printAsSGML(PrintWriter printWriter, int n, boolean bl) {
        printWriter.print(this.toString());
    }

    public boolean getIsWhitespaceInElementContent() {
        return this.isWhitespace;
    }

    void setIsWhitespaceInElementContent(boolean bl) {
        this.isWhitespace = bl;
    }

    public String getWholeText() {
        return null;
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public Text replaceWholeText(String string) throws DOMException {
        return null;
    }
}

