/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.properties.IPropertyInvoke;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTreeViewer
extends TreeViewer {
    private Map<String, String> lastContents = new HashMap<String, String>();

    public PropertyTreeViewer(Composite composite, int n) {
        this(new Tree(composite, n));
    }

    public PropertyTreeViewer(Composite composite) {
        this(composite, 2818);
    }

    public PropertyTreeViewer(Tree tree) {
        super(tree);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setText(Messages.msaa_name);
        TreeColumn treeColumn2 = new TreeColumn(tree, 0);
        treeColumn2.setText(Messages.msaa_value);
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Tree tree = PropertyTreeViewer.this.getTree();
                Rectangle rectangle = tree.getClientArea();
                TreeColumn[] treeColumnArray = tree.getColumns();
                if (rectangle.width > 0) {
                    treeColumnArray[0].setWidth(rectangle.width * 40 / 100);
                    treeColumnArray[1].setWidth(rectangle.width - treeColumnArray[0].getWidth() - 4);
                    tree.removeControlListener((ControlListener)this);
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (13 == keyEvent.keyCode) {
                    PropertyTreeViewer.this.invokeSource();
                }
            }
        });
    }

    private void invokeSource() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (iStructuredSelection.size() == 1) {
            this.invoke(iStructuredSelection.getFirstElement());
        }
    }

    public void invoke(Object object) {
        PropertyTreeEntry propertyTreeEntry;
        IPropertySource iPropertySource;
        if (object instanceof PropertyTreeEntry && (iPropertySource = (propertyTreeEntry = (PropertyTreeEntry)object).getPropertySource()) instanceof IPropertyInvoke) {
            MSAAViewRegistory.addUpdateRef();
            try {
                if (((IPropertyInvoke)iPropertySource).invoke(propertyTreeEntry.getId(), this.getControl().getShell())) {
                    this.refresh(object);
                }
            }
            finally {
                MSAAViewRegistory.releaseUpdateRef();
            }
        }
    }

    public void refresh() {
        this.setInput(this.getRoot());
    }

    protected void inputChanged(Object object, Object object2) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Tree tree = (Tree)PropertyTreeViewer.this.getControl();
                tree.setRedraw(false);
                ISelection iSelection = PropertyTreeViewer.this.getSelection();
                Object[] objectArray = PropertyTreeViewer.this.getExpandedElements();
                PropertyTreeViewer.this.lastContents.clear();
                PropertyTreeViewer.this.getContents(PropertyTreeViewer.this.lastContents, tree.getItems());
                PropertyTreeViewer.this.removeAll((Control)tree);
                tree.setData(PropertyTreeViewer.this.getRoot());
                PropertyTreeViewer.this.createChildren((Widget)tree);
                int n = 0;
                while (n < objectArray.length) {
                    PropertyTreeViewer.this.setExpandedState(objectArray[n], true);
                    ++n;
                }
                if (PropertyTreeViewer.this.getExpandedElements().length == 0 && tree.getItemCount() > 0) {
                    PropertyTreeViewer.this.setExpandedState(tree.getItem(0).getData(), true);
                }
                PropertyTreeViewer.this.setSelection(iSelection, true);
                tree.setRedraw(true);
            }
        });
    }

    private void getContents(Map<String, String> map, TreeItem[] treeItemArray) {
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n];
            Object object = treeItem.getData();
            if (object instanceof PropertyTreeEntry) {
                PropertyTreeEntry propertyTreeEntry = (PropertyTreeEntry)object;
                map.put(propertyTreeEntry.getPath(), treeItem.getText(1));
            }
            this.getContents(map, treeItem.getItems());
            ++n;
        }
    }

    public Map<String, String> getLastContents() {
        return this.lastContents;
    }
}

