/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.model.flash.util.AsVersionChecker;
import org.eclipse.actf.model.flash.util.SwfInfo;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.model.internal.flash.proxy.SwfStageResizer;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverrider;
import org.eclipse.actf.util.httpproxy.util.CacheMap;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class SWFBootloader
implements IHTTPSessionOverrider {
    private static final String MUST_REVALIDATE = "must-revalidate";
    private static final String NO_CACHE = "no-cache";
    private static final String OK = "OK";
    private static final String RESPONSE_200 = "200";
    private static final Logger LOGGER = Logger.getLogger(SWFBootloader.class);
    private static byte[] bootLoaderSWF;
    private static byte[] bootLoaderSWFv9;
    private boolean replacedFlag;
    private boolean bootloaderRequestingFlag;
    private boolean hasXFlashVersionHeader;
    private IHTTPRequestMessage sessionRequest;
    private IHTTPResponseMessage sessionResponse;
    private final int id;
    private CachedSlot sessionCachedSlot;
    private static final int MAX_REFERER_LENGTH = 128;

    public IHTTPRequestMessage getSessionRequest() {
        return this.sessionRequest;
    }

    public IHTTPResponseMessage getSessionResponse() {
        return this.sessionResponse;
    }

    public SWFBootloader(int n) {
        this.id = n;
    }

    private static byte[] readSWFBootLoaderFile(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }

    public static void setSWFBootLoaderFile(InputStream inputStream) {
        bootLoaderSWF = SWFBootloader.readSWFBootLoaderFile(inputStream);
    }

    public static void setSWFBootLoaderFileV9(InputStream inputStream) {
        bootLoaderSWFv9 = SWFBootloader.readSWFBootLoaderFile(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedObject(IClientStateManager iClientStateManager, String string) {
        CacheMap cacheMap = this.getCacheMap(iClientStateManager);
        if (string.length() > 128) {
            CacheMap cacheMap2 = cacheMap;
            synchronized (cacheMap2) {
                return cacheMap.matchStartsWith(string);
            }
        }
        CacheMap cacheMap3 = cacheMap;
        synchronized (cacheMap3) {
            return cacheMap.get((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheObject(IClientStateManager iClientStateManager, String string, Object object) {
        CacheMap cacheMap;
        CacheMap cacheMap2 = cacheMap = this.getCacheMap(iClientStateManager);
        synchronized (cacheMap2) {
            cacheMap.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeObject(IClientStateManager iClientStateManager, String string) {
        CacheMap cacheMap;
        CacheMap cacheMap2 = cacheMap = this.getCacheMap(iClientStateManager);
        synchronized (cacheMap2) {
            return cacheMap.remove((Object)string);
        }
    }

    private CacheMap getCacheMap(IClientStateManager iClientStateManager) {
        CacheMap cacheMap = (CacheMap)iClientStateManager.get(SWFBootloader.class);
        if (cacheMap == null) {
            cacheMap = new CacheMap(256, 20);
            iClientStateManager.put(SWFBootloader.class, (Object)cacheMap);
        }
        return cacheMap;
    }

    private static IHTTPResponseMessage bootloaderResponseMessage(IHTTPRequestMessage iHTTPRequestMessage) {
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bootLoaderSWF);
        iHTTPResponseMessage.setHeader(IHTTPHeader.CACHE_CONTROL_A, MUST_REVALIDATE.getBytes());
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return iHTTPResponseMessage;
    }

    private static IHTTPResponseMessage bootloaderResponseMessageV9(IHTTPRequestMessage iHTTPRequestMessage, int n, int n2) {
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])SwfStageResizer.resize(bootLoaderSWFv9, n, n2));
        iHTTPResponseMessage.setHeader(IHTTPHeader.CACHE_CONTROL_A, MUST_REVALIDATE.getBytes());
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return iHTTPResponseMessage;
    }

    public boolean replaceRequest(IClientStateManager iClientStateManager, IHTTPRequestMessage iHTTPRequestMessage) throws IOException {
        Object object4;
        Object object2;
        this.replacedFlag = false;
        if (!WaXcodingConfig.getInstance().getSWFBootloaderFlag()) {
            return false;
        }
        IHTTPHeader iHTTPHeader = iHTTPRequestMessage.getHeader(IHTTPHeader.USER_AGENT_A);
        boolean bl = this.hasXFlashVersionHeader = iHTTPHeader != null && new String(iHTTPHeader.getValue()).contains("MSIE");
        if (this.hasXFlashVersionHeader && iHTTPRequestMessage.getHeader(SWFUtil.X_FLASH_VERSION_A) == null) {
            return false;
        }
        String string = iHTTPRequestMessage.getRequestURIString();
        String string2 = iHTTPRequestMessage.getMethodAsString();
        Object object3 = this.getCachedObject(iClientStateManager, string);
        if (LOGGER.isDebugEnabled()) {
            object2 = new StringBuffer("method:");
            ((StringBuffer)object2).append(string2);
            ((StringBuffer)object2).append(' ');
            ((StringBuffer)object2).append(string);
            for (Object object4 : iHTTPRequestMessage.getHeaders()) {
                if (object4.isRemoved()) continue;
                ((StringBuffer)object2).append(object4.toString());
                ((StringBuffer)object2).append('\n');
            }
            this.DEBUG(((StringBuffer)object2).toString());
        }
        if ("POST".equals(string2) && object3 instanceof CachedSlot) {
            object2 = new ByteArrayOutputStream();
            try {
                iHTTPRequestMessage.write(0L, (OutputStream)object2);
            }
            catch (TimeoutException timeoutException) {}
            if (LOGGER.isDebugEnabled()) {
                this.DEBUG("Bootloader's POST command:" + new String(((ByteArrayOutputStream)object2).toByteArray()));
            }
            this.INFO("bootloader requests the original SWF:" + string);
            this.replacedFlag = true;
            this.bootloaderRequestingFlag = true;
            this.sessionCachedSlot = (CachedSlot)object3;
            this.sessionRequest = this.sessionCachedSlot.request;
            this.sessionRequest.removeHeader("If-Modified-Since".getBytes());
            this.sessionResponse = this.sessionCachedSlot.response;
            return true;
        }
        object2 = iHTTPRequestMessage.getHeader(IHTTPHeader.REFERER_A);
        if (object2 != null) {
            object4 = new String(object2.getValue()).trim();
            String string3 = string;
            Object object5 = this.getCachedObject(iClientStateManager, (String)object4);
            if (object5 != null) {
                this.INFO(String.valueOf(string3) + " seems to be referred by " + (String)object4);
                if (object3 == null) {
                    this.cacheObject(iClientStateManager, string3, true);
                }
                return false;
            }
        } else if (!this.hasXFlashVersionHeader) {
            this.INFO(String.valueOf(string) + " seems to be referred by other swf");
            return false;
        }
        if (object3 instanceof CachedSlot) {
            object4 = (CachedSlot)object3;
        } else {
            object4 = new CachedSlot(string);
            this.cacheObject(iClientStateManager, string, object4);
        }
        ((CachedSlot)object4).request = iHTTPRequestMessage;
        this.replacedFlag = true;
        this.bootloaderRequestingFlag = false;
        this.sessionCachedSlot = object4;
        this.sessionRequest = iHTTPRequestMessage;
        this.sessionRequest.removeHeader(IHTTPHeader.IF_MODIFIED_SINCE_A);
        this.sessionRequest.removeHeader(IHTTPHeader.ACCEPT_ENCODING_A);
        this.sessionResponse = null;
        return true;
    }

    public boolean replaceResponse(IClientStateManager iClientStateManager, IHTTPRequestMessage iHTTPRequestMessage, IHTTPResponseMessage iHTTPResponseMessage, int n) throws IOException, TimeoutException {
        IHTTPResponsePushbackMessage iHTTPResponsePushbackMessage;
        IPushbackMessageBody iPushbackMessageBody;
        if (!this.replacedFlag) {
            return false;
        }
        if (this.bootloaderRequestingFlag) {
            if (iHTTPResponseMessage != this.sessionCachedSlot.response) {
                iHTTPResponseMessage.setHeader(IHTTPHeader.CACHE_CONTROL_A, NO_CACHE.getBytes());
            }
            this.sessionResponse = iHTTPResponseMessage;
            return true;
        }
        if (this.hasXFlashVersionHeader) {
            if (!SWFUtil.isPossiblySWFContentType(iHTTPResponseMessage)) {
                return false;
            }
        } else if (!SWFUtil.isSWFContentType(iHTTPResponseMessage)) {
            this.removeObject(iClientStateManager, this.sessionCachedSlot.uri);
            return false;
        }
        if ((iPushbackMessageBody = (iHTTPResponsePushbackMessage = HTTPUtil.createHTTPResponsePushbackMessage((IHTTPResponseMessage)iHTTPResponseMessage, (int)0x100000)).getPushbackMessageBody()) == null) {
            return false;
        }
        PushbackInputStream pushbackInputStream = iPushbackMessageBody.getMessageBodyPushBackInputStream();
        int n2 = SWFUtil.isSWF(pushbackInputStream);
        SwfInfo swfInfo = null;
        this.INFO("The incoming SWF is version " + n2);
        String string = iHTTPRequestMessage.getRequestURIString();
        if (n2 >= WaXcodingConfig.getInstance().getSWFTranscodingMinimumVersion() && n2 < 10) {
            Object object;
            IHTTPResponseMessage iHTTPResponseMessage2;
            if (n2 < 9) {
                iHTTPResponseMessage2 = SWFBootloader.bootloaderResponseMessage(iHTTPRequestMessage);
                this.INFO("bootloader is used for " + string);
            } else {
                this.DEBUG("Checking AS version...");
                object = new AsVersionChecker();
                ((AsVersionChecker)object).setSwfFile(pushbackInputStream);
                swfInfo = ((AsVersionChecker)object).getSwfInfo();
                int n3 = swfInfo.getAsVersion();
                int n4 = swfInfo.getFrameSizeX();
                int n5 = swfInfo.getFrameSizeY();
                this.INFO("AS version of SWF: " + n3);
                switch (n3) {
                    case 3: {
                        this.INFO("Resizing bootloader...");
                        iHTTPResponseMessage2 = SWFBootloader.bootloaderResponseMessageV9(iHTTPRequestMessage, n4, n5);
                        this.INFO("bootloader v9 is used for " + string);
                        break;
                    }
                    case 2: {
                        iHTTPResponseMessage2 = SWFBootloader.bootloaderResponseMessage(iHTTPRequestMessage);
                        this.INFO("bootloader (v9-as2) is used for " + string);
                        break;
                    }
                    default: {
                        this.INFO("Flash V9 (AS version:" + n3 + "). The bootloader is not applied to " + string);
                        this.sessionResponse = iHTTPResponsePushbackMessage;
                        return true;
                    }
                }
            }
            this.sessionResponse = iHTTPResponseMessage2;
            object = new ByteArrayOutputStream();
            iHTTPResponsePushbackMessage.writeBody((long)n, (IMessageBody)iPushbackMessageBody, (OutputStream)object);
            IHTTPResponseMessage iHTTPResponseMessage3 = HTTPUtil.createHTTPResponseInMemoryMessage((IHTTPResponseMessage)iHTTPResponseMessage, (byte[])((ByteArrayOutputStream)object).toByteArray());
            iHTTPResponseMessage3.setHeader(IHTTPHeader.CACHE_CONTROL_A, "no-cache,must-revalidate".getBytes());
            iHTTPResponseMessage3.setHeader(IHTTPHeader.PRAGMA_A, NO_CACHE.getBytes());
            iHTTPResponseMessage3.setHeader(IHTTPHeader.EXPIRES_A, "-1".getBytes());
            this.INFO("The original response is cached for later use.");
            if (LOGGER.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("CachedMessage: ");
                for (IHTTPHeader iHTTPHeader : iHTTPResponseMessage3.getHeaders()) {
                    if (iHTTPHeader.isRemoved()) continue;
                    stringBuffer.append(iHTTPHeader.toString());
                    stringBuffer.append('\n');
                }
                this.DEBUG(stringBuffer.toString());
            }
            this.sessionCachedSlot.response = iHTTPResponseMessage3;
            return true;
        }
        this.INFO("Due to the unsupported version, the bootloader is not applied to " + string);
        this.sessionResponse = iHTTPResponsePushbackMessage;
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[id:").append(this.id).append("] SWFBootloader");
        return stringBuffer.toString();
    }

    private final void INFO(String string) {
        LOGGER.info(string);
    }

    private final void DEBUG(String string) {
        LOGGER.debug(string);
    }

    private static class CachedSlot {
        public final String uri;
        public IHTTPRequestMessage request;
        public IHTTPResponseMessage response;

        CachedSlot(String string) {
            this.uri = string;
        }
    }
}

