/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.actf.util.command.CLArgumentException;
import org.eclipse.actf.util.command.CLSwitch;

public class CLArgumentProcessor {
    private Map _switchMap;
    private String _preUsage;
    private String _postUsage;
    private boolean _preserveCase = false;

    public CLArgumentProcessor() {
        this(new CLSwitch[0]);
    }

    public CLArgumentProcessor(CLSwitch[] cLSwitchArray) {
        this.setSwitches(cLSwitchArray);
    }

    public CLArgumentProcessor(boolean bl) {
        this(new CLSwitch[0]);
        this._preserveCase = bl;
    }

    public CLArgumentProcessor(CLSwitch[] cLSwitchArray, boolean bl) {
        this._preserveCase = bl;
        this.setSwitches(cLSwitchArray);
    }

    public CLSwitch getSwitch(String string) {
        if (this._preserveCase) {
            return (CLSwitch)this._switchMap.get(string);
        }
        return (CLSwitch)this._switchMap.get(string.toLowerCase());
    }

    public CLSwitch[] getSwitches() {
        return this._switchMap.values().toArray(new CLSwitch[this._switchMap.size()]);
    }

    public void setSwitches(CLSwitch[] cLSwitchArray) {
        if (this._switchMap == null) {
            this._switchMap = new HashMap();
        } else {
            this._switchMap.clear();
        }
        int n = 0;
        while (cLSwitchArray != null && n < cLSwitchArray.length) {
            if (this._preserveCase) {
                this._switchMap.put(cLSwitchArray[n].getName(), cLSwitchArray[n]);
            } else {
                this._switchMap.put(cLSwitchArray[n].getName().toLowerCase(), cLSwitchArray[n]);
            }
            ++n;
        }
    }

    public void addSwitch(CLSwitch cLSwitch) {
        if (this._preserveCase) {
            this._switchMap.put(cLSwitch.getName(), cLSwitch);
        } else {
            this._switchMap.put(cLSwitch.getName().toLowerCase(), cLSwitch);
        }
    }

    public CLSwitch removeSwitch(String string) {
        if (this._preserveCase) {
            return (CLSwitch)this._switchMap.remove(string);
        }
        return (CLSwitch)this._switchMap.remove(string.toLowerCase());
    }

    public void processArguments(String[] stringArray) throws CLArgumentException {
        if (stringArray.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        int n = 0;
        while (n < stringArray.length) {
            block12: {
                Object object = this.nameIfValidSwitch(stringArray[n]);
                if (object == null) {
                    System.err.println("Unknown switch: " + stringArray[n]);
                } else {
                    CLSwitch cLSwitch = this.getSwitch((String)object);
                    if (cLSwitch.getValueType().equals(Boolean.class) || cLSwitch.getValueType().equals(Boolean.TYPE)) {
                        cLSwitch.setValue("__true__");
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n2 = n;
                        int n3 = cLSwitch.getExpectedNumberOfArgs();
                        while (++n < stringArray.length && n - n2 <= n3 & this.nameIfValidSwitch(stringArray[n]) == null) {
                            stringBuffer.append(stringArray[n]);
                            stringBuffer.append(' ');
                        }
                        if (n < stringArray.length && n - n2 > n3 && this.nameIfValidSwitch(stringArray[n]) == null) {
                            do {
                                System.err.println("Ignoring argument: " + stringArray[n] + " - beyond expected number of args for switch " + cLSwitch.getName());
                                if (Character.isLetter(stringArray[n].charAt(0))) continue;
                                System.err.println("May be unknown switch: " + stringArray[n]);
                            } while (++n < stringArray.length && this.nameIfValidSwitch(stringArray[n]) == null);
                        }
                        try {
                            cLSwitch.resolveValue(stringBuffer.toString().trim());
                        }
                        catch (Exception exception) {
                            System.err.println("Warning: could not resolve argument " + stringBuffer.toString() + " for switch " + cLSwitch.getName() + " to type " + cLSwitch.getValueType().getName());
                            --n;
                            break block12;
                        }
                        --n;
                    }
                }
            }
            ++n;
        }
        for (Object object : this._switchMap.values()) {
            if (!((CLSwitch)object).isRequired() || ((CLSwitch)object).getResolvedValue() != null) continue;
            throw new CLArgumentException("Switch " + ((CLSwitch)object).getName() + " is required and has not been set");
        }
    }

    public int getIntArgument(String string) throws CLArgumentException {
        CLSwitch cLSwitch = this.getSwitch(string);
        int n = -1;
        if (cLSwitch != null) {
            if (cLSwitch.getResolvedValue() != null && (Integer.class.isAssignableFrom(cLSwitch.getValueType()) || cLSwitch.getValueType().equals(Integer.TYPE))) {
                n = (Integer)cLSwitch.getResolvedValue();
            } else {
                throw new CLArgumentException("Switch " + cLSwitch.getName() + " does not have an associated value of type int");
            }
        }
        return n;
    }

    public long getLongArgument(String string) throws CLArgumentException {
        CLSwitch cLSwitch = this.getSwitch(string);
        long l = -1L;
        if (cLSwitch != null) {
            if (cLSwitch.getResolvedValue() != null && (Long.class.isAssignableFrom(cLSwitch.getValueType()) || cLSwitch.getValueType().equals(Long.TYPE))) {
                l = (Long)cLSwitch.getResolvedValue();
            } else {
                throw new CLArgumentException("Switch " + cLSwitch.getName() + " does not have an associated value of type long");
            }
        }
        return l;
    }

    public float getFloatArgument(String string) throws CLArgumentException {
        CLSwitch cLSwitch = this.getSwitch(string);
        float f = -1.0f;
        if (cLSwitch != null) {
            if (cLSwitch.getResolvedValue() != null && (Float.class.isAssignableFrom(cLSwitch.getValueType()) || cLSwitch.getValueType().equals(Float.TYPE))) {
                f = ((Float)cLSwitch.getResolvedValue()).floatValue();
            } else {
                throw new CLArgumentException("Switch " + cLSwitch.getName() + " does not have an associated value of type float");
            }
        }
        return f;
    }

    public double getDoubleArgument(String string) throws CLArgumentException {
        CLSwitch cLSwitch = this.getSwitch(string);
        double d = -1.0;
        if (cLSwitch != null) {
            if (cLSwitch.getResolvedValue() != null && (Double.class.isAssignableFrom(cLSwitch.getValueType()) || cLSwitch.getValueType().equals(Double.TYPE))) {
                d = ((Number)cLSwitch.getResolvedValue()).doubleValue();
            } else {
                throw new CLArgumentException("Switch " + cLSwitch.getName() + " does not have an associated value of type double");
            }
        }
        return d;
    }

    public boolean getBooleanArgument(String string) throws CLArgumentException {
        CLSwitch cLSwitch = this.getSwitch(string);
        boolean bl = false;
        if (cLSwitch != null) {
            if (Boolean.class.isAssignableFrom(cLSwitch.getValueType()) || cLSwitch.getValueType().equals(Boolean.TYPE)) {
                bl = cLSwitch.getResolvedValue() != null && (Boolean)cLSwitch.getResolvedValue() != false;
            } else {
                throw new CLArgumentException("Switch " + cLSwitch.getName() + " does not have an associated value of type bool");
            }
        }
        return bl;
    }

    public Object getArgument(String string) {
        CLSwitch cLSwitch = this.getSwitch(string);
        return cLSwitch == null ? null : cLSwitch.getResolvedValue();
    }

    public String nameIfValidSwitch(String string) {
        int n = 0;
        String string2 = null;
        while (n < string.length() && !Character.isLetter(string.charAt(n++))) {
        }
        String string3 = string.substring(0, n - 1);
        String string4 = string.substring(n - 1);
        CLSwitch cLSwitch = this.getSwitch(string4);
        if (cLSwitch != null) {
            if (this._preserveCase && cLSwitch.getFullSwitchName().equals(String.valueOf(string3) + string4)) {
                string2 = string4;
            } else if (!this._preserveCase && cLSwitch.getFullSwitchName().equalsIgnoreCase(String.valueOf(string3) + string4)) {
                string2 = string4;
            }
        }
        return string2;
    }

    public void prependToUsage(String string) {
        this._preUsage = string;
    }

    public void appendToUsage(String string) {
        this._postUsage = string;
    }

    protected void printUsage() {
        Iterator iterator = this._switchMap.values().iterator();
        System.out.println(this._preUsage == null ? "" : this._preUsage);
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        while (iterator.hasNext()) {
            CLSwitch cLSwitch = (CLSwitch)iterator.next();
            System.out.print(String.valueOf(cLSwitch.getFullSwitchName()) + " " + cLSwitch.getDescription());
            System.out.print(cLSwitch.isRequired() ? " [required] " : " ");
            System.out.println(cLSwitch.getDefaultValue() != null ? " {default=" + cLSwitch.getDefaultValue() + "}" : "");
        }
        System.out.println();
        System.out.println(this._postUsage == null ? "" : this._postUsage);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        Iterator iterator = this._switchMap.values().iterator();
        stringBuffer.append(":\n");
        while (iterator.hasNext()) {
            CLSwitch cLSwitch = (CLSwitch)iterator.next();
            Object object = cLSwitch.getResolvedValue();
            stringBuffer.append(cLSwitch.getFullSwitchName());
            stringBuffer.append('[');
            stringBuffer.append("arg:" + cLSwitch.getValue());
            stringBuffer.append(',');
            stringBuffer.append("resolved:");
            stringBuffer.append(object == null ? "<unresolved>" : object.toString());
            if (object != null) {
                stringBuffer.append(',');
                stringBuffer.append("type:" + cLSwitch.getResolvedValue().getClass().getName());
            }
            stringBuffer.append(']');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

