/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class CVDOp
implements ILowVisionOperator {
    private static final boolean PRESERVE_SRGB_Y = false;
    private static final float R_YY = 0.21347046f;
    private static final float R_X = 0.6524872f;
    private static final float R_Y = 0.32519758f;
    private static final float G_YY = 0.71173096f;
    private static final float G_X = 0.3305722f;
    private static final float G_Y = 0.5944182f;
    private static final float B_YY = 0.07168579f;
    private static final float B_X = 0.1482494f;
    private static final float B_Y = 0.07736899f;
    private static final float W_YY = 0.9963379f;
    private static final float W_X = 0.34579438f;
    private static final float W_Y = 0.35854465f;
    private static final float C1_X = 0.747f;
    private static final float C1_Y = 0.253f;
    private static final float C2_X = 1.08f;
    private static final float C2_Y = -0.08f;
    private static final float C3_X = 0.171f;
    private static final float C3_Y = 0.0f;
    private static float BW_A = 1.4233501f;
    private static float BW_B = 0.07736899f - BW_A * 0.1482494f;
    private static float BR_A = -0.5f;
    private static float BR_B = 0.525f;
    private int type = 0;

    public CVDOp(int n) {
        this.type = n;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException {
        WritableRaster writableRaster;
        DataBufferInt dataBufferInt;
        int[] nArray;
        int n;
        if (this.type != 1 && this.type != 2 && this.type != 3) {
            throw new LowVisionException("Invalid type: " + this.type);
        }
        WritableRaster writableRaster2 = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster2.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getData();
        int n2 = nArray2.length;
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        }
        if (n2 != (n = (nArray = (dataBufferInt = (DataBufferInt)(writableRaster = bufferedImage3.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = new Integer(nArray2[n3]);
            Integer n5 = null;
            n5 = (Integer)hashMap.get(n4);
            if (n5 == null) {
                n5 = new Integer(CVDOp.convertColor(nArray2[n3], this.type));
                hashMap.put(n4, n5);
            }
            nArray[n3] = n5;
            ++n3;
        }
        bufferedImage3.setData(writableRaster);
        return bufferedImage3;
    }

    public IInt2D filter(Int2D int2D, Int2D int2D2) throws LowVisionException {
        if (this.type != 1 && this.type != 2 && this.type != 3) {
            throw new LowVisionException("Invalid type: " + this.type);
        }
        Int2D int2D3 = int2D2;
        if (int2D2 == null) {
            int2D3 = new Int2D(int2D.getWidth(), int2D.getHeight());
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < int2D.getHeight()) {
            int n2 = 0;
            while (n2 < int2D.getWidth()) {
                int n3 = int2D.getData()[n][n2];
                Integer n4 = new Integer(n3);
                Integer n5 = (Integer)hashMap.get(n4);
                if (n5 == null) {
                    int n6;
                    int2D3.getData()[n][n2] = n6 = CVDOp.convertColor(n3, this.type);
                    hashMap.put(n4, new Integer(n6));
                } else {
                    int2D3.getData()[n][n2] = n5;
                }
                ++n2;
            }
            ++n;
        }
        return int2D3;
    }

    public static int convertColor(int n, int n2) throws LowVisionException {
        try {
            ColorIRGB colorIRGB = new ColorIRGB(n);
            ColorYXY colorYXY = colorIRGB.toYXY();
            ColorYXY colorYXY2 = CVDOp.moveXY(colorYXY, n2);
            ColorIRGB colorIRGB2 = colorYXY2.toIRGB();
            return colorIRGB2.toInt();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting color.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ColorYXY moveXY(ColorYXY colorYXY, int n) throws LowVisionException, ColorException {
        float f = colorYXY.getYY();
        float f2 = colorYXY.getX();
        float f3 = colorYXY.getY();
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (n == 1) {
            f4 = 0.747f;
            f5 = 0.253f;
            f6 = BW_A;
            f7 = BW_B;
        } else if (n == 2) {
            f4 = 1.08f;
            f5 = -0.08f;
            f6 = BW_A;
            f7 = BW_B;
        } else {
            if (n != 3) throw new LowVisionException("Invalid type : " + n);
            f4 = 0.171f;
            f5 = 0.0f;
            f6 = BR_A;
            f7 = BR_B;
        }
        float f8 = f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (f4 != f2) {
            float f11 = (f5 - f3) / (f4 - f2);
            float f12 = f5 - f11 * f4;
            if (f11 == f6) throw new LowVisionException("(x,y) is out of sRGB's range. (x,y) = " + f2 + ", " + f3);
            f9 = (f12 - f7) / (f6 - f11);
            f10 = (f6 * f12 - f11 * f7) / (f6 - f11);
            return new ColorYXY(f8, f9, f10);
        } else {
            f9 = f4;
            f10 = f4 * f6 + f7;
        }
        return new ColorYXY(f8, f9, f10);
    }
}

