/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.tracecontrol.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.linuxtools.lttng.core.tracecontrol.model.ProviderResource;
import org.eclipse.linuxtools.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class TargetResource
extends AbstractResource
implements Comparable<TargetResource> {
    private String fName;
    private List<TraceResource> fTraces = new ArrayList<TraceResource>();
    private ProviderResource fParent;
    private String fCanCreateNewTrace = "yes";

    public TargetResource(ISubSystem parentSubSystem) {
        super(parentSubSystem);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setTraces(TraceResource[] newTraces) {
        this.fTraces.clear();
        this.fTraces.addAll(Arrays.asList(newTraces));
    }

    public TraceResource[] getTraces() {
        Object[] traces = this.fTraces.toArray(new TraceResource[0]);
        Arrays.sort(traces);
        return traces;
    }

    public TraceResource getTrace(String name) {
        for (TraceResource trace : this.fTraces) {
            if (!trace.getName().equals(name)) continue;
            return trace;
        }
        return null;
    }

    public void addTrace(TraceResource trace) {
        this.fTraces.add(trace);
    }

    public void removeTrace(TraceResource trace) {
        this.fTraces.remove(trace);
    }

    public void removeAllTraces() {
        this.fTraces.clear();
    }

    public void refreshTraces(TraceResource[] otherTraces) {
        ArrayList<TraceResource> newTraces = new ArrayList<TraceResource>();
        int i = 0;
        while (i < otherTraces.length) {
            boolean added = false;
            for (TraceResource trace : this.fTraces) {
                if (!otherTraces[i].equals(trace)) continue;
                newTraces.add(trace);
                added = true;
                break;
            }
            if (!added) {
                newTraces.add(otherTraces[i]);
            }
            ++i;
        }
        this.fTraces = newTraces;
    }

    public ProviderResource getParent() {
        return this.fParent;
    }

    public void setParent(ProviderResource provider) {
        this.fParent = provider;
    }

    public boolean isUst() {
        return this.fParent.isUst();
    }

    public String getCanCreateNewTrace() {
        return this.fCanCreateNewTrace;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TargetResource) {
            TargetResource otherTarget = (TargetResource)other;
            if (this.fName != null) {
                return this.fName.equals(otherTarget.fName);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public int compareTo(TargetResource o) {
        return this.fName.toLowerCase().compareTo(o.fName.toLowerCase());
    }

    public String toString() {
        return "[TargetResource (" + this.fName + ")]";
    }
}

