/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.actions;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ImportModuleLocationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public ImportModuleLocationAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        LogManager.logInfo((String)("Initializing fWindow: " + window), (Object)((Object)this));
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        File file = this.queryFolder();
        if (file != null) {
            IPreferenceStore p = DashboardPlugin.getDefault().getPreferenceStore();
            String folders = p.getString("ModuleFoldersPreference");
            p.setValue("ModuleFoldersPreference", String.valueOf(folders) + File.pathSeparator + file.getAbsolutePath());
            IViewPart ivp = this.fWindow.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
            ((DashboardModuleBrowserView)ivp).refresh();
        } else if (file != null) {
            String msg = MessageFormat.format(Localization.getString("ImportModuleLocationAction.FileIsNull"), file.getName());
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("ImportModuleLocationAction.Problem"), (String)msg);
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }

    private File queryFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.fWindow.getShell(), 4096);
        dialog.setText(Localization.getString("ImportModuleLocationAction.ImportDashboardModules"));
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            LogManager.logDebug((String)("queryFile: returnVal-" + path), (Object)((Object)this));
            return new File(path);
        }
        LogManager.logDebug((String)"queryFile: returnVal-null", (Object)((Object)this));
        return null;
    }
}

