/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.view.histogram;

import org.eclipse.linuxtools.gprof.view.histogram.TreeElement;

public abstract class AbstractTreeElement
implements TreeElement {
    private final TreeElement parent;
    protected int samples = -1;
    protected int calls = -1;

    public AbstractTreeElement(TreeElement parent) {
        this.parent = parent;
    }

    @Override
    public TreeElement getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int getCalls() {
        if (this.calls == -1) {
            this.calls = 0;
            for (TreeElement treeElement : this.getChildren()) {
                int i = treeElement.getCalls();
                if (i == -1) continue;
                this.calls += treeElement.getCalls();
            }
        }
        return this.calls;
    }

    @Override
    public int getSamples() {
        if (this.samples == -1) {
            this.samples = 0;
            for (TreeElement treeElement : this.getChildren()) {
                this.samples += treeElement.getSamples();
            }
        }
        return this.samples;
    }

    @Override
    public int getSourceLine() {
        return 0;
    }

    @Override
    public String getSourcePath() {
        return null;
    }

    @Override
    public TreeElement getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }
}

