/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.hidden.ProbeAliasAction;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ProbeAliasBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.views.ProbeAliasBrowserView";
    private ProbeAliasAction doubleClickAction;
    private IDoubleClickListener dblClickListener;
    private Menu menu;

    public ProbeAliasBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        super.createPartControl(parent);
        TapsetLibrary.init();
        TapsetLibrary.addListener(new BrowserView.ViewUpdater(this));
        this.refresh();
        this.makeActions();
        LogManager.logDebug((String)"End createPartControl:", (Object)((Object)this));
    }

    public void refresh() {
        LogManager.logDebug((String)"Start refresh:", (Object)((Object)this));
        this.viewer.setInput((Object)TapsetLibrary.getProbes());
        LogManager.logDebug((String)"End refresh:", (Object)((Object)this));
    }

    private void makeActions() {
        LogManager.logDebug((String)"Start makeActions:", (Object)((Object)this));
        this.doubleClickAction = new ProbeAliasAction(this.getSite().getWorkbenchWindow(), this);
        this.dblClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogManager.logDebug((String)"doubleClick fired", (Object)this);
                ProbeAliasBrowserView.this.doubleClickAction.run();
            }
        };
        this.viewer.addDoubleClickListener(this.dblClickListener);
        Control control = this.viewer.getControl();
        MenuManager manager = new MenuManager("probePopup");
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        LogManager.logDebug((String)"End makeActions:", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener(this.dblClickListener);
        }
        this.dblClickListener = null;
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }
}

