/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;

public class IntegerDeclaration
implements IDeclaration {
    private int length;
    private boolean signed;
    private int base;
    private ByteOrder byteOrder;
    private Encoding encoding;
    private final String clock;

    public IntegerDeclaration(int len, boolean signed, int base, ByteOrder byteOrder, Encoding encoding, String clock) {
        this.length = len;
        this.signed = signed;
        this.base = base;
        this.byteOrder = byteOrder;
        this.encoding = encoding;
        this.clock = clock;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isCharacter() {
        return this.length == 8 && this.encoding != Encoding.NONE;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public IntegerDefinition createDefinition(IDefinitionScope definitionScope, String fieldName) {
        return new IntegerDefinition(this, definitionScope, fieldName);
    }

    public String toString() {
        return "[declaration] integer[" + Integer.toHexString(this.hashCode()) + ']';
    }
}

