/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.ListIterator;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketIndexEntry;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketReader;

public class StreamInputReader {
    private final StreamInput streamInput;
    private final StreamInputPacketReader packetReader;
    private ListIterator<StreamInputPacketIndexEntry> packetIndexIt;
    private EventDefinition currentEvent = null;
    private int name;

    public StreamInputReader(StreamInput streamInput) {
        this.streamInput = streamInput;
        this.packetReader = new StreamInputPacketReader(this);
        this.packetIndexIt = streamInput.getIndex().listIterator();
        this.goToNextPacket();
    }

    public EventDefinition getCurrentEvent() {
        return this.currentEvent;
    }

    public StructDefinition getCurrentPacketContext() {
        return this.packetReader.getStreamPacketContextDef();
    }

    public StreamInput getStreamInput() {
        return this.streamInput;
    }

    public int getName() {
        return this.name;
    }

    public void setName(int name) {
        this.name = name;
    }

    public int getCPU() {
        return this.packetReader.getCPU();
    }

    public boolean readNextEvent() {
        if (!this.packetReader.hasMoreEvents()) {
            this.goToNextPacket();
        }
        if (this.packetReader.hasMoreEvents()) {
            try {
                this.setCurrentEvent(this.packetReader.readNextEvent());
            }
            catch (CTFReaderException cTFReaderException) {
                return false;
            }
            return true;
        }
        this.setCurrentEvent(null);
        return false;
    }

    private void goToNextPacket() {
        if (this.packetIndexIt.hasNext()) {
            this.packetReader.setCurrentPacket(this.packetIndexIt.next());
        } else {
            this.packetReader.setCurrentPacket(null);
        }
    }

    public void seek(long timestamp) {
        this.packetIndexIt = this.streamInput.getIndex().search(timestamp);
        this.goToNextPacket();
        this.readNextEvent();
        boolean done = this.getCurrentEvent() == null;
        while (!done && this.getCurrentEvent().timestamp < timestamp) {
            this.readNextEvent();
            boolean bl = done = this.getCurrentEvent() == null;
        }
    }

    public void goToLastEvent() throws CTFReaderException {
        this.packetIndexIt = this.streamInput.getIndex().search(Long.MAX_VALUE);
        while (this.packetReader.hasMoreEvents()) {
            this.packetReader.readNextEvent();
        }
    }

    public void setCurrentEvent(EventDefinition currentEvent) {
        this.currentEvent = currentEvent;
    }
}

