/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.systemtap.ui.consolelog.Subscription;
import org.eclipse.linuxtools.systemtap.ui.consolelog.actions.StopScriptAction;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ErrorStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView;
import org.eclipse.linuxtools.systemtap.ui.structures.IPasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.structures.runnable.LoggedCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;

public class ScriptConsole2
extends IOConsole {
    private LoggedCommand cmd;
    private ErrorStreamDaemon errorDaemon;
    private ConsoleStreamDaemon consoleDaemon;
    private Subscription subscription;

    public static ScriptConsole2 getInstance(String name) {
        ScriptConsole2 console = null;
        try {
            IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            if (ic != null) {
                StopScriptAction ssa = new StopScriptAction();
                ssa.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                int i = 0;
                while (i < ic.length) {
                    ScriptConsole2 activeConsole = (ScriptConsole2)ic[i];
                    if (activeConsole.getName().endsWith(name)) {
                        ssa.run(i);
                        activeConsole.clearConsole();
                        activeConsole.setName(name);
                        console = activeConsole;
                    }
                    ++i;
                }
            }
            if (console == null) {
                console = new ScriptConsole2(name, null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (NullPointerException nullPointerException) {
            console = null;
        }
        return console;
    }

    public static ScriptConsole2 getInstance(String name, Subscription sub) {
        ScriptConsole2 console = null;
        try {
            IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            if (ic != null) {
                StopScriptAction ssa = new StopScriptAction();
                ssa.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                int i = 0;
                while (i < ic.length) {
                    ScriptConsole2 activeConsole = (ScriptConsole2)ic[i];
                    if (activeConsole.getName().endsWith(name)) {
                        ssa.run(i);
                        activeConsole.clearConsole();
                        activeConsole.setName(name);
                        console = activeConsole;
                    }
                    ++i;
                }
            }
            if (console == null) {
                console = new ScriptConsole2(name, null, sub);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (NullPointerException nullPointerException) {
            console = null;
        }
        return console;
    }

    private ScriptConsole2(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
        this.cmd = null;
    }

    private ScriptConsole2(String name, ImageDescriptor imageDescriptor, Subscription sub) {
        super(name, imageDescriptor);
        this.subscription = sub;
        this.cmd = null;
    }

    protected void createConsoleDaemon() {
    }

    protected void createErrorDaemon(IErrorParser parser) {
        try {
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView");
            if (ivp != null && ivp instanceof ErrorView) {
                ErrorView cfr_ignored_0 = (ErrorView)ivp;
            }
        }
        catch (Exception exception) {}
    }

    public void run(String[] command, String[] envVars, IPasswordPrompt prompt, IErrorParser errorParser) {
        if (this.subscription.init()) {
            this.createConsoleDaemon();
            this.createErrorDaemon(errorParser);
            this.subscription.addErrorStreamListener(this.errorDaemon);
            this.subscription.addInputStreamListener(this.consoleDaemon);
            if (!this.subscription.isRunning()) {
                this.subscription.start();
            }
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
        } else {
            this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + super.getName());
            this.subscription.interrupt();
            this.subscription.delSubscription();
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    public void run() {
        if (this.subscription.init()) {
            this.createConsoleDaemon();
            this.subscription.addInputStreamListener(this.consoleDaemon);
            this.subscription.addErrorStreamListener(this.consoleDaemon);
            if (!this.subscription.isRunning()) {
                this.subscription.start();
            }
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
        } else {
            this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + super.getName());
            this.subscription.interrupt();
            this.subscription.delSubscription();
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    public boolean isRunning() {
        return this.subscription.isRunning();
    }

    public boolean isDisposed() {
        return this.cmd.isDisposed();
    }

    public void saveStream(File file) {
        if (this.isRunning() && !this.subscription.saveLog(file)) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("ScriptConsole.Problem"), (String)Localization.getString("ScriptConsole.ErrorSavingLog"));
        }
    }

    public LoggedCommand getCommand() {
        return this.cmd;
    }

    public String getOutput() {
        return this.subscription.getOutput();
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + super.getName());
            this.subscription.interrupt();
            this.subscription.delSubscription();
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.subscription != null) {
                this.subscription.dispose();
            }
            this.subscription = null;
            if (this.errorDaemon != null) {
                this.errorDaemon.dispose();
            }
            this.errorDaemon = null;
            if (this.consoleDaemon != null) {
                this.consoleDaemon.dispose();
            }
            this.consoleDaemon = null;
        }
    }

    public void setName(String name) {
        try {
            super.setName(name);
            if (ConsolePlugin.getDefault() != null) {
                ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)this);
            }
        }
        catch (Exception exception) {}
    }
}

