/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.uistructures;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StapSettingsDialog
extends Dialog {
    private static boolean[] cmdOpts = null;
    private static String[] cmdOptVals = null;
    private Composite cmpChkBoxes = null;
    private Composite cmpTxtBoxes = null;
    private Button[] checkBox = new Button[IDEPreferenceConstants.P_STAP.length - IDEPreferenceConstants.P_STAP_OPTS.length];
    private Label[] label = new Label[IDEPreferenceConstants.P_STAP_OPTS.length];
    private Text[] text = new Text[IDEPreferenceConstants.P_STAP_OPTS.length];

    public StapSettingsDialog(Shell parentShell) {
        super(parentShell);
        LogManager.logDebug((String)("Start/End StapSettingsDialog: parentShell-" + parentShell), (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        LogManager.logDebug((String)("Start configureShell: shell-" + shell), (Object)((Object)this));
        shell.setText(Localization.getString("StapSettingsDialog.StapOptions"));
        shell.setSize(new Point(640, 170 + (1 + this.checkBox.length >> 1) + 50 * (1 + this.text.length >> 1)));
        LogManager.logDebug((String)"End configureShell:", (Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        LogManager.logDebug((String)("Start createDialogArea: parent-" + parent), (Object)((Object)this));
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.cmpChkBoxes = new Composite(comp, 0);
        this.cmpChkBoxes.setLayout((Layout)gridLayout);
        this.cmpChkBoxes.setBounds(new Rectangle(100, 5, 460, 30 * (1 + this.checkBox.length >> 1)));
        int i = 0;
        while (i < IDEPreferenceConstants.P_STAP.length - IDEPreferenceConstants.P_STAP_OPTS.length) {
            this.checkBox[i] = new Button(this.cmpChkBoxes, 32);
            this.checkBox[i].setText(String.valueOf(IDEPreferenceConstants.P_STAP[i][0]) + IDEPreferenceConstants.P_STAP[i][1]);
            this.checkBox[i].setBackground(this.cmpChkBoxes.getBackground());
            ++i;
        }
        this.cmpTxtBoxes = new Composite(comp, 0);
        this.cmpTxtBoxes.setBounds(new Rectangle(5, 5 + 30 * (1 + this.checkBox.length >> 1), 620, 50 * (1 + this.text.length >> 1)));
        int j = 0;
        while (j < IDEPreferenceConstants.P_STAP_OPTS.length) {
            this.label[j] = new Label(this.cmpTxtBoxes, 0);
            this.label[j].setBounds(new Rectangle(320 * (j / 5), 50 * (j % 5), 300, 17));
            this.label[j].setText(String.valueOf(IDEPreferenceConstants.P_STAP[i][0]) + IDEPreferenceConstants.P_STAP[i][1]);
            this.label[j].setBackground(this.cmpChkBoxes.getBackground());
            this.text[j] = new Text(this.cmpTxtBoxes, 2048);
            this.text[j].setBounds(new Rectangle(320 * (j / 5), 20 + 50 * (j % 5), 300, 27));
            if ("-v".equals(IDEPreferenceConstants.P_STAP[i][0])) {
                this.text[j].addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if ('v' != e.character) {
                            e.doit = false;
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            } else if ("-p NUM".equals(IDEPreferenceConstants.P_STAP[i][0])) {
                this.text[j].addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (' ' <= e.character && '~' >= e.character) {
                            if ('1' > e.character || '5' < e.character) {
                                e.doit = false;
                            } else if (StapSettingsDialog.this.text[1].getText().length() > 0) {
                                e.doit = false;
                            }
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            } else if ("-s NUM".equals(IDEPreferenceConstants.P_STAP[i][0])) {
                this.text[j].addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (' ' <= e.character && '~' >= e.character && !Character.isDigit(e.character)) {
                            e.doit = false;
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
            ++i;
            ++j;
        }
        LogManager.logDebug((String)("End createDialogArea: returnVal-" + comp), (Object)((Object)this));
        return comp;
    }

    protected void buttonPressed(int buttonID) {
        LogManager.logDebug((String)("Start buttonPressed: buttonID-" + buttonID), (Object)((Object)this));
        if (buttonID == 0) {
            cmdOpts = new boolean[this.checkBox.length];
            cmdOptVals = new String[this.text.length];
            int i = 0;
            while (i < cmdOpts.length) {
                StapSettingsDialog.cmdOpts[i] = this.checkBox[i].getSelection();
                ++i;
            }
            i = 0;
            while (i < cmdOptVals.length) {
                StapSettingsDialog.cmdOptVals[i] = this.text[i].getText();
                ++i;
            }
        }
        super.buttonPressed(buttonID);
        LogManager.logDebug((String)"End buttonPressed:", (Object)((Object)this));
    }

    public boolean[] getStapOpts() {
        LogManager.logDebug((String)("Start/End getStapOpts: returnVal-" + cmdOpts), (Object)((Object)this));
        return cmdOpts;
    }

    public String[] getStapOptVals() {
        LogManager.logDebug((String)("Start/End getStapOptVals: returnVal-" + cmdOptVals), (Object)((Object)this));
        return cmdOptVals;
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        cmdOpts = null;
        cmdOptVals = null;
        this.cmpChkBoxes.dispose();
        this.cmpTxtBoxes.dispose();
        int i = 0;
        while (i < this.checkBox.length) {
            this.checkBox[i].dispose();
            ++i;
        }
        this.checkBox = null;
        i = 0;
        while (i < this.label.length) {
            this.label[i].dispose();
            this.text[i].dispose();
            ++i;
        }
        this.label = null;
        this.text = null;
    }
}

