/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.TransientState;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class StateSystem {
    protected AttributeTree attributeTree = new AttributeTree(this);
    protected TransientState transState = new TransientState(null);

    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(-1, attribute);
    }

    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.attributeTree.getQuarkAndAdd(-1, attribute);
    }

    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(startingNodeQuark, subPath);
    }

    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.attributeTree.getQuarkAndAdd(startingNodeQuark, subPath);
    }

    public List<Integer> getSubAttributes(int quark, boolean recursive) throws AttributeNotFoundException {
        return this.attributeTree.getSubAttributes(quark, recursive);
    }

    public List<Integer> getQuarks(String ... pattern) {
        List<Integer> directChildren;
        LinkedList<Integer> quarks = new LinkedList<Integer>();
        LinkedList<String> prefix = new LinkedList<String>();
        LinkedList<String> suffix = new LinkedList<String>();
        boolean split = false;
        String[] stringArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals("*")) {
                if (split) {
                    return quarks;
                }
                split = true;
            } else if (split) {
                suffix.add(entry);
            } else {
                prefix.add(entry);
            }
            ++n2;
        }
        String[] prefixStr = prefix.toArray(new String[prefix.size()]);
        String[] suffixStr = suffix.toArray(new String[suffix.size()]);
        if (!split) {
            int quark;
            try {
                quark = this.getQuarkAbsolute(prefixStr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                return quarks;
            }
            quarks.add(quark);
            return quarks;
        }
        try {
            int startingAttribute = prefix.size() == 0 ? -1 : this.getQuarkAbsolute(prefixStr);
            directChildren = this.attributeTree.getSubAttributes(startingAttribute, false);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return quarks;
        }
        for (int childQuark : directChildren) {
            int matchingQuark;
            try {
                matchingQuark = this.getQuarkRelative(childQuark, suffixStr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            quarks.add(matchingQuark);
        }
        return quarks;
    }

    public void modifyAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.transState.processStateChange(t, value, attributeQuark);
    }

    public void incrementAttribute(long t, int attributeQuark) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        int prevValue = this.queryOngoingState(attributeQuark).unboxInt();
        this.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + 1), attributeQuark);
    }

    public void pushAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        Integer stackDepth = 0;
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (!previousSV.isNull()) {
            if (previousSV.getType() == 0) {
                stackDepth = previousSV.unboxInt();
            } else {
                throw new StateValueTypeException();
            }
        }
        if (stackDepth >= 10) {
            String message = "Stack limit reached, not pushing";
            throw new AttributeNotFoundException(message);
        }
        stackDepth = stackDepth + 1;
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, stackDepth.toString());
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.modifyAttribute(t, value, subAttributeQuark);
    }

    public void popAttribute(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            return;
        }
        if (previousSV.getType() != 0) {
            throw new StateValueTypeException();
        }
        Integer stackDepth = previousSV.unboxInt();
        if (stackDepth == 0) {
            return;
        }
        if (stackDepth < 0) {
            String message = "A top-level stack attribute cannot have a negative integer value.";
            throw new StateValueTypeException(message);
        }
        int subAttributeQuark = this.getQuarkRelative(attributeQuark, stackDepth.toString());
        stackDepth = stackDepth - 1;
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
    }

    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        assert (attributeQuark >= 0);
        List<Integer> childAttributes = this.attributeTree.getSubAttributes(attributeQuark, false);
        for (Integer childNodeQuark : childAttributes) {
            assert (attributeQuark != childNodeQuark);
            this.removeAttribute(t, childNodeQuark);
        }
        try {
            this.transState.processStateChange(t, TmfStateValue.nullValue(), attributeQuark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
    }

    public ITmfStateValue queryOngoingState(int attributeQuark) throws AttributeNotFoundException {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) throws AttributeNotFoundException {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    public String getAttributeName(int attributeQuark) {
        return this.attributeTree.getAttributeName(attributeQuark);
    }

    public String getFullAttributePath(int attributeQuark) {
        return this.attributeTree.getFullAttributeName(attributeQuark);
    }

    public void debugPrint(PrintWriter writer) {
        this.attributeTree.debugPrint(writer);
        this.transState.debugPrint(writer);
    }
}

