/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapLaunchShortcut;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LaunchWizard
extends SystemTapLaunchShortcut {
    private Text scriptLocation;
    private Text binaryLocation;
    private Text argumentsLocation;
    private String workspacePath;
    private String mode;
    private Shell sh;
    private Composite fileComp;
    private boolean completed;
    private static final int WIDTH = 670;
    private static final int HEIGHT = 630;

    public void launch(IEditorPart ed, String mode) {
        super.initialize();
        this.promptForInputs();
        this.mode = mode;
    }

    public void launch(ISelection selection, String mode) {
        super.initialize();
        this.completed = false;
        this.promptForInputs();
        this.mode = mode;
    }

    private void promptForInputs() {
        InputDialog id = new InputDialog(new Shell(), Messages.getString("LaunchWizard.WelcomeWizard"), String.valueOf(Messages.getString("LaunchWizard.Text1")) + Messages.getString("LaunchWizard.Text2") + Messages.getString("LaunchWizard.Text3"), this.getLaunchManager().generateLaunchConfigurationName(Messages.getString("LaunchWizard.NamePrefix")), null);
        id.open();
        if (id.getReturnCode() == 1) {
            return;
        }
        this.name = id.getValue();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath location = root.getLocation();
        this.workspacePath = location.toString();
        this.sh = new Shell();
        this.sh.setSize(670, 630);
        this.sh.setLayout((Layout)new GridLayout(1, false));
        this.sh.setText(this.name);
        Image img = new Image((Device)this.sh.getDisplay(), String.valueOf(PluginConstants.getPluginLocation()) + "systemtapbanner.png");
        Composite imageCmp = new Composite((Composite)this.sh, 2048);
        imageCmp.setLayout((Layout)new FillLayout());
        GridData imageData = new GridData(650, 157);
        imageData.horizontalAlignment = 0x1000000;
        imageCmp.setLayoutData((Object)imageData);
        imageCmp.setBackgroundImage(img);
        this.fileComp = new Composite((Composite)this.sh, 0);
        this.fileComp.setLayout((Layout)new GridLayout(2, false));
        this.fileComp.setLayoutData((Object)new GridData(768));
        GridDataFactory labelData = GridDataFactory.fillDefaults().grab(true, false).span(2, 1);
        Label scriptLabel = new Label(this.fileComp, 256);
        scriptLabel.setText(Messages.getString("LaunchWizard.Script"));
        labelData.applyTo((Control)scriptLabel);
        GridDataFactory textData = GridDataFactory.fillDefaults().grab(true, false).hint(670, -1);
        this.scriptLocation = new Text(this.fileComp, 2052);
        textData.applyTo((Control)this.scriptLocation);
        Button scriptButton = new Button(this.fileComp, 8);
        scriptButton.setText(Messages.getString("SystemTapOptionsTab.BrowseFiles"));
        scriptButton.setLayoutData((Object)new GridData());
        scriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = LaunchWizard.this.scriptLocation.getText();
                FileDialog dialog = new FileDialog(LaunchWizard.this.sh, 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    LaunchWizard.this.scriptLocation.setText(filePath);
                }
            }
        });
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 3;
        Label binaryLabel = new Label(this.fileComp, 256);
        binaryLabel.setText(Messages.getString("LaunchWizard.BinFile"));
        labelData.applyTo((Control)binaryLabel);
        this.binaryLocation = new Text(this.fileComp, 2052);
        textData.applyTo((Control)this.binaryLocation);
        Button binaryButton = new Button(this.fileComp, 8);
        binaryButton.setText(Messages.getString("SystemTapOptionsTab.WorkspaceButton2"));
        binaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(LaunchWizard.this.sh, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.getString("SystemTapOptionsTab.SelectResource"));
                dialog.setMessage(Messages.getString("SystemTapOptionsTab.SelectSuppressions"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    LaunchWizard.this.binaryLocation.setText(String.valueOf(LaunchWizard.this.workspacePath) + arg);
                }
            }
        });
        Composite argumentsComp = new Composite((Composite)this.sh, 2);
        argumentsComp.setLayoutData((Object)new GridData(768));
        argumentsComp.setLayout((Layout)new GridLayout(2, false));
        Label argumentsLabel = new Label(argumentsComp, 256);
        argumentsLabel.setText(Messages.getString("LaunchWizard.Args"));
        labelData.applyTo((Control)argumentsLabel);
        this.argumentsLocation = new Text(argumentsComp, 2114);
        GridData gd3 = new GridData(768);
        gd3.heightHint = 200;
        this.argumentsLocation.setLayoutData((Object)gd3);
        Button argumentsButton = new Button(argumentsComp, 8);
        argumentsButton.setText(Messages.getString("LaunchWizard.Func"));
        argumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchWizard.this.argumentsLocation.setText(String.valueOf(LaunchWizard.this.argumentsLocation.getText()) + " process(\"" + LaunchWizard.this.binaryLocation.getText() + "\").function(\"\")");
            }
        });
        Label blankLabel2 = new Label(argumentsComp, 256);
        blankLabel2.setText("");
        Button launch = new Button((Composite)this.sh, 8);
        launch.setLayoutData((Object)new GridData(2, 1, false, false));
        launch.setText(Messages.getString("LaunchWizard.Launch"));
        launch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchWizard.this.scriptPath = LaunchWizard.this.scriptLocation.getText();
                LaunchWizard.this.binaryPath = LaunchWizard.this.binaryLocation.getText();
                LaunchWizard.this.binaryPath = LaunchWizard.this.escapeSpecialCharacters(LaunchWizard.this.binaryPath);
                LaunchWizard.this.arguments = LaunchWizard.this.argumentsLocation.getText();
                ILaunchConfigurationWorkingCopy wc = LaunchWizard.this.createConfiguration(null, LaunchWizard.this.name);
                try {
                    LaunchWizard.this.finishLaunch(String.valueOf(LaunchWizard.this.scriptPath) + ": " + LaunchWizard.this.binName, LaunchWizard.this.mode, wc);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                LaunchWizard.this.completed = true;
                LaunchWizard.this.sh.dispose();
            }
        });
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                LaunchWizard.this.sh.open();
                LaunchWizard.this.completed = true;
            }
        });
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public String setScriptPath() {
        this.scriptPath = "IMPLEMENT";
        return this.scriptPath;
    }

    @Override
    public String setParserID() {
        return null;
    }

    @Override
    public String setViewID() {
        return null;
    }
}

