/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class ArrayDefinition
extends Definition {
    private final ArrayDeclaration declaration;
    private Definition[] definitions;

    public ArrayDefinition(ArrayDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
        this.definitions = new Definition[declaration.getLength()];
        int i = 0;
        while (i < declaration.getLength()) {
            this.definitions[i] = declaration.getElementType().createDefinition(definitionScope, String.valueOf(fieldName) + "[" + i + "]");
            ++i;
        }
    }

    public Definition[] getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Definition[] definitions) {
        this.definitions = definitions;
    }

    public Definition getElem(int i) {
        if (i > this.definitions.length) {
            return null;
        }
        return this.definitions[i];
    }

    public ArrayDeclaration getDeclaration() {
        return this.declaration;
    }

    public boolean isString() {
        IntegerDeclaration elemInt;
        return this.declaration.getElementType() instanceof IntegerDeclaration && (elemInt = (IntegerDeclaration)this.declaration.getElementType()).isCharacter();
    }

    @Override
    public void read(BitBuffer input) {
        Definition[] definitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition definition = definitionArray[n2];
            definition.read(input);
            ++n2;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isString()) {
            Definition[] definitionArray = this.definitions;
            int n = this.definitions.length;
            int n2 = 0;
            while (n2 < n) {
                Definition def = definitionArray[n2];
                IntegerDefinition character = (IntegerDefinition)def;
                if (character.getValue() != 0L) {
                    b.append(character.toString());
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (this.definitions == null) {
            b.append("[ ]");
        } else {
            b.append('[');
            int i = 0;
            while (i < this.definitions.length - 1) {
                b.append(' ');
                b.append(this.definitions[i].toString());
                b.append(',');
                ++i;
            }
            b.append(' ');
            b.append(this.definitions[this.definitions.length - 1].toString());
            b.append(" ]");
        }
        return b.toString();
    }
}

