/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class StructDefinition
extends Definition
implements IDefinitionScope {
    private final StructDeclaration declaration;
    private final HashMap<String, Definition> definitions = new HashMap();

    public StructDefinition(StructDeclaration declaration, IDefinitionScope definitionScope, String structFieldName) {
        super(definitionScope, structFieldName);
        this.declaration = declaration;
        for (String fName : declaration.getFieldsList()) {
            IDeclaration fieldDecl = declaration.getFields().get(fName);
            assert (fieldDecl != null);
            Definition def = fieldDecl.createDefinition(this, fName);
            this.definitions.put(fName, def);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public HashMap<String, Definition> getDefinitions() {
        return this.definitions;
    }

    public StructDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void read(BitBuffer input) {
        int align = (int)this.declaration.getAlignment();
        int pos = input.position() + (align - input.position() % align) % align;
        input.position(pos);
        List<String> fieldList = this.declaration.getFieldsList();
        for (String fName : fieldList) {
            Definition def = this.definitions.get(fName);
            assert (def != null);
            def.read(input);
        }
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        Definition retVal = this.definitions.get(lookupPath);
        if (retVal == null) {
            retVal = this.definitions.get("_" + lookupPath);
        }
        return retVal;
    }

    public ArrayDefinition lookupArray(String name) {
        Definition def = this.lookupDefinition(name);
        return (ArrayDefinition)(def instanceof ArrayDefinition ? def : null);
    }

    public EnumDefinition lookupEnum(String name) {
        Definition def = this.lookupDefinition(name);
        return (EnumDefinition)(def instanceof EnumDefinition ? def : null);
    }

    public IntegerDefinition lookupInteger(String name) {
        Definition def = this.lookupDefinition(name);
        return (IntegerDefinition)(def instanceof IntegerDefinition ? def : null);
    }

    public SequenceDefinition lookupSequence(String name) {
        Definition def = this.lookupDefinition(name);
        return (SequenceDefinition)(def instanceof SequenceDefinition ? def : null);
    }

    public StringDefinition lookupString(String name) {
        Definition def = this.lookupDefinition(name);
        return (StringDefinition)(def instanceof StringDefinition ? def : null);
    }

    public StructDefinition lookupStruct(String name) {
        Definition def = this.lookupDefinition(name);
        return (StructDefinition)(def instanceof StructDefinition ? def : null);
    }

    public VariantDefinition lookupVariant(String name) {
        Definition def = this.lookupDefinition(name);
        return (VariantDefinition)(def instanceof VariantDefinition ? def : null);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.declaration.getFieldsList().size();
        int n = 0;
        if (size > 1) {
            builder.append("{ ");
        }
        ListIterator<String> listIterator = this.declaration.getFieldsList().listIterator();
        while (listIterator.hasNext()) {
            String field = listIterator.next();
            builder.append(this.lookupDefinition(field).toString());
            if (++n == size) continue;
            builder.append(", ");
        }
        if (size > 1) {
            builder.append(" }");
        }
        return builder.toString();
    }
}

