/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.model;

import java.util.Stack;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;

public class LTTngCPUState
implements Cloneable {
    private Stack<StateStrings.CpuMode> mode_stack = new Stack();
    private Stack<Long> irq_stack = new Stack();
    private Stack<Long> softirq_stack = new Stack();
    private Stack<Long> trap_stack = new Stack();

    public LTTngCPUState() {
        this.mode_stack.push(StateStrings.CpuMode.LTTV_CPU_UNKNOWN);
        this.irq_stack.push(-1L);
        this.softirq_stack.push(-1L);
        this.trap_stack.push(-1L);
    }

    public LTTngCPUState clone() {
        LTTngCPUState newState = null;
        try {
            newState = (LTTngCPUState)super.clone();
            newState.mode_stack = (Stack)this.mode_stack.clone();
            newState.irq_stack = (Stack)this.irq_stack.clone();
            newState.softirq_stack = (Stack)this.softirq_stack.clone();
            newState.trap_stack = (Stack)this.trap_stack.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }

    public void clearAndSetBaseToCpuStack(StateStrings.CpuMode newCpuMode) {
        this.mode_stack.clear();
        this.irq_stack.clear();
        this.softirq_stack.clear();
        this.trap_stack.clear();
        this.mode_stack.push(newCpuMode);
        this.irq_stack.push(-1L);
        this.softirq_stack.push(-1L);
        this.trap_stack.push(-1L);
    }

    public void pushToCpuStack(StateStrings.CpuMode newCpuMode) {
        this.mode_stack.push(newCpuMode);
    }

    public void pushToIrqStack(Long irqID) {
        this.irq_stack.push(irqID);
    }

    public void pushToSoftIrqStack(Long softIrqID) {
        this.softirq_stack.push(softIrqID);
    }

    public void pushToTrapStack(Long trapID) {
        this.trap_stack.push(trapID);
    }

    public StateStrings.CpuMode popFromCpuStack() {
        StateStrings.CpuMode returnedMode = this.mode_stack.pop();
        if (this.mode_stack.size() < 1) {
            this.mode_stack.push(StateStrings.CpuMode.LTTV_CPU_UNKNOWN);
        }
        return returnedMode;
    }

    public Long popFromIrqStack() {
        Long irq = this.irq_stack.pop();
        if (this.irq_stack.size() < 1) {
            this.irq_stack.push(-1L);
        }
        return irq;
    }

    public Long popFromSoftIrqStack() {
        Long softirq = this.softirq_stack.pop();
        if (this.softirq_stack.size() < 1) {
            this.softirq_stack.push(-1L);
        }
        return softirq;
    }

    public Long popFromTrapStack() {
        Long trap = this.trap_stack.pop();
        if (this.trap_stack.size() < 1) {
            this.trap_stack.push(-1L);
        }
        return trap;
    }

    public StateStrings.CpuMode peekFromCpuStack() {
        return this.mode_stack.peek();
    }

    public Long peekFromIrqStack() {
        return this.irq_stack.peek();
    }

    public Long peekFromSoftIrqStack() {
        return this.softirq_stack.peek();
    }

    public Long peekFromTrapStack() {
        return this.trap_stack.peek();
    }

    public void reset() {
        this.mode_stack.clear();
        this.irq_stack.clear();
        this.softirq_stack.clear();
        this.trap_stack.clear();
        this.mode_stack.push(StateStrings.CpuMode.LTTV_CPU_UNKNOWN);
        this.irq_stack.push(-1L);
        this.softirq_stack.push(-1L);
        this.trap_stack.push(-1L);
    }
}

