/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets;

import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.ITimeAnalysisViewer;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.GroupItem;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.Item;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.TmfTimeStatesCtrl;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.TraceItem;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.Utils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TmfTimeTipHandler {
    private Shell _tipShell;
    private Table _tipTable;
    private Item _tipItem;
    private Point _tipPosition;
    private ITimeDataProvider _timeDataProvider;
    TmfTimeAnalysisProvider _utilImp = null;

    public TmfTimeTipHandler(Shell parent, TmfTimeAnalysisProvider rUtilImpl, ITimeDataProvider timeProv) {
        Display display = parent.getDisplay();
        this._utilImp = rUtilImpl;
        this._timeDataProvider = timeProv;
        this._tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this._tipShell.setLayout((Layout)gridLayout);
        GridData data = new GridData(1, 1, true, true);
        this._tipShell.setLayoutData((Object)data);
        this._tipShell.setBackground(display.getSystemColor(29));
        this._tipTable = new Table((Composite)this._tipShell, 0);
        this._tipTable.setForeground(display.getSystemColor(28));
        this._tipTable.setBackground(display.getSystemColor(29));
        this._tipTable.setHeaderVisible(false);
        this._tipTable.setLinesVisible(false);
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TmfTimeTipHandler.this._tipShell.isVisible()) {
                    TmfTimeTipHandler.this._tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (TmfTimeTipHandler.this._tipShell.isVisible()) {
                    TmfTimeTipHandler.this._tipShell.setVisible(false);
                }
                TmfTimeTipHandler.this._tipItem = null;
            }

            private void addItem(String name, String value) {
                TableItem line = new TableItem(TmfTimeTipHandler.this._tipTable, 0);
                line.setText(0, name);
                line.setText(1, value);
            }

            private void fillValues(Point pt, TmfTimeStatesCtrl threadStates, Item item) {
                if (item instanceof TraceItem) {
                    Map<String, String> eventAddOns;
                    String state;
                    ITmfTimeAnalysisEntry thrd = ((TraceItem)item)._trace;
                    ITimeEvent threadEvent = Utils.findEvent(thrd, threadStates.hitTimeTest(pt.x), 2);
                    ITimeEvent nextEvent = Utils.findEvent(thrd, threadStates.hitTimeTest(pt.x), 1);
                    this.addItem(Messages.TmfTimeTipHandler_TRACE_NAME, thrd.getName());
                    String traceClass = TmfTimeTipHandler.this._utilImp.getTraceClassName(thrd);
                    if (traceClass != null) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_CLASS_NAME, traceClass);
                    }
                    if ((state = TmfTimeTipHandler.this._utilImp.getEventName(threadEvent)) != null) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STATE, state);
                    }
                    if ((eventAddOns = TmfTimeTipHandler.this._utilImp.getEventHoverToolTipInfo(threadEvent)) != null) {
                        for (String message : eventAddOns.keySet()) {
                            this.addItem(message, eventAddOns.get(message));
                        }
                    }
                    long eventStartTime = -1L;
                    long eventDuration = -1L;
                    long eventEndTime = -1L;
                    if (threadEvent != null) {
                        eventStartTime = threadEvent.getTime();
                        eventDuration = threadEvent.getDuration();
                        if (eventDuration < 0L && nextEvent != null) {
                            eventEndTime = nextEvent.getTime();
                            eventDuration = eventEndTime - eventStartTime;
                        } else {
                            eventEndTime = eventStartTime + eventDuration;
                        }
                    }
                    Utils.Resolution res = Utils.Resolution.NANOSEC;
                    if (TmfTimeTipHandler.this._timeDataProvider.isCalendarFormat()) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_DATE, eventStartTime > -1L ? Utils.formatDate(eventStartTime) : "?");
                        if (eventDuration > 0L) {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, ITimeAnalysisViewer.TimeFormat.ABSOLUTE, res) : "?");
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, ITimeAnalysisViewer.TimeFormat.ABSOLUTE, res) : "?");
                        } else {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, ITimeAnalysisViewer.TimeFormat.ABSOLUTE, res) : "?");
                        }
                    } else if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, ITimeAnalysisViewer.TimeFormat.RELATIVE, res) : "?");
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, ITimeAnalysisViewer.TimeFormat.RELATIVE, res) : "?");
                    } else {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, ITimeAnalysisViewer.TimeFormat.RELATIVE, res) : "?");
                    }
                    if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_DURATION, eventDuration > -1L ? Utils.formatTime(eventDuration, ITimeAnalysisViewer.TimeFormat.RELATIVE, res) : "?");
                    }
                } else if (item instanceof GroupItem) {
                    this.addItem(Messages.TmfTimeTipHandler_TRACE_GROUP_NAME, item.toString());
                    this.addItem(Messages.TmfTimeTipHandler_NUMBER_OF_TRACES, "" + ((GroupItem)item)._traces.size());
                }
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                Item item = null;
                if (widget instanceof TmfTimeStatesCtrl) {
                    TmfTimeStatesCtrl threadStates = (TmfTimeStatesCtrl)widget;
                    item = threadStates.getItem(pt);
                    TmfTimeTipHandler.this._tipTable.remove(0, TmfTimeTipHandler.this._tipTable.getItemCount() - 1);
                    new TableColumn(TmfTimeTipHandler.this._tipTable, 0);
                    new TableColumn(TmfTimeTipHandler.this._tipTable, 0);
                    this.fillValues(pt, threadStates, item);
                    TmfTimeTipHandler.this._tipTable.getColumn(0).setWidth(200);
                    TmfTimeTipHandler.this._tipTable.getColumn(1).pack();
                    TmfTimeTipHandler.this._tipTable.setSize(TmfTimeTipHandler.this._tipTable.computeSize(-1, 200));
                    TmfTimeTipHandler.this._tipShell.pack();
                } else if (widget == null) {
                    TmfTimeTipHandler.this._tipShell.setVisible(false);
                    TmfTimeTipHandler.this._tipItem = null;
                    return;
                }
                if (item == TmfTimeTipHandler.this._tipItem) {
                    return;
                }
                TmfTimeTipHandler.this._tipItem = item;
                TmfTimeTipHandler.this._tipPosition = control.toDisplay(pt);
                TmfTimeTipHandler.this._tipShell.pack();
                TmfTimeTipHandler.this.setHoverLocation(TmfTimeTipHandler.this._tipShell, TmfTimeTipHandler.this._tipPosition);
                TmfTimeTipHandler.this._tipShell.setVisible(true);
            }
        });
    }

    private void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

