/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class GraphsView
extends ViewPart {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.GraphsView";
    protected TreeViewer viewer;

    public GraphsView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        parent.getShell().setCursor(new Cursor((Device)parent.getShell().getDisplay(), 1));
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.generateGraphsTree();
        this.makeActions();
        LogManager.logDebug((String)"End createPartControl:", (Object)((Object)this));
    }

    protected abstract void generateGraphsTree();

    protected void makeActions() {
    }

    public void refresh() {
        this.generateGraphsTree();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
        super.dispose();
        this.viewer = null;
    }

    private class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object par) {
            TreeNode parent = (TreeNode)par;
            Object[] children = new Object[parent.getChildCount()];
            int i = 0;
            while (i < children.length) {
                children[i] = parent.getChildAt(i);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).getChildCount() > 0;
        }
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            TreeNode treeObj = (TreeNode)obj;
            Image img = DashboardPlugin.getImageDescriptor("icons/misc/graph_dis.gif").createImage();
            if (treeObj.getChildCount() > 0) {
                img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return img;
        }
    }
}

