/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSample;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSymbol;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.internal.oprofile.ui.model.UiModelSample;
import org.eclipse.swt.graphics.Image;

public class UiModelSymbol
implements IUiModelElement {
    private IUiModelElement parent;
    private OpModelSymbol symbol;
    private UiModelSample[] samples;
    private int totalCount;

    public UiModelSymbol(IUiModelElement parent, OpModelSymbol symbol, int totalCount) {
        this.parent = parent;
        this.symbol = symbol;
        this.samples = null;
        this.totalCount = totalCount;
        this.refreshModel();
    }

    private void refreshModel() {
        ArrayList<UiModelSample> sampleList = new ArrayList<UiModelSample>();
        OpModelSample[] dataModelSamples = this.symbol.getSamples();
        int i = 0;
        while (i < dataModelSamples.length) {
            if (dataModelSamples[i].getLine() != 0) {
                sampleList.add(new UiModelSample(this, dataModelSamples[i], this.totalCount));
            }
            ++i;
        }
        this.samples = new UiModelSample[sampleList.size()];
        sampleList.toArray(this.samples);
    }

    public String toString() {
        double countPercentage = (double)this.symbol.getCount() / (double)this.totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        String fileName = new File(this.symbol.getFilePath()).getName();
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + this.symbol.getName() + (fileName.length() == 0 ? "" : " [" + fileName + "]");
    }

    public String getFileName() {
        return this.symbol.getFilePath();
    }

    public String getFunctionName() {
        return this.symbol.getName();
    }

    public int getLineNumber() {
        return this.symbol.getLine();
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        return this.samples;
    }

    public boolean hasChildren() {
        return this.samples != null && this.samples.length != 0;
    }

    public IUiModelElement getParent() {
        return this.parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/symbol.gif").createImage();
    }
}

