/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.internal.ctf.core.trace.Stream;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputPacketReader
implements IDefinitionScope {
    private StreamInputPacketIndexEntry currentPacket = null;
    private final BitBuffer bitBuffer = new BitBuffer();
    private final StreamInputReader streamInputReader;
    private long lastTimestamp = 0L;
    private StructDefinition tracePacketHeaderDef = null;
    private StructDefinition streamPacketContextDef = null;
    private StructDefinition streamEventHeaderDef = null;
    private StructDefinition streamEventContextDef = null;
    private final HashMap<Long, EventDefinition> events = new HashMap();
    private int currentCpu = 0;
    private int lostEvents;
    private int lostSoFar;

    public StreamInputPacketReader(StreamInputReader streamInputReader) {
        this.streamInputReader = streamInputReader;
        this.getBitBuffer().setByteOrder(streamInputReader.getByteOrder());
        this.createDefinitions();
        this.lostEvents = 0;
        this.lostSoFar = 0;
    }

    public StreamInputPacketIndexEntry getCurrentPacket() {
        return this.currentPacket;
    }

    public StructDefinition getStreamPacketContextDef() {
        return this.streamPacketContextDef;
    }

    public int getCPU() {
        return this.currentCpu;
    }

    @Override
    public String getPath() {
        return "";
    }

    private void createDefinitions() {
        StructDeclaration streamEventContextDecl;
        StructDeclaration streamEventHeaderDecl;
        StructDeclaration streamPacketContextDecl;
        Stream currentStream = this.getStreamInputReader().getStreamInput().getStream();
        StructDeclaration tracePacketHeaderDecl = currentStream.getTrace().getPacketHeader();
        if (tracePacketHeaderDecl != null) {
            this.setTracePacketHeaderDef(tracePacketHeaderDecl.createDefinition(this, "trace.packet.header"));
        }
        if ((streamPacketContextDecl = currentStream.getPacketContextDecl()) != null) {
            this.setStreamPacketContextDef(streamPacketContextDecl.createDefinition(this, "stream.packet.context"));
        }
        if ((streamEventHeaderDecl = currentStream.getEventHeaderDecl()) != null) {
            this.setStreamEventHeaderDef(streamEventHeaderDecl.createDefinition(this, "stream.event.header"));
        }
        if ((streamEventContextDecl = currentStream.getEventContextDecl()) != null) {
            this.setStreamEventContextDef(streamEventContextDecl.createDefinition(this, "stream.event.context"));
        }
        this.createEventDefinitions();
    }

    private void createEventDefinitions() {
        Collection<EventDeclaration> eventDecls = this.getStreamInputReader().getStreamInput().getStream().getEvents().values();
        for (EventDeclaration event : eventDecls) {
            EventDefinition eventDef = event.createDefinition(this.getStreamInputReader());
            this.events.put(event.getId(), eventDef);
        }
    }

    public void setCurrentPacket(StreamInputPacketIndexEntry currentPacket) {
        this.currentPacket = currentPacket;
        if (this.currentPacket != null) {
            MappedByteBuffer bb = null;
            try {
                bb = this.getStreamInputReader().getStreamInput().getFileChannel().map(FileChannel.MapMode.READ_ONLY, this.currentPacket.getOffsetBytes(), (this.currentPacket.getPacketSizeBits() + 7) / 8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBitBuffer().setByteBuffer(bb);
            if (this.getTracePacketHeaderDef() != null) {
                this.getTracePacketHeaderDef().read(this.getBitBuffer());
            }
            if (this.getStreamPacketContextDef() != null) {
                this.getStreamPacketContextDef().read(this.getBitBuffer());
                Definition cpuiddef = this.getStreamPacketContextDef().lookupDefinition("cpu_id");
                if (cpuiddef instanceof IntegerDefinition) {
                    this.currentCpu = (int)((IntegerDefinition)cpuiddef).getValue();
                }
                Definition lostEventsdef = this.getStreamPacketContextDef().lookupDefinition("events_discarded");
                if (cpuiddef instanceof IntegerDefinition) {
                    this.lostEvents = (int)((IntegerDefinition)lostEventsdef).getValue();
                }
            }
            this.lastTimestamp = currentPacket.getTimestampBegin();
        } else {
            this.getBitBuffer().setByteBuffer(null);
            this.lastTimestamp = 0L;
        }
    }

    public boolean hasMoreEvents() {
        if (this.currentPacket != null) {
            return this.getBitBuffer().position() < this.currentPacket.getContentSizeBits();
        }
        return false;
    }

    public EventDefinition readNextEvent() throws CTFReaderException {
        EventDefinition eventDef;
        Long eventID = null;
        long timestamp = 0L;
        if (this.lostEvents > this.lostSoFar) {
            EventDefinition eventDef2 = EventDeclaration.getLostEventDeclaration().createDefinition(this.streamInputReader);
            eventDef2.setTimestamp(this.lastTimestamp);
            ++this.lostSoFar;
            return eventDef2;
        }
        StructDefinition sehd = this.getStreamEventHeaderDef();
        BitBuffer currentBitBuffer = this.getBitBuffer();
        if (sehd != null) {
            sehd.read(currentBitBuffer);
            EnumDefinition idEnumDef = (EnumDefinition)sehd.lookupDefinition("id");
            assert (idEnumDef != null);
            eventID = idEnumDef.getIntegerValue();
            VariantDefinition variantDef = (VariantDefinition)sehd.lookupDefinition("v");
            assert (variantDef != null);
            StructDefinition variantCurrentField = (StructDefinition)variantDef.getCurrentField();
            assert (variantCurrentField != null);
            IntegerDefinition idIntegerDef = (IntegerDefinition)variantCurrentField.lookupDefinition("id");
            if (idIntegerDef != null) {
                eventID = idIntegerDef.getValue();
            }
            IntegerDefinition timestampDef = (IntegerDefinition)variantCurrentField.lookupDefinition("timestamp");
            assert (timestampDef != null);
            timestamp = this.calculateTimestamp(timestampDef);
        }
        if (this.getStreamEventContextDef() != null) {
            this.getStreamEventContextDef().read(currentBitBuffer);
        }
        if ((eventDef = this.events.get(eventID)) == null) {
            throw new CTFReaderException("Incorrect event id : " + eventID);
        }
        if (eventDef.getContext() != null) {
            eventDef.getContext().read(currentBitBuffer);
        }
        if (eventDef.getFields() != null) {
            eventDef.getFields().read(currentBitBuffer);
        }
        eventDef.setTimestamp(timestamp);
        return eventDef;
    }

    private long calculateTimestamp(IntegerDefinition timestampDef) {
        int len = timestampDef.getDeclaration().getLength();
        if (timestampDef.getDeclaration().getLength() == 64) {
            this.lastTimestamp = timestampDef.getValue();
            return this.lastTimestamp;
        }
        long majorasbitmask = (1L << len) - 1L;
        long newval = timestampDef.getValue();
        if (newval < (this.lastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        this.lastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        this.lastTimestamp += newval;
        return this.lastTimestamp;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return null;
    }

    public StructDefinition getStreamEventContextDef() {
        return this.streamEventContextDef;
    }

    public void setStreamEventContextDef(StructDefinition streamEventContextDef) {
        this.streamEventContextDef = streamEventContextDef;
    }

    public StructDefinition getStreamEventHeaderDef() {
        return this.streamEventHeaderDef;
    }

    public void setStreamEventHeaderDef(StructDefinition streamEventHeaderDef) {
        this.streamEventHeaderDef = streamEventHeaderDef;
    }

    public void setStreamPacketContextDef(StructDefinition streamPacketContextDef) {
        this.streamPacketContextDef = streamPacketContextDef;
    }

    public StructDefinition getTracePacketHeaderDef() {
        return this.tracePacketHeaderDef;
    }

    public void setTracePacketHeaderDef(StructDefinition tracePacketHeaderDef) {
        this.tracePacketHeaderDef = tracePacketHeaderDef;
    }

    public StreamInputReader getStreamInputReader() {
        return this.streamInputReader;
    }

    public BitBuffer getBitBuffer() {
        return this.bitBuffer;
    }
}

