/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.editor;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.EditorPlugin;
import org.eclipse.linuxtools.systemtap.ui.editor.RecentFileMenuManager;

public final class RecentFileLog {
    private static final String fileName = EditorPlugin.getDefault().getStateLocation().append("recentFiles.log").toOSString();
    private static final RecentFileLog log = new RecentFileLog();

    private RecentFileLog() {
        File f = new File(fileName);
        try {
            if (!f.exists()) {
                f.createNewFile();
                EditorPlugin.getDefault().getDialogSettings().save(fileName);
            }
        }
        catch (IOException iOException) {}
    }

    public static RecentFileLog getInstance() {
        return log;
    }

    public static String getString(String key) {
        try {
            IDialogSettings settings = EditorPlugin.getDefault().getDialogSettings();
            settings.load(fileName);
            return settings.get(key);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean setString(String key, String val) {
        try {
            IDialogSettings settings = EditorPlugin.getDefault().getDialogSettings();
            settings.load(fileName);
            settings.put(key, val);
            settings.save(fileName);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean updateRecentFiles(File file) {
        String[] temps = new String[4];
        String[] files = new String[4];
        String[] paths = new String[4];
        int i = 0;
        while (i < 4) {
            files[i] = RecentFileLog.getString("file" + i);
            paths[i] = RecentFileLog.getString("path" + i);
            ++i;
        }
        if (!file.getAbsolutePath().equals(paths[0])) {
            temps[0] = files[0];
            temps[1] = paths[0];
            files[0] = file.getName();
            paths[0] = file.getAbsolutePath();
            if (file.getAbsolutePath().equals(paths[1])) {
                files[1] = temps[0];
                paths[1] = temps[1];
            } else {
                temps[2] = files[1];
                temps[3] = paths[1];
                files[1] = temps[0];
                paths[1] = temps[1];
                if (file.getAbsolutePath().equals(paths[2])) {
                    files[2] = temps[2];
                    paths[2] = temps[3];
                } else {
                    temps[0] = files[2];
                    temps[1] = paths[2];
                    files[2] = temps[2];
                    paths[2] = temps[3];
                    if (file.getAbsolutePath().equals(paths[3])) {
                        files[3] = temps[0];
                        paths[3] = temps[1];
                    } else {
                        files[3] = temps[0];
                        paths[3] = temps[1];
                    }
                }
            }
        }
        i = 0;
        while (i < 4) {
            if (files[i] != null && paths[i] != null) {
                RecentFileLog.setString("file" + i, files[i]);
                RecentFileLog.setString("path" + i, paths[i]);
                RecentFileMenuManager.update();
            }
            ++i;
        }
        return true;
    }
}

