/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden.KernelSourceAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.KernelSourceTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.PlatformUI;

public class KernelBrowserView
extends BrowserView {
    private final Preferences.IPropertyChangeListener propertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            LogManager.logDebug((String)("Start propertyChange: event-" + event), (Object)this);
            if (event.getProperty().equals("KernelSourcePreference")) {
                KernelBrowserView.this.refresh();
            }
            LogManager.logDebug((String)"End propertyChange:", (Object)this);
        }
    };
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView";
    private KernelSourceAction doubleClickAction;
    private IDoubleClickListener dblClickListener;

    public KernelBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        super.createPartControl(parent);
        this.refresh();
        this.makeActions();
        LogManager.logDebug((String)"End createPartControl", (Object)((Object)this));
    }

    public void makeActions() {
        LogManager.logDebug((String)"Start makeActions:", (Object)((Object)this));
        this.doubleClickAction = new KernelSourceAction(this.getSite().getWorkbenchWindow(), this);
        this.dblClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogManager.logDebug((String)("Start doubleClick: event-" + event), (Object)this);
                KernelBrowserView.this.doubleClickAction.run();
                LogManager.logDebug((String)"End doubleClick:", (Object)this);
            }
        };
        this.viewer.addDoubleClickListener(this.dblClickListener);
        IDEPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
        LogManager.logDebug((String)"End makeActions:", (Object)((Object)this));
    }

    public void refresh() {
        LogManager.logDebug((String)"Start refresh:", (Object)((Object)this));
        KernelSourceTree kst = new KernelSourceTree();
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String kernelSource = p.getString("KernelSourcePreference");
        if (kernelSource == null || kernelSource.length() < 1) {
            LogManager.logInfo((String)"Kernel Source Directory not found, querying", (Object)((Object)this));
            DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
            dialog.setText(Localization.getString("KernelBrowserView.WhereKernelSource"));
            kernelSource = dialog.open();
            if (kernelSource == null) {
                kernelSource = "";
            }
            p.setValue("KernelSourcePreference", kernelSource);
        }
        String[] excluded = p.getString("ExcludedKernelSource").split(File.pathSeparator);
        kst.buildKernelTree(kernelSource, excluded);
        this.viewer.setInput((Object)kst.getTree());
        kst.dispose();
        LogManager.logDebug((String)"End refresh:", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        IDEPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener(this.dblClickListener);
        }
        this.dblClickListener = null;
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
    }
}

