/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import org.eclipse.linuxtools.internal.tmf.core.statesystem.HistoryBuilder;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

class StateSystemBuildRequest
extends TmfEventRequest<ITmfEvent> {
    private static final int chunkSize = 50000;
    private final HistoryBuilder builder;
    private final IStateChangeInput sci;
    private final ITmfTrace<ITmfEvent> trace;

    StateSystemBuildRequest(HistoryBuilder builder) {
        super(builder.getInputPlugin().getExpectedEventType().getClass(), TmfTimeRange.ETERNITY, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND);
        this.builder = builder;
        this.sci = builder.getInputPlugin();
        this.trace = this.sci.getTrace();
    }

    @Override
    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (event != null && event.getTrace() == this.trace) {
            this.sci.processEvent(event);
        }
    }

    @Override
    public void handleSuccess() {
        super.handleSuccess();
        this.builder.close(false);
    }

    @Override
    public void handleCancel() {
        super.handleCancel();
        this.builder.close(true);
    }

    @Override
    public void handleFailure() {
        super.handleFailure();
        this.builder.close(true);
    }
}

