/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;

public class Stream {
    private Long id = null;
    private StructDeclaration packetContextDecl = null;
    private StructDeclaration eventHeaderDecl = null;
    private StructDeclaration eventContextDecl = null;
    private CTFTrace trace = null;
    private final HashMap<Long, EventDeclaration> events = new HashMap();
    private final Set<StreamInput> inputs = new HashSet<StreamInput>();

    public Stream(CTFTrace trace) {
        this.trace = trace;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public boolean idIsSet() {
        return this.id != null;
    }

    public boolean eventHeaderIsSet() {
        return this.eventHeaderDecl != null;
    }

    public boolean eventContextIsSet() {
        return this.eventContextDecl != null;
    }

    public boolean packetContextIsSet() {
        return this.packetContextDecl != null;
    }

    public void setEventHeader(StructDeclaration eventHeader) {
        this.eventHeaderDecl = eventHeader;
    }

    public void setEventContext(StructDeclaration eventContext) {
        this.eventContextDecl = eventContext;
    }

    public void setPacketContext(StructDeclaration packetContext) {
        this.packetContextDecl = packetContext;
    }

    public StructDeclaration getEventHeaderDecl() {
        return this.eventHeaderDecl;
    }

    public StructDeclaration getEventContextDecl() {
        return this.eventContextDecl;
    }

    public StructDeclaration getPacketContextDecl() {
        return this.packetContextDecl;
    }

    public Set<StreamInput> getStreamInputs() {
        return this.inputs;
    }

    public CTFTrace getTrace() {
        return this.trace;
    }

    public HashMap<Long, EventDeclaration> getEvents() {
        return this.events;
    }

    public void addEvent(EventDeclaration event) throws ParseException {
        if (this.events.get(null) != null) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (event.getId() == null && this.events.size() != 0) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (this.events.get(event.getId()) != null) {
            throw new ParseException("Event id already exists");
        }
        this.events.put(event.getId(), event);
    }

    public void addInput(StreamInput input) {
        this.inputs.add(input);
    }

    public String toString() {
        return "Stream [id=" + this.id + ", packetContextDecl=" + this.packetContextDecl + ", eventHeaderDecl=" + this.eventHeaderDecl + ", eventContextDecl=" + this.eventContextDecl + ", trace=" + this.trace + ", events=" + this.events + ", inputs=" + this.inputs + "]";
    }
}

