/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.RunModuleAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.hidden.GetSelectedModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardGraphData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.GraphTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IActionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class StopModuleAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private final IActionListener runListener = new IActionListener(){

        public void handleActionEvent() {
            StopModuleAction.this.setEnablement(true);
        }
    };
    private final ISelectionChangedListener activeModuleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            StopModuleAction.this.setEnablement(true);
        }
    };
    private final ISelectionChangedListener moduleListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            try {
                TreeNode node = (TreeNode)((StructuredSelection)e.getSelection()).getFirstElement();
                IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
                ActiveModuleBrowserView amdv = (ActiveModuleBrowserView)ivp;
                int childcount = node.getChildCount();
                if (childcount == 0 && amdv.isActive((DashboardModule)node.getData())) {
                    StopModuleAction.this.setEnablement(true);
                } else if (childcount > 0) {
                    boolean active = false;
                    int j = 0;
                    while (j < childcount) {
                        if (amdv.isActive((DashboardModule)node.getChildAt(j).getData())) {
                            active = true;
                            break;
                        }
                        ++j;
                    }
                    if (active) {
                        StopModuleAction.this.setEnablement(true);
                    }
                } else {
                    StopModuleAction.this.setEnablement(false);
                }
            }
            catch (Exception exception) {}
        }
    };
    private IViewPart view;
    private IAction act;
    private static ArrayList<IActionListener> listeners = new ArrayList();

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction act) {
        this.run();
    }

    public void run() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    TreeNode treenode = GetSelectedModule.getNode(StopModuleAction.this.view);
                    DashboardModule module = null;
                    if (treenode.getChildCount() == 0) {
                        module = (DashboardModule)treenode.getData();
                        this.stop = StopModuleAction.this.stopmodule(module);
                    } else {
                        int j = 0;
                        while (j < treenode.getChildCount()) {
                            module = (DashboardModule)treenode.getChildAt(j).getData();
                            this.stop = StopModuleAction.this.stopmodule(module) || this.stop;
                            ++j;
                        }
                    }
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    private boolean stopmodule(DashboardModule module) {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        boolean stop = false;
        try {
            if (ambv.isActive(module)) {
                ActiveModuleTreeNode node = ambv.remove(module);
                ActiveModuleData amd = (ActiveModuleData)node.getData();
                ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView");
                DashboardView dv = (DashboardView)ivp;
                int i = 0;
                while (i < node.getChildCount()) {
                    GraphTreeNode graphNode = (GraphTreeNode)node.getChildAt(i);
                    DashboardGraphData graphData = (DashboardGraphData)graphNode.getData();
                    if (graphData.adapter != null) {
                        dv.removeGraph(graphData.adapter, module.getcategory());
                        graphData.adapter = null;
                    }
                    ++i;
                }
                if (!amd.paused) {
                    if (amd.cmd.isRunning()) {
                        amd.cmd.stop();
                    }
                    amd.data = null;
                }
                dv.closeComposite(amd.module.category);
                amd = null;
                StopModuleAction.fireActionEvent();
            }
            this.setEnablement(false);
            this.buildEnablementChecks();
        }
        catch (Exception exception) {
            stop = true;
        }
        return stop;
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.act = act;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
        if (ivp != null) {
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().addSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().addSelectionChangedListener(this.activeModuleListener);
            RunModuleAction.addActionListener(this.runListener);
        }
    }

    private void setEnablement(boolean enabled) {
        this.act.setEnabled(enabled);
    }

    public void dispose() {
        try {
            RunModuleAction.removeActionListener(this.runListener);
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
            DashboardModuleBrowserView dmbv = (DashboardModuleBrowserView)ivp;
            dmbv.getViewer().removeSelectionChangedListener(this.moduleListener);
            ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
            ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
            ambv.getViewer().removeSelectionChangedListener(this.activeModuleListener);
        }
        catch (Exception exception) {}
        this.view = null;
        this.act = null;
    }

    public static void addActionListener(IActionListener listener) {
        listeners.add(listener);
    }

    public static void removeActionListener(IActionListener listener) {
        listeners.remove(listener);
    }

    private static void fireActionEvent() {
        int i = 0;
        while (i < listeners.size()) {
            listeners.get(i).handleActionEvent();
            ++i;
        }
    }
}

