/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.configure;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.cdt.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfigurationManager;

public class AutotoolsOptionValueHandler
extends ManagedOptionValueHandler
implements IOptionApplicability {
    public static final String DEFAULT_BUILD_DIR = "build";
    public static final String CONFIGURE_TOOL_ID = "org.eclipse.linuxtools.cdt.autotools.core.gnu.toolchain.tool.configure";
    public static final String BUILD_DIR_OPTION_ID = "org.eclipse.linuxtools.cdt.autotools.core.option.configure.builddir";
    public static final String BUILD_DIR_APPLY = "BuildDir.apply";
    public static final String BUILD_DIR_DEFAULT_QUESTION = "BuildDir.default";
    public static final String BUILD_DIR_YES = "BuildDir.yes";
    public static final String BUILD_DIR_NO = "BuildDir.no";

    public boolean handleValue(IBuildObject buildObject, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        String value = (String)option.getValue();
        if (buildObject instanceof IConfiguration && event == 1) {
            IConfiguration configuration = (IConfiguration)buildObject;
            ICConfigurationDescription cfgd = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration);
            if (option.getName().equals("Name") && cfgd != null) {
                String cfgId = cfgd.getId();
                if (!value.equals("") && !value.equals(cfgId)) {
                    boolean isSaved;
                    IProject project = (IProject)configuration.getManagedProject().getOwner();
                    String autoName = null;
                    String autoNameTemplate = null;
                    try {
                        autoName = project.getPersistentProperty(AutotoolsPropertyConstants.AUTO_BUILD_NAME);
                    }
                    catch (CoreException coreException) {}
                    if (autoName == null || autoName.equals("true")) {
                        autoNameTemplate = "${workspace_loc:/" + project.getName() + "}/build-" + this.fixName(configuration.getName());
                        IBuilder cfgBuilder = configuration.getEditableBuilder();
                        cfgBuilder.setBuildPath(autoNameTemplate);
                    }
                    if (!(isSaved = AutotoolsConfigurationManager.getInstance().cloneCfg(project, value, cfgd)) && !AutotoolsConfigurationManager.getInstance().isSyncing()) {
                        return true;
                    }
                }
                try {
                    IOption optionToSet = holder.getOptionToSet(option, false);
                    optionToSet.setValue(cfgId);
                }
                catch (BuildException buildException) {
                    return false;
                }
            }
        }
        return true;
    }

    private String fixName(String cfgName) {
        return cfgName.replaceAll("\\s", "_");
    }

    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return true;
    }

    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return false;
    }

    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return true;
    }
}

