/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.debugmail;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.ui.extension.factory.IReportingDescriptor;

public class ReportPartsFactory {
    public static boolean checkStatus(IStatus status, IStatusVisitor visitor) {
        if (!status.isMultiStatus()) {
            return visitor.visit(status);
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            if (ReportPartsFactory.checkStatus(children[i], visitor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getStackTrace(IStatus operationStatus) {
        final String[] stackTrace = new String[]{""};
        ReportPartsFactory.checkStatus(operationStatus, new IStatusVisitor(){

            public boolean visit(IStatus status) {
                String trace = ReportPartsFactory.getOutput(status);
                stackTrace[0] = String.valueOf(stackTrace[0]) + trace + "\n";
                return false;
            }
        });
        return stackTrace[0];
    }

    public static String getOutput(IStatus status) {
        Throwable t = status.getException();
        String message = "";
        if (t != null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(output);
            try {
                t.printStackTrace(writer);
            }
            finally {
                writer.close();
            }
            message = output.toString();
        }
        return message;
    }

    public static String removeHTMLTags(String report) {
        report = report.replaceAll("<b>", "");
        report = report.replaceAll("</b> ", "\t");
        report = report.replaceAll("</b>", "");
        report = report.replaceAll("<i>", "");
        report = report.replaceAll("</i>", "");
        report = report.replaceAll("<br>", "\n");
        return report;
    }

    public static String getStatusPart(IStatus status) {
        String retVal = "";
        String[] stackTraces = ReportPartsFactory.getStackTrace(status).split("\n\n");
        int i = 0;
        while (i < stackTraces.length) {
            int idx = stackTraces[i].indexOf(10);
            retVal = idx == -1 ? String.valueOf(retVal) + stackTraces[i] + "<br><br>" : String.valueOf(retVal) + "<b>" + stackTraces[i].substring(0, idx) + "</b><br>" + stackTraces[i] + "<br><br>";
            ++i;
        }
        retVal = String.valueOf(retVal) + "<br>";
        return retVal;
    }

    public static String getReportIdPart(String id) {
        return "<b>" + id + "</b><br><br>";
    }

    public static String getProductPart(IReportingDescriptor provider) {
        return "<b>Product:</b> " + provider.getProductName() + "<br><br>";
    }

    public static String getVersionPart(IReportingDescriptor provider) {
        return "<b>Version:</b> " + provider.getProductVersion() + "<br><br>";
    }

    public static String getAuthorPart(String email, String name) {
        String author = String.valueOf(name != null ? name : "") + (email != null && email.trim().length() > 0 ? " &lt;" + email + "&gt;" : "");
        author = author.trim().length() > 0 ? author : "<i>[not specified]</i>";
        return "<b>From:</b> " + author + "<br><br>";
    }

    public static String getUserCommentPart(String userComment) {
        userComment = userComment != null && userComment.trim().length() > 0 ? userComment : "<i>[empty]</i>";
        return "<b>User comment:</b><br>" + userComment + "<br><br>";
    }

    public static String getSVNClientPart() {
        ISVNConnectorFactory factory = CoreExtensionsManager.instance().getSVNConnectorFactory();
        return "<b>SVN Client:</b> " + factory.getId() + " " + factory.getVersion() + " " + factory.getClientVersion() + "<br><br>";
    }

    public static String getJVMPropertiesPart() {
        Properties systemProps = System.getProperties();
        Properties props = new Properties();
        String[] keys = new String[]{"os.name", "os.version", "os.arch", "user.timezone", "file.separator", "line.separator", "path.separator", "file.encoding", "user.language", "user.country", "java.version", "java.runtime.version", "java.class.version", "java.vm.name", "java.vm.info", "java.vendor", "java.runtime.name", "osgi.framework.version", "eclipse.commands"};
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (systemProps.containsKey(key)) {
                props.put(key, systemProps.getProperty(key));
            }
            ++i;
        }
        return "<b>JVM Properties:</b><br>" + props.toString().replace('\n', ' ') + "<br><br>";
    }

    public static interface IStatusVisitor {
        public boolean visit(IStatus var1);
    }
}

