/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.e4.finder.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchContentsFinder {
    private final IEclipseContext context;

    public WorkbenchContentsFinder(IEclipseContext context) {
        this.context = context;
    }

    public List<MPerspective> findPerspectives(Matcher<?> matcher) {
        MApplication application = (MApplication)this.context.get(MApplication.class);
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        List perspectives = modelService.findElements((MUIElement)application, null, MPerspective.class, null);
        ArrayList<MPerspective> matchingPerspectives = new ArrayList<MPerspective>();
        for (MPerspective perspective : perspectives) {
            if (!matcher.matches((Object)perspective)) continue;
            matchingPerspectives.add(perspective);
        }
        return matchingPerspectives;
    }

    public MPerspective findActivePerspective() {
        MApplication application = (MApplication)this.context.get(MApplication.class);
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        List windows = modelService.findElements((MUIElement)application, null, MWindow.class, null);
        return modelService.getActivePerspective((MWindow)windows.get(0));
    }

    public List<MPart> findParts(Matcher<?> matcher) {
        MPerspective perspective = this.findActivePerspective();
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        List parts = modelService.findElements((MUIElement)perspective, null, MPart.class, null);
        ArrayList<MPart> matchingParts = new ArrayList<MPart>();
        for (MPart part : parts) {
            if (!matcher.matches((Object)part)) continue;
            matchingParts.add(part);
        }
        return matchingParts;
    }

    public MPart findActivePart() {
        EPartService partService = (EPartService)this.context.get(EPartService.class);
        return partService.getActivePart();
    }
}

