/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.e4.finder.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.e4.finder.widgets.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarPushButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarRadioButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarSeparatorButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarToggleButton;

public class SWTBotView {
    private final SWTWorkbenchBot bot;
    private final MPart part;
    protected final Logger log;

    public SWTBotView(MPart part, SWTWorkbenchBot bot) {
        this.bot = bot;
        Assert.isNotNull((Object)part, (String)"The part cannot be null");
        this.part = part;
        this.log = Logger.getLogger(this.getClass());
    }

    public List<SWTBotToolbarButton> getToolbarButtons() {
        return (List)UIThreadRunnable.syncExec((Result)new ListResult<SWTBotToolbarButton>(){

            public List<SWTBotToolbarButton> run() {
                ArrayList<SWTBotToolbarButton> l = new ArrayList<SWTBotToolbarButton>();
                MToolBar toolbar = SWTBotView.this.part.getToolbar();
                for (MToolBarElement toolbarElement : toolbar.getChildren()) {
                    ToolItem toolItem = (ToolItem)toolbarElement.getWidget();
                    if (toolItem != null) {
                        try {
                            if (SWTUtils.hasStyle((Widget)toolItem, (int)8)) {
                                l.add((SWTBotToolbarButton)new SWTBotToolbarPushButton(toolItem));
                                continue;
                            }
                            if (SWTUtils.hasStyle((Widget)toolItem, (int)32)) {
                                l.add((SWTBotToolbarButton)new SWTBotToolbarToggleButton(toolItem));
                                continue;
                            }
                            if (SWTUtils.hasStyle((Widget)toolItem, (int)16)) {
                                l.add((SWTBotToolbarButton)new SWTBotToolbarRadioButton(toolItem));
                                continue;
                            }
                            if (SWTUtils.hasStyle((Widget)toolItem, (int)4)) {
                                l.add((SWTBotToolbarButton)new SWTBotToolbarDropDownButton(toolItem));
                                continue;
                            }
                            if (!SWTUtils.hasStyle((Widget)toolItem, (int)2)) continue;
                            l.add((SWTBotToolbarButton)new SWTBotToolbarSeparatorButton(toolItem));
                        }
                        catch (WidgetNotFoundException e) {
                            SWTBotView.this.log.warn((Object)("Failed to find widget " + toolItem.getText()), (Throwable)e);
                        }
                        continue;
                    }
                    SWTBotView.this.log.warn((Object)("Toolitem has not been created " + toolbarElement.getElementId()));
                }
                return l;
            }
        });
    }

    public SWTBotToolbarDropDownButton toolbarDropDownButton(String tooltip) throws WidgetNotFoundException {
        SWTBotToolbarButton abstractButton = this.toolbarButton(tooltip);
        if (abstractButton instanceof SWTBotToolbarDropDownButton) {
            return (SWTBotToolbarDropDownButton)abstractButton;
        }
        throw new WidgetNotFoundException("Unable to find toolitem with the given tooltip '" + tooltip + "'");
    }

    public SWTBotToolbarRadioButton toolbarRadioButton(String tooltip) throws WidgetNotFoundException {
        SWTBotToolbarButton abstractButton = this.toolbarButton(tooltip);
        if (abstractButton instanceof SWTBotToolbarRadioButton) {
            return (SWTBotToolbarRadioButton)abstractButton;
        }
        throw new WidgetNotFoundException("Unable to find toolitem with the given tooltip '" + tooltip + "'");
    }

    public SWTBotToolbarPushButton toolbarPushButton(String tooltip) throws WidgetNotFoundException {
        SWTBotToolbarButton abstractButton = this.toolbarButton(tooltip);
        if (abstractButton instanceof SWTBotToolbarPushButton) {
            return (SWTBotToolbarPushButton)abstractButton;
        }
        throw new WidgetNotFoundException("Unable to find toolitem with the given tooltip '" + tooltip + "'");
    }

    public SWTBotToolbarToggleButton toolbarToggleButton(String tooltip) throws WidgetNotFoundException {
        SWTBotToolbarButton abstractButton = this.toolbarButton(tooltip);
        if (abstractButton instanceof SWTBotToolbarToggleButton) {
            return (SWTBotToolbarToggleButton)abstractButton;
        }
        throw new WidgetNotFoundException("Unable to find toolitem with the given tooltip '" + tooltip + "'");
    }

    public SWTBotToolbarButton toolbarButton(String tooltip) throws WidgetNotFoundException {
        List<SWTBotToolbarButton> l = this.getToolbarButtons();
        int i = 0;
        while (i < l.size()) {
            SWTBotToolbarButton item = l.get(i);
            if (this.parseTooltipWithKeyboardModifier(item.getToolTipText()).equals(this.parseTooltipWithKeyboardModifier(tooltip))) {
                return item;
            }
            ++i;
        }
        throw new WidgetNotFoundException("Unable to find toolitem with the given tooltip '" + tooltip + "'");
    }

    private String parseTooltipWithKeyboardModifier(String tooltip) {
        Pattern pattern = Pattern.compile("(.*) (\\(.*\\))");
        Matcher matcher = pattern.matcher(tooltip);
        if (matcher.find()) {
            return matcher.group(1).toString();
        }
        return tooltip;
    }

    public void show() {
        this.bot.showPart(this.part);
    }

    public void close() {
        if (this.part.isDirty()) {
            UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

                public void run() {
                    SWTBotView.this.bot.closePart(SWTBotView.this.part);
                }
            });
        } else {
            this.bot.closePart(this.part);
        }
    }

    public MPart getPart() {
        return this.part;
    }

    public String getTitle() {
        return this.part.getLabel();
    }

    public String getId() {
        return this.part.getElementId();
    }

    public void maximise() {
        this.part.getParent().getTags().add("Maximized");
    }

    public void minimise() {
        this.part.getParent().getTags().add("Minimized");
    }

    public void restore() {
        this.part.getParent().getTags().remove("Maximized");
        this.part.getParent().getTags().remove("Minimized");
    }

    public SWTBot bot() {
        return new SWTBot((Widget)this.part.getWidget());
    }
}

