/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidAVD;
import org.eclipse.thym.android.core.adt.AndroidDevice;
import org.eclipse.thym.android.core.adt.AndroidSDK;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProjectConventions;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.core.internal.util.TextDetectingStreamListener;

public class AndroidSDKManager {
    private String toolsDir;
    private String platformTools;

    private AndroidSDKManager(String tools, String platform) {
        this.toolsDir = tools;
        this.platformTools = platform;
    }

    public static AndroidSDKManager getManager() throws CoreException {
        String sdkDir = AndroidCore.getSDKLocation();
        if (sdkDir == null) {
            throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.android.core", 200, "Android SDK location is not defined", null));
        }
        Path path = new Path(sdkDir);
        IPath tools = path.append("tools").addTrailingSeparator();
        IPath platform = path.append("platform-tools").addTrailingSeparator();
        AndroidSDKManager sdk = new AndroidSDKManager(tools.toOSString(), platform.toOSString());
        return sdk;
    }

    public void createProject(AndroidSDK target, String projectName, File path, String activity, String packageName, IProgressMonitor monitor) throws CoreException {
        IStatus status = HybridProjectConventions.validateProjectName((String)projectName);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        status = HybridProjectConventions.validateProjectName((String)activity);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        status = HybridProjectConventions.validateProjectID((String)packageName);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder();
        command.append(this.getAndroidCommand());
        command.append(" create project");
        command.append(" --target ").append(target.getId());
        command.append(" --path ").append(this.addQuotes(path.getPath()));
        command.append(" --name ").append(this.addQuotes(projectName));
        command.append(" --activity ").append(activity);
        command.append(" --package ").append(packageName);
        CreateProjectResultParser parser = new CreateProjectResultParser();
        processUtility.execSync(command.toString(), new File(this.toolsDir), (IStreamListener)parser, (IStreamListener)parser, monitor, null, null);
        if (!monitor.isCanceled() && parser.getErrorString() != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error creating the Android project: " + parser.getErrorString()));
        }
    }

    public void updateProject(AndroidSDK sdk, String projectName, boolean isLibrary, File path, IProgressMonitor monitor) throws CoreException {
        StringBuilder command = new StringBuilder(this.getAndroidCommand());
        command.append(" update");
        if (isLibrary) {
            command.append(" lib-project");
        } else {
            command.append(" project");
        }
        command.append(" --target ").append(sdk.getId());
        if (projectName != null) {
            IStatus status = HybridProjectConventions.validateProjectName((String)projectName);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            command.append(" --name ").append('\"').append(projectName).append('\"');
        }
        command.append(" --path ").append('\"').append(path.getPath()).append('\"');
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        CreateProjectResultParser parser = new CreateProjectResultParser();
        processUtility.execSync(command.toString(), new File(this.toolsDir), (IStreamListener)parser, (IStreamListener)parser, monitor, null, null);
        if (!monitor.isCanceled() && parser.getErrorString() != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error creating the Android project: " + parser.getErrorString()));
        }
    }

    public void startADBServer() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(String.valueOf(this.getADBCommand()) + " start-server", null, null, null, (IProgressMonitor)new NullProgressMonitor(), null, null);
    }

    public void killADBServer() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(String.valueOf(this.getADBCommand()) + " kill-server", null, null, null, (IProgressMonitor)new NullProgressMonitor(), null, null);
    }

    public List<AndroidAVD> listAVDs() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        AVDListParser parser = new AVDListParser();
        processUtility.execSync(String.valueOf(this.getAndroidCommand()) + " list avd", new File(this.toolsDir), (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getAVDList();
    }

    public List<AndroidSDK> listTargets() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        TargetListParser parser = new TargetListParser();
        processUtility.execSync(String.valueOf(this.getAndroidCommand()) + " list target", new File(this.toolsDir), (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getSDKList();
    }

    public List<AndroidDevice> listDevices() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        DeviceListParser parser = new DeviceListParser();
        processUtility.execSync(String.valueOf(this.getADBCommand()) + " devices", null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        List<AndroidDevice> devices = parser.getDeviceList();
        if (devices == null) {
            devices = Collections.emptyList();
        }
        return devices;
    }

    public void installApk(File apkFile, String serialNumber, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)serialNumber);
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder(this.getADBCommand());
        command.append(" -s ").append(serialNumber);
        command.append(" install");
        command.append(" -r ");
        command.append("\"").append(apkFile.getPath()).append("\"");
        TextDetectingStreamListener listener = new TextDetectingStreamListener("Success");
        processUtility.execSync(command.toString(), null, (IStreamListener)listener, (IStreamListener)listener, monitor, null, null);
        if (!monitor.isCanceled() && !listener.isTextDetected()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "APK installation did not succeed"));
        }
    }

    public void waitForEmulator() throws CoreException {
        while (true) {
            List<AndroidDevice> devices;
            if ((devices = this.listDevices()) != null) {
                for (AndroidDevice androidDevice : devices) {
                    if (!androidDevice.isEmulator() || androidDevice.getState() != 2) continue;
                    return;
                }
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void startApp(String component, String serialNumber, IProgressMonitor monitor) throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder(this.getADBCommand());
        command.append(" -s ").append(serialNumber);
        command.append(" shell am start");
        command.append(" -n ");
        command.append(component);
        processUtility.execSync(command.toString(), null, null, null, monitor, null, null);
    }

    public void logcat(String filter, IStreamListener outListener, IStreamListener errorListener, String serialNumber) throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder(this.getADBCommand());
        command.append(" -s ").append(serialNumber);
        command.append(" logcat ");
        if (filter != null && !filter.isEmpty()) {
            command.append(filter);
        }
        processUtility.execAsync(command.toString(), null, outListener, errorListener, null);
    }

    public void startEmulator(String avd) throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder(this.getEmulatorCommand());
        command.append(" -cpu-delay 0");
        command.append(" -no-boot-anim");
        command.append(" -avd ").append(avd);
        processUtility.execAsync(command.toString(), null, null, null, null);
    }

    public void startAVDManager() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        StringBuilder command = new StringBuilder(this.getAndroidCommand());
        command.append(" avd ");
        processUtility.execAsync(command.toString(), new File(this.toolsDir), null, null, null);
    }

    private String getAndroidCommand() {
        String command = this.addQuotes(String.valueOf(this.toolsDir) + "android");
        return this.isWindows() ? "cmd /c " + command : command;
    }

    private String getADBCommand() {
        return this.addQuotes(String.valueOf(this.platformTools) + "adb");
    }

    private String getEmulatorCommand() {
        return this.addQuotes(String.valueOf(this.toolsDir) + "emulator");
    }

    private boolean isWindows() {
        String OS = System.getProperty("os.name", "unknown");
        return OS.toLowerCase().indexOf("win") > -1;
    }

    private String addQuotes(String path) {
        return "\"" + path + "\"";
    }

    private static class AVDListParser
    implements IStreamListener {
        private static final String PREFIX_NAME = "Name:";
        private static final String MARKER_LEVEL = "API level";
        private StringBuffer buffer = new StringBuffer();

        private AVDListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public List<AndroidAVD> getAVDList() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            StringReader reader = new StringReader(this.buffer.toString());
            BufferedReader read = new BufferedReader(reader);
            String line = null;
            ArrayList<AndroidAVD> list = new ArrayList<AndroidAVD>();
            try {
                try {
                    AndroidAVD currentAVD = null;
                    while ((line = read.readLine()) != null) {
                        int idx = line.indexOf(PREFIX_NAME);
                        if (idx > -1) {
                            currentAVD = new AndroidAVD();
                            currentAVD.setName(line.substring(idx + PREFIX_NAME.length()).trim());
                            continue;
                        }
                        idx = line.indexOf(MARKER_LEVEL);
                        if (idx <= -1 || currentAVD == null) continue;
                        int startIndex = idx + MARKER_LEVEL.length();
                        int endIndex = line.lastIndexOf(41);
                        currentAVD.setApiLevel(line.substring(startIndex, endIndex).trim());
                        list.add(currentAVD);
                        currentAVD = null;
                    }
                }
                catch (IOException e) {
                    AndroidCore.log(4, "Error parsing the AVD list", e);
                    List<AndroidAVD> list2 = Collections.emptyList();
                    try {
                        read.close();
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    return list2;
                }
            }
            catch (Throwable throwable) {
                try {
                    read.close();
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                read.close();
                reader.close();
            }
            catch (IOException iOException) {}
            return list;
        }
    }

    private static class CreateProjectResultParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private CreateProjectResultParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        /*
         * Loose catch block
         */
        public String getErrorString() {
            String text = this.buffer.toString();
            if (text.startsWith("Error:")) {
                String line;
                BufferedReader read;
                StringReader reader;
                block14: {
                    reader = new StringReader(text);
                    read = new BufferedReader(reader);
                    line = read.readLine();
                    if (line != null) break block14;
                    try {
                        read.close();
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    return "";
                }
                String string = line.substring(7);
                try {
                    read.close();
                    reader.close();
                }
                catch (IOException iOException) {}
                return string;
                catch (IOException e) {
                    try {
                        AndroidCore.log(4, "Error parsing the create project command result", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            read.close();
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        read.close();
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }

    private static class DeviceListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private DeviceListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public List<AndroidDevice> getDeviceList() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            StringReader reader = new StringReader(this.buffer.toString());
            BufferedReader read = new BufferedReader(reader);
            String line = null;
            ArrayList<AndroidDevice> list = new ArrayList<AndroidDevice>();
            try {
                try {
                    while ((line = read.readLine()) != null) {
                        String[] values;
                        if (line.isEmpty() || line.contains("List of devices attached") || (values = line.split("\t")).length != 2) continue;
                        AndroidDevice device = new AndroidDevice();
                        device.setSerialNumber(values[0].trim());
                        device.setEmulator(values[0].contains("emulator"));
                        if ("device".equals(values[1].trim())) {
                            device.setState(2);
                        } else if ("offline".equals(values[1].trim())) {
                            device.setState(1);
                        }
                        list.add(device);
                    }
                }
                catch (IOException e) {
                    AndroidCore.log(4, "Error parsing the Android device list", e);
                    try {
                        read.close();
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    return null;
                }
            }
            catch (Throwable throwable) {
                try {
                    read.close();
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                read.close();
                reader.close();
            }
            catch (IOException iOException) {}
            return list;
        }
    }

    private static class TargetListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private TargetListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public List<AndroidSDK> getSDKList() {
            ArrayList<AndroidSDK> sdkList;
            block15: {
                if (this.buffer == null || this.buffer.length() < 1) {
                    return null;
                }
                StringReader reader = new StringReader(this.buffer.toString());
                BufferedReader read = new BufferedReader(reader);
                sdkList = new ArrayList<AndroidSDK>();
                String line = null;
                try {
                    try {
                        AndroidSDK sdk = null;
                        while ((line = read.readLine()) != null) {
                            int scolIdx = line.indexOf(58);
                            if (scolIdx < 0) continue;
                            String[] pair = new String[]{line.substring(0, scolIdx).trim(), line.substring(scolIdx + 1).trim()};
                            if ("id".equalsIgnoreCase(pair[0])) {
                                sdk = new AndroidSDK();
                                sdkList.add(sdk);
                                int vIndex = pair[1].indexOf("or");
                                sdk.setId(pair[1].substring(vIndex + "or".length()).replace("\"", "").trim());
                                continue;
                            }
                            if ("Type".equalsIgnoreCase(pair[0])) {
                                Assert.isNotNull((Object)sdk);
                                sdk.setType(pair[1].trim());
                                continue;
                            }
                            if (!"API level".equalsIgnoreCase(pair[0])) continue;
                            Assert.isNotNull((Object)sdk);
                            sdk.setApiLevel(pair[1]);
                        }
                    }
                    catch (IOException e) {
                        AndroidCore.log(4, "Error parsing the SDK list", e);
                        try {
                            read.close();
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        read.close();
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    read.close();
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            return sdkList;
        }
    }
}

