/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.thym.android.core.adt.AndroidProjectGenerator;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;

public class BuildDelegate
extends AbstractNativeBinaryBuildDelegate {
    private File binaryDirectory;

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        AndroidProjectGenerator creator = new AndroidProjectGenerator(this.getProject(), this.getDestination(), "android");
        SubProgressMonitor generateMonitor = new SubProgressMonitor(monitor, 1);
        File projectDirectory = creator.generateNow((IProgressMonitor)generateMonitor);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        this.buildProject(projectDirectory, monitor);
        monitor.done();
    }

    public void buildProject(File projectLocation, IProgressMonitor monitor) throws CoreException {
        this.doBuildProject(projectLocation, false, monitor);
    }

    public void buildLibraryProject(File projectLocation, IProgressMonitor monitor) throws CoreException {
        this.doBuildProject(projectLocation, true, monitor);
    }

    private void doBuildProject(File projectLocation, boolean isLibrary, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType antLaunchConfigType = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (antLaunchConfigType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Ant launch configuration type is not available"));
        }
        ILaunchConfigurationWorkingCopy wc = antLaunchConfigType.newInstance(null, "Android project builder");
        wc.setContainer(null);
        File buildFile = new File(projectLocation, "build.xml");
        if (!buildFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "build.xml does not exist in " + projectLocation.getPath()));
        }
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFile.getPath());
        String target = null;
        if (isLibrary) {
            target = "jar";
        } else {
            target = "debug";
            if (this.isRelease()) {
                target = "release";
            }
        }
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", target);
        wc.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", true);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute("org.eclipse.debug.core.capture_output", true);
        ILaunchConfiguration launchConfig = wc.doSave();
        if (monitor.isCanceled()) {
            return;
        }
        launchConfig.launch("run", monitor, true, true);
        this.binaryDirectory = new File(projectLocation, "bin");
        if (!isLibrary) {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (this.isRelease()) {
                this.setBuildArtifact(new File(this.binaryDirectory, String.valueOf(hybridProject.getBuildArtifactAppName()) + "-release-unsigned.apk"));
            } else {
                this.setBuildArtifact(new File(this.binaryDirectory, String.valueOf(hybridProject.getBuildArtifactAppName()) + "-debug.apk"));
            }
            if (!this.getBuildArtifact().exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Build failed... Build artifact does not exist"));
            }
        }
    }

    public File getBinaryDirectory() {
        return this.binaryDirectory;
    }
}

