/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.services;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.iot.tiaki.DnsDiscovery;
import org.eclipse.iot.tiaki.commons.Configurable;
import org.eclipse.iot.tiaki.commons.LookupContext;
import org.eclipse.iot.tiaki.commons.StatusChangeEvent;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.domain.CertRecord;
import org.eclipse.iot.tiaki.domain.CompoundLabel;
import org.eclipse.iot.tiaki.domain.DnsCertPrefix;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.domain.PointerRecord;
import org.eclipse.iot.tiaki.domain.RecordsContainer;
import org.eclipse.iot.tiaki.domain.ServiceInstance;
import org.eclipse.iot.tiaki.domain.ServiceRecord;
import org.eclipse.iot.tiaki.domain.TextRecord;
import org.eclipse.iot.tiaki.exceptions.ConfigurationException;
import org.eclipse.iot.tiaki.exceptions.LookupException;
import org.eclipse.iot.tiaki.utils.DnsUtil;
import org.eclipse.iot.tiaki.utils.ExceptionsUtil;
import org.eclipse.iot.tiaki.utils.FormattingUtil;
import org.eclipse.iot.tiaki.utils.ValidatorUtil;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TLSARecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Type;

public class DnsServicesDiscovery
extends Configurable
implements DnsDiscovery {
    private Cache anyClassCache = new Cache(255);
    private ThreadLocal<Map<String, StatusCode>> errorsTrace;
    private ServicesLookupHelper helper;

    public DnsServicesDiscovery() {
        this(1000, 900);
    }

    public DnsServicesDiscovery(int cacheSize, int cacheTTL) {
        this.anyClassCache.setMaxEntries(cacheSize);
        this.anyClassCache.setMaxNCache(cacheTTL);
        this.helper = new ServicesLookupHelper();
        this.errorsTrace = new ThreadLocal<Map<String, StatusCode>>(){

            @Override
            protected Map<String, StatusCode> initialValue() {
                return new LinkedHashMap<String, StatusCode>();
            }
        };
    }

    @Override
    public Set<String> listServiceTypes(Fqdn browsingDomain, boolean secValidation) throws LookupException, ConfigurationException {
        try {
            ValidatorUtil.isValidDomainName(browsingDomain);
        }
        catch (IllegalArgumentException exception) {
            throw new LookupException(StatusCode.ILLEGAL_FQDN, browsingDomain.fqdn());
        }
        this.validatedConf();
        TreeSet<String> result = null;
        try {
            result = new TreeSet<String>();
            result.addAll(this.helper.serviceTypes(browsingDomain, secValidation));
            if (result.isEmpty() && !ExceptionsUtil.onlyNameResolutionTrace(this.errorsTrace.get())) {
                throw ExceptionsUtil.build(StatusCode.RESOURCE_LOOKUP_ERROR, FormattingUtil.unableToResolve(browsingDomain.fqdn()), this.errorsTrace.get());
            }
        }
        catch (ConfigurationException | LookupException exception) {
            throw exception;
        }
        finally {
            this.errorsTrace.remove();
        }
        return result;
    }

    @Override
    public Set<ServiceInstance> listServiceInstances(Fqdn browsingDomain, CompoundLabel type, boolean secValidation) throws LookupException, ConfigurationException {
        try {
            ValidatorUtil.isValidDomainName(browsingDomain);
        }
        catch (IllegalArgumentException exception) {
            throw new LookupException(StatusCode.ILLEGAL_FQDN, browsingDomain.fqdn());
        }
        ValidatorUtil.isValidLabel(type);
        this.validatedConf();
        TreeSet<ServiceInstance> result = null;
        try {
            result = new TreeSet<ServiceInstance>();
            result.addAll(this.helper.serviceInstances(browsingDomain, type, secValidation));
            if (result.isEmpty() && !ExceptionsUtil.onlyNameResolutionTrace(this.errorsTrace.get())) {
                throw ExceptionsUtil.build(StatusCode.RESOURCE_LOOKUP_ERROR, FormattingUtil.unableToResolve(browsingDomain.fqdnWithPrefix(type.prefixString())), this.errorsTrace.get());
            }
        }
        catch (ConfigurationException | LookupException exception) {
            throw exception;
        }
        finally {
            this.errorsTrace.remove();
        }
        return result;
    }

    @Override
    public Set<TextRecord> listTextRecords(Fqdn browsingDomain, String label, boolean secValidation) throws LookupException, ConfigurationException {
        try {
            ValidatorUtil.isValidDomainName(browsingDomain);
        }
        catch (IllegalArgumentException exception) {
            throw new LookupException(StatusCode.ILLEGAL_FQDN, browsingDomain.fqdn());
        }
        ValidatorUtil.isValidLabel(label);
        this.validatedConf();
        TreeSet<TextRecord> result = null;
        try {
            result = new TreeSet<TextRecord>();
            Fqdn txtFqdn = new Fqdn(label, browsingDomain.domain());
            result.addAll(this.helper.serviceTexts(txtFqdn, label, secValidation));
            if (result.isEmpty() && !ExceptionsUtil.onlyNameResolutionTrace(this.errorsTrace.get())) {
                throw ExceptionsUtil.build(StatusCode.RESOURCE_LOOKUP_ERROR, FormattingUtil.unableToResolve(browsingDomain.fqdnWithPrefix(label)), this.errorsTrace.get());
            }
        }
        catch (ConfigurationException | LookupException exception) {
            throw exception;
        }
        finally {
            this.errorsTrace.remove();
        }
        return result;
    }

    @Override
    public Set<CertRecord> listTLSARecords(Fqdn browsingDomain, DnsCertPrefix tlsaPrefix, boolean secValidation) throws LookupException, ConfigurationException {
        try {
            ValidatorUtil.isValidDomainName(browsingDomain);
        }
        catch (IllegalArgumentException exception) {
            throw new LookupException(StatusCode.ILLEGAL_FQDN, browsingDomain.fqdn());
        }
        this.validatedConf();
        TreeSet<CertRecord> result = null;
        try {
            result = new TreeSet<CertRecord>();
            result.addAll(this.helper.tlsaRecords(browsingDomain, tlsaPrefix, secValidation));
            if (result.isEmpty() && !ExceptionsUtil.onlyNameResolutionTrace(this.errorsTrace.get())) {
                throw ExceptionsUtil.build(StatusCode.RESOURCE_LOOKUP_ERROR, FormattingUtil.unableToResolve(browsingDomain.fqdn()), this.errorsTrace.get());
            }
        }
        catch (LookupException exception) {
            throw exception;
        }
        finally {
            this.errorsTrace.remove();
        }
        return result;
    }

    @Override
    public boolean isDnsSecValid(Fqdn name) throws LookupException, ConfigurationException {
        try {
            ValidatorUtil.isValidDomainName(name);
        }
        catch (IllegalArgumentException exception) {
            throw new LookupException(StatusCode.ILLEGAL_FQDN, name.fqdn());
        }
        this.validatedConf();
        if (name == null || name.fqdn().isEmpty()) {
            name = new Fqdn(this.dnsSecDomain);
        }
        Map<String, Resolver> resolvers = this.retrieveResolvers(true);
        Iterator<String> itrResolvers = resolvers.keySet().iterator();
        boolean validated = false;
        String server = null;
        do {
            server = itrResolvers.next();
            this.statusChange(FormattingUtil.server(server));
            this.statusChange(FormattingUtil.query(name, "", "SOA"));
            try {
                validated = DnsUtil.checkDnsSec(name, resolvers.get(server), 6);
                if (validated) {
                    this.statusChange(FormattingUtil.response(FormattingUtil.authenticData(name.fqdn())));
                    continue;
                }
                this.statusChange(FormattingUtil.response(FormattingUtil.networkError(name.fqdn())));
            }
            catch (LookupException le) {
                if (le.dnsError() == StatusCode.RESOURCE_LOOKUP_ERROR) {
                    this.statusChange(FormattingUtil.response(FormattingUtil.unableToResolve(name.fqdn())));
                } else {
                    this.statusChange(FormattingUtil.response(FormattingUtil.unableToValidate(name.fqdn())));
                }
                if (le.dnsError() == StatusCode.RESOURCE_INSECURE_ERROR) {
                    throw ExceptionsUtil.build(StatusCode.DNSSEC_STATUS_ERROR, "DNSSEC Validation Failed", new LinkedHashMap<String, StatusCode>());
                }
                throw le;
            }
        } while (itrResolvers.hasNext() && !validated);
        return validated;
    }

    private Map<String, Resolver> retrieveResolvers(boolean secValidation) throws ConfigurationException {
        LinkedHashMap<String, Resolver> resolvers = new LinkedHashMap<String, Resolver>();
        for (InetAddress dnsServer : this.dnsServers) {
            if (!(dnsServer == null || dnsServer.getHostAddress().isEmpty() && dnsServer.getCanonicalHostName().isEmpty())) {
                String server = dnsServer.getHostAddress().isEmpty() ? dnsServer.getCanonicalHostName() : dnsServer.getHostAddress();
                resolvers.put(server, DnsUtil.getResolver(secValidation, this.trustAnchorDefault, server));
                continue;
            }
            resolvers.putAll(DnsUtil.getResolvers(secValidation, this.trustAnchorDefault));
        }
        return resolvers;
    }

    private final class ServicesLookupHelper {
        public Set<String> serviceTypes(Fqdn browsingDomain, boolean secValidation) throws LookupException, ConfigurationException {
            DnsServicesDiscovery.this.statusChange(FormattingUtil.info(secValidation ? "Secure Resolving mode" : "Insecure Resolving mode"));
            Map resolvers = DnsServicesDiscovery.this.retrieveResolvers(false);
            Map valResolvers = DnsServicesDiscovery.this.retrieveResolvers(true);
            RecordsContainer set = new RecordsContainer();
            ((Map)DnsServicesDiscovery.this.errorsTrace.get()).clear();
            Iterator itrResolvers = resolvers.keySet().iterator();
            LookupContext ctx = DnsUtil.context(browsingDomain, "_services._dns-sd._udp", "", "", 12, secValidation);
            String server = null;
            do {
                server = (String)itrResolvers.next();
                Resolver resolver = (Resolver)resolvers.get(server);
                ctx.setResolver(resolver);
                Resolver valResolver = (Resolver)valResolvers.get(server);
                ctx.setValResolver(valResolver);
                DnsServicesDiscovery.this.statusChange(FormattingUtil.server(server));
                try {
                    Object[] records = this.lookup(ctx);
                    set.getLabels().addAll(DnsUtil.extractNamesFromRecords((Record[])records));
                    DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(browsingDomain.fqdn(), Type.string(12), StatusChangeEvent.castedArray(records)));
                }
                catch (LookupException le) {
                    if (le.dnsError().equals((Object)StatusCode.NETWORK_ERROR) && !itrResolvers.hasNext()) {
                        throw le;
                    }
                    if (le.dnsError().equals((Object)StatusCode.SERVER_ERROR) || le.dnsError().equals((Object)StatusCode.RESOURCE_INSECURE_ERROR)) {
                        throw le;
                    }
                    ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(resolver, browsingDomain.fqdn(), "Retrieving-Types"), le.dnsError());
                }
            } while (itrResolvers.hasNext() && set.getLabels().isEmpty());
            DnsServicesDiscovery.this.statusChange(FormattingUtil.answer());
            return set.getLabels();
        }

        public Set<TextRecord> serviceTexts(Fqdn browsingDomain, String label, boolean secValidation) throws LookupException, ConfigurationException {
            DnsServicesDiscovery.this.statusChange(FormattingUtil.info(secValidation ? "Secure Resolving mode" : "Insecure Resolving mode"));
            Map resolvers = DnsServicesDiscovery.this.retrieveResolvers(false);
            Map valResolvers = DnsServicesDiscovery.this.retrieveResolvers(true);
            RecordsContainer set = new RecordsContainer();
            ((Map)DnsServicesDiscovery.this.errorsTrace.get()).clear();
            Iterator itrResolvers = resolvers.keySet().iterator();
            LookupContext ctx = DnsUtil.context(browsingDomain, label, label, "", 16, secValidation);
            String server = null;
            do {
                server = (String)itrResolvers.next();
                Resolver resolver = (Resolver)resolvers.get(server);
                ctx.setResolver(resolver);
                Resolver valResolver = (Resolver)valResolvers.get(server);
                ctx.setValResolver(valResolver);
                DnsServicesDiscovery.this.statusChange(FormattingUtil.server(server));
                try {
                    Record[] records = this.lookup(ctx);
                    this.parseRecords(records, set, RrHolderType.OTHER);
                    DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(browsingDomain.fqdnWithPrefix(label), "", StatusChangeEvent.castedList(set.getTexts())));
                }
                catch (LookupException le) {
                    if (le.dnsError().equals((Object)StatusCode.NETWORK_ERROR) && !itrResolvers.hasNext()) {
                        throw le;
                    }
                    if (le.dnsError().equals((Object)StatusCode.SERVER_ERROR) || le.dnsError().equals((Object)StatusCode.RESOURCE_INSECURE_ERROR)) {
                        throw le;
                    }
                    ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(resolver, browsingDomain.fqdnWithPrefix(label), "Retrieving-Texts"), le.dnsError());
                }
            } while (itrResolvers.hasNext() && set.getTexts().isEmpty());
            DnsServicesDiscovery.this.statusChange(FormattingUtil.answer());
            return set.getTexts();
        }

        public Set<ServiceInstance> serviceInstances(Fqdn browsingDomain, CompoundLabel type, boolean secValidation) throws LookupException, ConfigurationException {
            DnsServicesDiscovery.this.statusChange(FormattingUtil.info(secValidation ? "Secure Resolving mode" : "Insecure Resolving mode"));
            Map resolvers = DnsServicesDiscovery.this.retrieveResolvers(false);
            Map valResolvers = DnsServicesDiscovery.this.retrieveResolvers(true);
            TreeSet<ServiceInstance> instances = new TreeSet<ServiceInstance>();
            ((Map)DnsServicesDiscovery.this.errorsTrace.get()).clear();
            Iterator itrResolvers = resolvers.keySet().iterator();
            boolean bySubType = type.hasSubType();
            boolean byProto = type.hasProtocol();
            LookupContext ctx = DnsUtil.context(browsingDomain, "", "", type.getType(), 12, secValidation);
            String server = null;
            do {
                server = (String)itrResolvers.next();
                Resolver resolver = (Resolver)resolvers.get(server);
                ctx.setResolver(resolver);
                Resolver valResolver = (Resolver)valResolvers.get(server);
                ctx.setValResolver(valResolver);
                DnsServicesDiscovery.this.statusChange(FormattingUtil.server(server));
                try {
                    TreeSet<String> types = new TreeSet<String>();
                    ctx.setDomainName(browsingDomain);
                    if (!bySubType) {
                        if (!byProto) {
                            ctx.setLabel(type.prefixString("_tcp"));
                            types.addAll(DnsUtil.filterByType(type.prefixString("_tcp"), this.retrieveDnsSdTypes(ctx)));
                            ctx.setLabel(type.prefixString("_udp"));
                            types.addAll(DnsUtil.filterByType(type.prefixString("_udp"), this.retrieveDnsSdTypes(ctx)));
                        } else {
                            ctx.setLabel(type.prefixString());
                            types.addAll(DnsUtil.filterByType(type.prefixString(), this.retrieveDnsSdTypes(ctx)));
                        }
                        DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()), Type.string(ctx.getRrType()), StatusChangeEvent.castedList(types)));
                    } else if (!byProto) {
                        types.add(browsingDomain.fqdnWithPrefix(type.prefixString("_tcp")));
                        types.add(browsingDomain.fqdnWithPrefix(type.prefixString("_udp")));
                    } else {
                        types.add(browsingDomain.fqdnWithPrefix(type.prefixString()));
                    }
                    Set<String> names = this.retrieveDnsNames(ctx, types);
                    ctx.setDomainName(browsingDomain);
                    DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()), Type.string(ctx.getRrType()), StatusChangeEvent.castedList(names)));
                    instances.addAll(this.retrieveDnsInstances(ctx, names));
                }
                catch (LookupException le) {
                    if (le.dnsError().equals((Object)StatusCode.NETWORK_ERROR) && !itrResolvers.hasNext()) {
                        throw le;
                    }
                    if (le.dnsError().equals((Object)StatusCode.SERVER_ERROR) || le.dnsError().equals((Object)StatusCode.RESOURCE_INSECURE_ERROR)) {
                        throw le;
                    }
                    ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(resolver, browsingDomain.fqdnWithPrefix(type.prefixString()), "Retrieving-Instances"), le.dnsError());
                }
            } while (itrResolvers.hasNext() && instances.isEmpty());
            DnsServicesDiscovery.this.statusChange(FormattingUtil.answer());
            return instances;
        }

        public Set<CertRecord> tlsaRecords(Fqdn browsingDomain, DnsCertPrefix tlsaPrefix, boolean secValidation) throws LookupException, ConfigurationException {
            DnsServicesDiscovery.this.statusChange(FormattingUtil.info(secValidation ? "Secure Resolving mode" : "Insecure Resolving mode"));
            Map resolvers = DnsServicesDiscovery.this.retrieveResolvers(false);
            Map valResolvers = DnsServicesDiscovery.this.retrieveResolvers(true);
            TreeSet<CertRecord> tlsaDiscoveryRecords = new TreeSet<CertRecord>();
            ((Map)DnsServicesDiscovery.this.errorsTrace.get()).clear();
            Iterator itrResolvers = resolvers.keySet().iterator();
            String tlsaFqdn = tlsaPrefix.toString() + "." + browsingDomain.fqdn();
            Fqdn browsingDomainWithTLSAPrefix = new Fqdn(tlsaFqdn);
            LookupContext ctx = DnsUtil.context(browsingDomainWithTLSAPrefix, "", "", "", 52, secValidation);
            do {
                String server = (String)itrResolvers.next();
                Resolver resolver = (Resolver)resolvers.get(server);
                ctx.setResolver(resolver);
                Resolver valResolver = (Resolver)valResolvers.get(server);
                ctx.setValResolver(valResolver);
                DnsServicesDiscovery.this.statusChange(FormattingUtil.server(server));
                try {
                    Record[] records;
                    for (Record record : records = this.lookup(ctx)) {
                        if (!(record instanceof TLSARecord)) continue;
                        tlsaDiscoveryRecords.add(new CertRecord((TLSARecord)record));
                    }
                    DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()), "", StatusChangeEvent.castedList(tlsaDiscoveryRecords)));
                }
                catch (LookupException le) {
                    if (le.dnsError().equals((Object)StatusCode.NETWORK_ERROR) && !itrResolvers.hasNext()) {
                        throw le;
                    }
                    if (le.dnsError().equals((Object)StatusCode.SERVER_ERROR) || le.dnsError().equals((Object)StatusCode.RESOURCE_INSECURE_ERROR)) {
                        throw le;
                    }
                    ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(resolver, browsingDomain.domain(), "Retrieving-Instances"), le.dnsError());
                }
            } while (itrResolvers.hasNext() && tlsaDiscoveryRecords.isEmpty());
            DnsServicesDiscovery.this.statusChange(FormattingUtil.answer());
            return tlsaDiscoveryRecords;
        }

        private Record[] lookup(LookupContext ctx) throws LookupException {
            Lookup lookup2 = DnsUtil.instantiateLookup(ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()), ctx.getResolver(), ctx.getRrType(), DnsServicesDiscovery.this.anyClassCache);
            ctx.setLookup(lookup2);
            Record[] records = lookup2.run();
            if (records == null && ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()).contains("\"")) {
                lookup2 = DnsUtil.instantiateLookup(ctx.getDomainName().fqdnWithPrefix(ctx.getPrefix()).replaceAll("\"", ""), ctx.getResolver(), ctx.getRrType(), DnsServicesDiscovery.this.anyClassCache);
                ctx.setLookup(lookup2);
                records = lookup2.run();
            }
            DnsServicesDiscovery.this.statusChange(FormattingUtil.query(ctx.getDomainName(), ctx.getPrefix(), Type.string(ctx.getRrType())));
            StatusCode outcome = DnsUtil.checkLookupStatus(lookup2);
            if (outcome == StatusCode.SUCCESSFUL_OPERATION) {
                if (records != null && records.length > 0 && ctx.isSecure()) {
                    Fqdn toCheck = new Fqdn(ctx.getPrefix(), ctx.getDomainName().domain());
                    DnsUtil.checkDnsSec(toCheck, ctx.getValResolver(), ctx.getRrType());
                }
            } else {
                if (outcome.equals((Object)StatusCode.SERVER_ERROR) || outcome.equals((Object)StatusCode.NETWORK_ERROR)) {
                    throw ExceptionsUtil.build(outcome, FormattingUtil.unableToResolve(ctx.getDomainName().fqdn()), (Map)DnsServicesDiscovery.this.errorsTrace.get());
                }
                ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(ctx.getResolver(), ctx.getResolver().toString() + ctx.getDomainName(), "Checking-Lookup-Status"), outcome);
            }
            return records == null ? new Record[]{} : records;
        }

        private Set<String> retrieveDnsSdTypes(LookupContext ctx) throws LookupException {
            ctx.setPrefix("_services._dns-sd._udp");
            ctx.setRrType(12);
            Record[] records = this.lookup(ctx);
            RecordsContainer set = new RecordsContainer();
            this.parseRecords(records, set, RrHolderType.ZONES);
            return set.getLabels();
        }

        private Set<String> retrieveDnsNames(LookupContext ctx, Set<String> zones) throws LookupException {
            ctx.setPrefix("");
            ctx.setRrType(12);
            RecordsContainer set = new RecordsContainer();
            for (String zone : zones) {
                ctx.setDomainName(new Fqdn(zone));
                Record[] records = this.lookup(ctx);
                this.parseRecords(records, set, RrHolderType.NAMES);
            }
            return set.getLabels();
        }

        private Set<ServiceRecord> retrieveDnsRecords(LookupContext ctx, Set<String> svcNames) throws LookupException {
            RecordsContainer set = new RecordsContainer();
            ctx.setPrefix("");
            ctx.setRrType(33);
            for (String svcName : svcNames) {
                ctx.setDomainName(new Fqdn(svcName));
                Record[] records = this.lookup(ctx);
                this.parseRecords(records, set, RrHolderType.OTHER);
            }
            return set.getRecords();
        }

        private Set<ServiceInstance> retrieveDnsInstances(LookupContext ctx, Set<String> svcNames) throws LookupException {
            TreeSet<ServiceInstance> svcInstances = new TreeSet<ServiceInstance>();
            LinkedHashSet<String> aName = new LinkedHashSet<String>();
            RecordsContainer set = new RecordsContainer();
            for (String svcName : svcNames) {
                aName.clear();
                set.getTexts().clear();
                aName.add(svcName);
                Set<ServiceRecord> svcRecords = this.retrieveDnsRecords(ctx, aName);
                DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(svcName, "", StatusChangeEvent.castedList(svcRecords)));
                if (svcRecords.isEmpty()) continue;
                ctx.setPrefix("");
                ctx.setRrType(16);
                ctx.setDomainName(new Fqdn(svcName));
                Record[] records = this.lookup(ctx);
                this.parseRecords(records, set, RrHolderType.OTHER);
                DnsServicesDiscovery.this.statusChange(StatusChangeEvent.build(svcName, "", StatusChangeEvent.castedList(set.getTexts())));
                if (set.getTexts().isEmpty()) continue;
                svcInstances.add(new ServiceInstance(ctx.getType(), svcRecords.iterator().next(), TextRecord.build(set.getTexts())));
            }
            return svcInstances;
        }

        private void parseRecords(Record[] records, RecordsContainer set, RrHolderType pht) {
            if (records != null) {
                for (Record record : records) {
                    if (record instanceof PTRRecord && pht == RrHolderType.ZONES || record instanceof PTRRecord && pht == RrHolderType.NAMES) {
                        String zone = PointerRecord.build((PTRRecord)record).getRData();
                        if (zone == null) continue;
                        set.getLabels().add(zone);
                        continue;
                    }
                    if (record instanceof PTRRecord && pht == RrHolderType.TYPES) {
                        set.getLabels().add(PointerRecord.build((PTRRecord)record).getServiceType());
                        continue;
                    }
                    if (record instanceof SRVRecord) {
                        ServiceRecord svcRecord = ServiceRecord.build((SRVRecord)record);
                        if (svcRecord == null) continue;
                        set.getRecords().add(svcRecord);
                        continue;
                    }
                    if (record instanceof TXTRecord) {
                        set.getTexts().add(TextRecord.build((TXTRecord)record));
                        continue;
                    }
                    ((Map)DnsServicesDiscovery.this.errorsTrace.get()).put(ExceptionsUtil.traceKey(record.toString(), "", "Parsing-Service-Records"), StatusCode.RESOURCE_UNEXPECTED);
                }
            }
        }
    }

    private static enum RrHolderType {
        NAMES,
        ZONES,
        TYPES,
        OTHER;

    }
}

