/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.titan.runtime.core.Changeable_Double;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.Ttcn3Float;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanTimer {
    public static final TitanTimer testcaseTimer = new TitanTimer("<testcase guard timer>");
    private static final ThreadLocal<LinkedList<TitanTimer>> RUNNING_TIMERS = new ThreadLocal<LinkedList<TitanTimer>>(){

        @Override
        protected LinkedList<TitanTimer> initialValue() {
            return new LinkedList<TitanTimer>();
        }
    };
    private static final ThreadLocal<LinkedList<TitanTimer>> BACKUP_TIMERS = new ThreadLocal<LinkedList<TitanTimer>>(){

        @Override
        protected LinkedList<TitanTimer> initialValue() {
            return new LinkedList<TitanTimer>();
        }
    };
    private String timer_name;
    private boolean has_default;
    private boolean is_started;
    private double default_value;
    private double time_started;
    private double time_expires;
    private static boolean control_timer_saved = false;

    protected TitanTimer() {
    }

    TitanTimer operator_assign(TitanTimer otherValue) {
        this.timer_name = otherValue.timer_name;
        this.has_default = otherValue.has_default;
        this.is_started = otherValue.is_started;
        this.default_value = otherValue.default_value;
        this.time_started = otherValue.time_started;
        this.time_expires = otherValue.time_expires;
        return this;
    }

    public TitanTimer operator_assign(Ttcn3Float defaultValue) {
        this.set_default_duration(defaultValue);
        this.is_started = false;
        return this;
    }

    public TitanTimer operator_assign(TitanFloat defaultValue) {
        defaultValue.must_bound("Initializing a timer duration with an unbound float value.");
        this.set_default_duration(defaultValue);
        this.is_started = false;
        return this;
    }

    public TitanTimer(String name) {
        this.timer_name = name == null ? "<unknown>" : name;
        this.has_default = false;
        this.is_started = false;
    }

    public TitanTimer(String name, double defaultValue) {
        if (name == null) {
            throw new TtcnError("Internal Error: Creating a timer with an invalid name.");
        }
        this.timer_name = name;
        this.set_default_duration(defaultValue);
        this.is_started = false;
    }

    public TitanTimer(String name, Ttcn3Float defaultValue) {
        if (name == null) {
            throw new TtcnError("Internal Error: Creating a timer with an invalid name.");
        }
        this.timer_name = name;
        this.set_default_duration(defaultValue);
        this.is_started = false;
    }

    public TitanTimer(String name, TitanFloat defaultValue) {
        if (name == null) {
            throw new TtcnError("Internal Error: Creating a timer with an invalid name.");
        }
        defaultValue.must_bound("Initializing a timer duration with an unbound float value.");
        this.timer_name = name;
        this.set_default_duration(defaultValue);
        this.is_started = false;
    }

    private void add_to_list() {
        LinkedList<TitanTimer> localTimers = RUNNING_TIMERS.get();
        if (localTimers.contains(this)) {
            return;
        }
        int i = 0;
        for (TitanTimer timer : localTimers) {
            if (timer.time_expires > this.time_expires) break;
            ++i;
        }
        localTimers.add(i, this);
    }

    private void remove_from_list() {
        RUNNING_TIMERS.get().remove(this);
    }

    public void set_name(String name) {
        if (name == null) {
            throw new TtcnError("Internal error: Setting an invalid name for a single element of a timer array.");
        }
        this.timer_name = name;
    }

    public final void set_default_duration(double defaultValue) {
        if (defaultValue < 0.0) {
            throw new TtcnError(MessageFormat.format("Setting the default duration of timer {0} to a negative float value ({1}).", this.timer_name, defaultValue));
        }
        if (Double.isInfinite(defaultValue) || Double.isNaN(defaultValue)) {
            throw new TtcnError(MessageFormat.format("Setting the default duration of timer {0} to a non-numeric float value ({1}).", this.timer_name, defaultValue));
        }
        this.has_default = true;
        this.default_value = defaultValue;
    }

    public final void set_default_duration(Ttcn3Float defaultValue) {
        this.set_default_duration(defaultValue.getValue());
    }

    public final void set_default_duration(TitanFloat defaultValue) {
        defaultValue.must_bound(MessageFormat.format("Setting the default duration of timer {0} to an unbound float value.", this.timer_name));
        this.set_default_duration(defaultValue.get_value());
    }

    public void start() {
        if (!this.has_default) {
            throw new TtcnError(MessageFormat.format("Timer {0} does not have default duration. It can only be started with a given duration.", this.timer_name));
        }
        this.start(this.default_value);
    }

    public void start(double startValue) {
        if (this != testcaseTimer) {
            if (startValue < 0.0) {
                throw new TtcnError(MessageFormat.format("Starting timer {0} with a negative duration ({1}).", this.timer_name, startValue));
            }
            if (Double.isNaN(startValue) || Double.isInfinite(startValue)) {
                throw new TtcnError(MessageFormat.format("Starting timer {0} with a non-numeric float value ({1}).", this.timer_name, startValue));
            }
            if (this.is_started) {
                TtcnError.TtcnWarning(MessageFormat.format("Re-starting timer {0}, which is already active (running or expired).", this.timer_name));
                this.remove_from_list();
            } else {
                this.is_started = true;
            }
            TTCN_Logger.log_timer_start(this.timer_name, startValue);
            this.time_started = TTCN_Snapshot.time_now();
            this.time_expires = this.time_started + startValue;
            this.add_to_list();
        } else {
            if (startValue < 0.0) {
                throw new TtcnError(MessageFormat.format("Using a negative duration ({0}) for the guard timer of the test case.", startValue));
            }
            if (Double.isNaN(startValue) || Double.isInfinite(startValue)) {
                throw new TtcnError(MessageFormat.format("Using a non-numeric float value ({0}) for the guard timer of the test case.", startValue));
            }
            this.is_started = true;
            TTCN_Logger.log_timer_guard(startValue);
            this.time_started = TTCN_Snapshot.time_now();
            this.time_expires = this.time_started + startValue;
        }
    }

    public void start(Ttcn3Float startValue) {
        this.start(startValue.getValue());
    }

    public void start(TitanFloat startValue) {
        startValue.must_bound(MessageFormat.format("Starting timer {0} with an unbound float value as duration.", this.timer_name));
        this.start(startValue.get_value());
    }

    public void stop() {
        if (this != testcaseTimer) {
            if (this.is_started) {
                this.is_started = false;
                TTCN_Logger.log_timer_stop(this.timer_name, this.time_expires - this.time_started);
                this.remove_from_list();
            } else {
                TtcnError.TtcnWarning(MessageFormat.format("Stopping inactive timer {0}.", this.timer_name));
            }
        } else {
            this.is_started = false;
        }
    }

    public TitanFloat read() {
        double currentTime;
        double returnValue = this.is_started ? ((currentTime = TTCN_Snapshot.time_now()) >= this.time_expires ? 0.0 : currentTime - this.time_started) : 0.0;
        TTCN_Logger.log_timer_read(this.timer_name, returnValue);
        return new TitanFloat(returnValue);
    }

    public boolean running() {
        return this.running(null);
    }

    public boolean running(Index_Redirect index_redirect) {
        return this.is_started && TTCN_Snapshot.time_now() < this.time_expires;
    }

    public TitanAlt_Status timeout() {
        return this.timeout(null);
    }

    public TitanAlt_Status timeout(Index_Redirect index_redirect) {
        if (this.is_started) {
            if (TTCN_Snapshot.get_alt_begin() < this.time_expires) {
                return TitanAlt_Status.ALT_MAYBE;
            }
            this.is_started = false;
            if (this != testcaseTimer) {
                TTCN_Logger.log_timer_timeout(this.timer_name, this.time_expires - this.time_started);
                this.remove_from_list();
            }
            return TitanAlt_Status.ALT_YES;
        }
        if (this != testcaseTimer) {
            TTCN_Logger.log_matching_timeout(this.timer_name);
        }
        return TitanAlt_Status.ALT_NO;
    }

    public static void all_stop() {
        LinkedList<TitanTimer> localTimers = RUNNING_TIMERS.get();
        while (!localTimers.isEmpty()) {
            localTimers.get(0).stop();
        }
    }

    public static boolean any_running() {
        for (TitanTimer timer : RUNNING_TIMERS.get()) {
            if (!timer.running(null)) continue;
            return true;
        }
        return false;
    }

    public static TitanAlt_Status any_timeout() {
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block4: for (TitanTimer timer : RUNNING_TIMERS.get()) {
            switch (timer.timeout(null)) {
                case ALT_YES: {
                    TTCN_Logger.log_timer_any_timeout();
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block4;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Timer {0} returned unexpected status code while evaluating `any timer.timeout''.", timer.timer_name));
        }
        if (returnValue == TitanAlt_Status.ALT_NO) {
            TTCN_Logger.log_matching_timeout(null);
        }
        return returnValue;
    }

    public static boolean get_min_expiration(Changeable_Double minValue) {
        boolean minFlag = false;
        double altBegin = TTCN_Snapshot.get_alt_begin();
        if (TitanTimer.testcaseTimer.is_started && TitanTimer.testcaseTimer.time_expires > altBegin) {
            minValue.setValue(TitanTimer.testcaseTimer.time_expires);
            minFlag = true;
        }
        for (TitanTimer timer : RUNNING_TIMERS.get()) {
            if (timer.time_expires < altBegin || minFlag && !(timer.time_expires < minValue.getValue())) continue;
            minValue.setValue(timer.time_expires);
            minFlag = true;
            break;
        }
        return minFlag;
    }

    public static void save_control_timers() {
        if (control_timer_saved) {
            throw new TtcnError("Internal error: Control part timers are already saved.");
        }
        LinkedList<TitanTimer> localTimers = RUNNING_TIMERS.get();
        RUNNING_TIMERS.set(BACKUP_TIMERS.get());
        BACKUP_TIMERS.set(localTimers);
        control_timer_saved = true;
    }

    public static void restore_control_timers() {
        if (!control_timer_saved) {
            throw new TtcnError("Internal error: Control part timers are not saved.");
        }
        if (!RUNNING_TIMERS.get().isEmpty()) {
            throw new TtcnError("Internal error: There are active timers. Control part timers cannot be restored.");
        }
        LinkedList<TitanTimer> localBackupTimers = BACKUP_TIMERS.get();
        BACKUP_TIMERS.set(RUNNING_TIMERS.get());
        RUNNING_TIMERS.set(localBackupTimers);
        control_timer_saved = false;
    }

    public void log() {
        TTCN_Logger.log_event("timer: { name: " + this.timer_name + ", default duration: ", new Object[0]);
        if (this.has_default) {
            TTCN_Logger.log_event(this.default_value + " s", new Object[0]);
        } else {
            TTCN_Logger.log_event_str("none");
        }
        TTCN_Logger.log_event_str(", state: ");
        if (this.is_started) {
            double current_time = TTCN_Snapshot.time_now();
            if (current_time < this.time_expires) {
                TTCN_Logger.log_event_str("running");
            } else {
                TTCN_Logger.log_event_str("expired");
            }
            TTCN_Logger.log_event(", actual duration: " + (this.time_expires - this.time_started) + " s,elapsed time: " + (current_time - this.time_started) + " s", new Object[0]);
        } else {
            TTCN_Logger.log_event_str("inactive");
        }
        TTCN_Logger.log_event_str(" }");
    }
}

