/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.mctr;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.cfgparser.CfgAnalyzer;
import org.eclipse.titan.runtime.core.cfgparser.ComponentSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.ExecuteSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.GroupSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.IOUtils;
import org.eclipse.titan.runtime.core.cfgparser.MCSectionHandler;
import org.eclipse.titan.runtime.core.mctr.ConfigData;
import org.eclipse.titan.runtime.core.mctr.MainController;
import org.eclipse.titan.runtime.core.mctr.MainControllerCommand;
import org.eclipse.titan.runtime.core.mctr.Timeval;
import org.eclipse.titan.runtime.core.mctr.UserInterface;

public class Cli
extends UserInterface {
    private final MainControllerCommand[] command_list = new MainControllerCommand[]{new MainControllerCommand("cmtc", " [hostname]", "Create the MTC."), new MainControllerCommand("smtc", " [module_name[[.control]|.testcase_name|.*]", "Start MTC with control part, test case or all test cases."), new MainControllerCommand("stop", null, "Stop test execution."), new MainControllerCommand("pause", " [on|off]", "Set whether to interrupt test execution after each test case."), new MainControllerCommand("continue", null, "Resumes interrupted test execution."), new MainControllerCommand("emtc", null, "Terminate MTC."), new MainControllerCommand("log", " [on|off]", "Enable/disable console logging."), new MainControllerCommand("reconf", " [config_file]", "Reload configuration file."), new MainControllerCommand("help", " <command>", "Display help on command."), new MainControllerCommand("quit", null, "Exit Main Controller."), new MainControllerCommand("exit", null, "Exit Main Controller."), new MainControllerCommand("batch", " <batch_file>", "Run commands from batch file."), new MainControllerCommand("info", null, "Display test configuration information.")};
    private static final int EXIT_FAILURE = 1;
    private static final int EXIT_SUCCESS = 0;
    private static final String PROMPT = "MC2> ";
    public boolean loggingEnabled = true;
    private boolean exitFlag = false;
    private waitStateEnum waitState;
    private final ConfigData mycfg = new ConfigData();
    private int executeListIndex = 0;
    private final ReentrantLock mutex;
    private final Condition wakeup_condition;
    private MainController mainController;
    private File config_file = null;

    public Cli() {
        this.waitState = waitStateEnum.WAIT_NOTHING;
        this.mutex = new ReentrantLock();
        this.wakeup_condition = this.mutex.newCondition();
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    @Override
    public void initialize() {
    }

    @Override
    public int enterLoop(String[] args) {
        if (args.length > 1) {
            Cli.printUsage("mctr");
            return 1;
        }
        Cli.printWelcome();
        if (args.length == 1) {
            int i;
            this.config_file = new File(args[0]);
            if (this.config_file == null) {
                System.out.println("Error was found in the configuration file. Exiting");
                Cli.cleanUp();
                return 1;
            }
            System.out.printf("Using configuration file: %s\n", this.config_file.getName());
            CfgAnalyzer cfgAnalyzer = new CfgAnalyzer();
            boolean config_file_failure = cfgAnalyzer.parse(this.config_file);
            if (config_file_failure) {
                System.out.println("Error was found in the configuration file. Exiting");
                Cli.cleanUp();
                return 1;
            }
            MCSectionHandler mcSectionHandler = cfgAnalyzer.getMcSectionHandler();
            ExecuteSectionHandler executeSectionHandler = cfgAnalyzer.getExecuteSectionHandler();
            ComponentSectionHandler componentSectionHandler = cfgAnalyzer.getComponentSectionHandler();
            GroupSectionHandler groupSectionHandler = cfgAnalyzer.getGroupSectionHandler();
            if (mcSectionHandler.getKillTimer() != null) {
                this.mainController.set_kill_timer(mcSectionHandler.getKillTimer());
            }
            if (mcSectionHandler.getNumHCsText() != null) {
                this.mycfg.setNum_hcs(mcSectionHandler.getNumHCsText());
            }
            this.mycfg.setLocal_addr(mcSectionHandler.getLocalAddress());
            if (this.mycfg.getLocal_addr() == null || this.mycfg.getLocal_addr().isEmpty()) {
                try {
                    this.mycfg.setLocal_addr(InetAddress.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (mcSectionHandler.getTcpPort() != null) {
                this.mycfg.setTcp_listen_port(mcSectionHandler.getTcpPort().intValue());
                if (this.mycfg.getTcp_listen_port() < 0 || this.mycfg.getTcp_listen_port() > 65535) {
                    this.mycfg.setTcp_listen_port(0);
                }
            } else {
                this.mycfg.setTcp_listen_port(0);
            }
            this.mycfg.add_exec(executeSectionHandler.getExecuteitems());
            this.mycfg.add_host(groupSectionHandler.getGroups());
            this.mycfg.add_component(componentSectionHandler.getComponents());
            for (i = 0; i < this.mycfg.getGroup_list().size(); ++i) {
                if (this.mycfg.getGroup_list().get(i).getGroupItems().isEmpty()) {
                    this.mainController.add_host(this.mycfg.getGroup_list().get(i).getGroupName(), null);
                    continue;
                }
                for (int j = 0; j < this.mycfg.getGroup_list().get(i).getGroupItems().size(); ++j) {
                    this.mainController.add_host(this.mycfg.getGroup_list().get(i).getGroupName(), this.mycfg.getGroup_list().get(i).getGroupItems().get(j).getItem());
                }
            }
            for (i = 0; i < this.mycfg.getComponent_list().size(); ++i) {
                this.mainController.assign_component(this.mycfg.getComponent_list().get(i).getHostName(), this.mycfg.getComponent_list().get(i).getComponentName());
            }
        } else {
            try {
                this.mycfg.setLocal_addr(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                System.err.println(e.getMessage());
            }
            this.mycfg.setTcp_listen_port(0);
        }
        int ret_val = 0;
        ret_val = this.mycfg.getNum_hcs().compareTo(BigInteger.ZERO) <= 0 ? this.interactiveMode() : this.batchMode();
        Cli.cleanUp();
        return ret_val;
    }

    @Override
    public void status_change() {
        this.lock();
        try {
            if (this.waitState != waitStateEnum.WAIT_NOTHING && this.conditionHolds(this.waitState)) {
                this.waitState = waitStateEnum.WAIT_NOTHING;
                this.signal();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void error(int severity, String message) {
        System.out.printf("Error: %s\n", message);
        System.out.flush();
    }

    @Override
    public void notify(Timeval timestamp, String source, int severity, String message) {
        if (this.loggingEnabled) {
            switch (this.mycfg.getTsformat()) {
                case TSF_TIME: 
                case TSF_DATE_TIME: {
                    Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
                    if (this.mycfg.getTsformat() == ConfigData.cf_timestamp_format.TSF_TIME) {
                        long tv_timestamp = timestamp.tv_sec * 1000L + timestamp.tv_usec;
                        calendar.setTimeInMillis(tv_timestamp);
                        System.out.printf("%02d:%02d:%02d.%06d %s: %s\n", calendar.get(11), timestamp.tv_usec, calendar.get(13), calendar.get(14), source, message);
                    } else {
                        long tv_timestamp = timestamp.tv_sec * 1000L + timestamp.tv_usec;
                        calendar.setTimeInMillis(tv_timestamp);
                        String[] month_names = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                        System.out.printf("%4d/%s/%02d %02d:%02d:%02d.%06d  %s: %s\n", calendar.get(1), month_names[calendar.get(2)], calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), source, message);
                    }
                    System.out.flush();
                    break;
                }
                case TSF_SEC: {
                    System.out.printf("%d.%06d %s: %s\n", timestamp.tv_sec / 1000L, timestamp.tv_usec % 1000L, source, message);
                    System.out.flush();
                    break;
                }
                default: {
                    System.out.printf("%s: %s\n", source, message);
                    System.out.flush();
                }
            }
        }
    }

    @Override
    public void executeBatchFile(String filename) {
        System.out.printf("Executing batch file '%s'.\n", filename);
        BufferedReader br = null;
        try {
            String currentLine;
            br = new BufferedReader(new FileReader(filename));
            while ((currentLine = br.readLine()) != null) {
                if (currentLine.isEmpty()) continue;
                System.out.printf("%s\n", currentLine);
                this.processCommand(currentLine);
            }
        }
        catch (IOException e) {
            System.out.printf("Error occurred while reading batch file '%s' (error: %s).\n", filename, e.getMessage());
        }
        IOUtils.closeQuietly((Closeable)br);
    }

    private void cmtcCallback(String arguments) {
        int hostIndex;
        if (arguments == null || arguments.isEmpty()) {
            hostIndex = 0;
        } else {
            hostIndex = this.getHostIndex(arguments);
            if (hostIndex < 0) {
                return;
            }
        }
        switch (this.mainController.get_state()) {
            case MC_LISTENING: 
            case MC_LISTENING_CONFIGURED: {
                System.out.println("Waiting for HC to connect...");
                this.waitMCState(waitStateEnum.WAIT_HC_CONNECTED);
            }
            case MC_HC_CONNECTED: {
                this.mainController.configure(ConfigData.getConfigFileContent(this.config_file));
                this.waitMCState(waitStateEnum.WAIT_ACTIVE);
                if (this.mainController.get_state() != MainController.mcStateEnum.MC_ACTIVE) {
                    System.out.println("Error during initialization. Cannot create MTC.");
                    break;
                }
            }
            case MC_ACTIVE: {
                this.mainController.create_mtc(this.mainController.get_hosts().get(hostIndex));
                this.waitMCState(waitStateEnum.WAIT_MTC_CREATED);
                break;
            }
            default: {
                System.out.println("MTC already exists.");
            }
        }
    }

    private void smtcCallback(String arguments) {
        switch (this.mainController.get_state()) {
            case MC_LISTENING: 
            case MC_LISTENING_CONFIGURED: 
            case MC_HC_CONNECTED: 
            case MC_ACTIVE: {
                System.out.println("MTC does not exist.");
                break;
            }
            case MC_READY: {
                if (arguments == null || arguments.isEmpty()) {
                    if (this.mycfg.getExecuteItems().size() > 0) {
                        System.out.println("Executing all items of [EXECUTE] section.");
                        this.waitState = waitStateEnum.WAIT_EXECUTE_LIST;
                        this.executeListIndex = 0;
                        this.executeFromList(0);
                        break;
                    }
                    System.out.println("No [EXECUTE] section was given in the configuration file.");
                    break;
                }
                int doti = 0;
                int alen = arguments.length();
                int state = 0;
                block8: for (int i = 0; i < alen; ++i) {
                    switch (arguments.charAt(i)) {
                        case '.': {
                            ++state;
                            doti = i;
                            continue block8;
                        }
                        case '\t': 
                        case ' ': {
                            state = 3;
                        }
                    }
                }
                if (state > 1) {
                    System.out.println("Incorrect argument format.");
                    this.helpCallback("smtc");
                    break;
                }
                if (state == 0) {
                    this.mainController.execute_control(arguments);
                    break;
                }
                String testcaseName = arguments.substring(doti);
                String moduleName = arguments.substring(0, doti);
                if (!arguments.contains("*")) {
                    this.mainController.execute_testcase(arguments, null);
                    break;
                }
                if (arguments.contains("control")) {
                    this.mainController.execute_control(arguments);
                    break;
                }
                this.mainController.execute_testcase(moduleName, testcaseName);
                break;
            }
            default: {
                System.out.println("MTC is busy.");
            }
        }
    }

    private void stopCallback(String arguments) {
        block5: {
            block4: {
                if (arguments != null && !arguments.isEmpty()) break block4;
                switch (this.mainController.get_state()) {
                    case MC_TERMINATING_TESTCASE: 
                    case MC_EXECUTING_CONTROL: 
                    case MC_EXECUTING_TESTCASE: 
                    case MC_PAUSED: {
                        this.mainController.stop_execution();
                        if (this.waitState == waitStateEnum.WAIT_EXECUTE_LIST) {
                            this.waitState = waitStateEnum.WAIT_NOTHING;
                            break;
                        }
                        break block5;
                    }
                    default: {
                        System.out.println("Tests are not running.");
                        break;
                    }
                }
                break block5;
            }
            this.helpCallback("stop");
        }
    }

    private void pauseCallback(String arguments) {
        if (arguments != null && !arguments.isEmpty()) {
            if (arguments.equals("on")) {
                if (!this.mainController.get_stop_after_testcase()) {
                    this.mainController.stop_after_testcase(true);
                    System.out.println("Pause function is enabled. Execution will stop at the end of each testcase.");
                } else {
                    System.out.println("Pause function is already enabled.");
                }
            } else if (arguments.equals("off")) {
                if (this.mainController.get_stop_after_testcase()) {
                    this.mainController.stop_after_testcase(false);
                    System.out.println("Pause function is disabled. Execution will continue at the end of each testcase.");
                } else {
                    System.out.println("Pause function is already disabled.");
                }
            } else {
                this.helpCallback("pause");
            }
        } else {
            System.out.printf("Pause function is %s.\n", this.mainController.get_stop_after_testcase() ? "enabled" : "disabled");
        }
    }

    private void continueCallback(String arguments) {
        if (arguments == null || arguments.isEmpty()) {
            switch (this.mainController.get_state()) {
                case MC_TERMINATING_TESTCASE: 
                case MC_EXECUTING_CONTROL: 
                case MC_EXECUTING_TESTCASE: {
                    System.out.println("Execution is not paused.");
                    break;
                }
                case MC_PAUSED: {
                    this.mainController.continue_testcase();
                    break;
                }
                default: {
                    System.out.println("Tests are not running.");
                    break;
                }
            }
        } else {
            this.helpCallback("continue");
        }
    }

    private void emtcCallback(String arguments) {
        if (arguments == null || arguments.isEmpty()) {
            switch (this.mainController.get_state()) {
                case MC_LISTENING: 
                case MC_LISTENING_CONFIGURED: 
                case MC_HC_CONNECTED: 
                case MC_ACTIVE: {
                    System.out.println("MTC does not exist.");
                    break;
                }
                case MC_READY: {
                    this.mainController.exit_mtc();
                    this.waitMCState(waitStateEnum.WAIT_MTC_TERMINATED);
                    break;
                }
                default: {
                    System.out.println("MTC cannot be terminated.");
                    break;
                }
            }
        } else {
            this.helpCallback("emtc");
        }
    }

    private void logCallback(String arguments) {
        if (arguments != null && !arguments.isEmpty()) {
            if (arguments.equals("on")) {
                this.loggingEnabled = true;
                System.out.println("Console logging is enabled.");
            } else if (arguments.equals("off")) {
                this.loggingEnabled = false;
                System.out.println("Console logging is disabled.");
            } else {
                this.helpCallback("log");
            }
        } else {
            System.out.printf("Console logging is %s.\n", this.loggingEnabled ? "enabled" : "disabled");
        }
    }

    private void infoCallback(String arguments) {
        if (arguments == null || arguments.isEmpty()) {
            this.printInfo();
        } else {
            this.helpCallback("info");
        }
    }

    private void reconfCallback(String arguments) {
        if (!this.mainController.start_reconfiguring()) {
            return;
        }
        if (arguments != null && !arguments.isEmpty()) {
            this.config_file = new File(arguments);
        } else {
            System.err.println("Error was found in the configuration file. Exiting.");
            Cli.cleanUp();
            this.exitCallback("");
        }
        System.out.printf("Using configuration file: %s\n", this.config_file.getName());
        CfgAnalyzer cfgAnalyzer = new CfgAnalyzer();
        boolean config_file_failure = cfgAnalyzer.parse(this.config_file);
        if (config_file_failure) {
            System.out.println("Error was found in the configuration file. Exiting");
            Cli.cleanUp();
            this.exitCallback("");
        } else {
            int i;
            MCSectionHandler mcSectionHandler = cfgAnalyzer.getMcSectionHandler();
            ComponentSectionHandler componentSectionHandler = cfgAnalyzer.getComponentSectionHandler();
            GroupSectionHandler groupSectionHandler = cfgAnalyzer.getGroupSectionHandler();
            if (mcSectionHandler.getKillTimer() != null) {
                this.mycfg.setKill_timer(mcSectionHandler.getKillTimer());
                this.mainController.set_kill_timer(mcSectionHandler.getKillTimer());
            }
            this.mycfg.add_host(groupSectionHandler.getGroups());
            this.mycfg.add_component(componentSectionHandler.getComponents());
            for (i = 0; i < this.mycfg.getGroup_list().size(); ++i) {
                if (this.mycfg.getGroup_list().get(i).getGroupItems().isEmpty()) {
                    this.mainController.add_host(this.mycfg.getGroup_list().get(i).getGroupName(), null);
                    continue;
                }
                for (int j = 0; j < this.mycfg.getGroup_list().get(i).getGroupItems().size(); ++j) {
                    this.mainController.add_host(this.mycfg.getGroup_list().get(i).getGroupName(), this.mycfg.getGroup_list().get(i).getGroupItems().get(j).getItem());
                }
            }
            for (i = 0; i < this.mycfg.getComponent_list().size(); ++i) {
                this.mainController.assign_component(this.mycfg.getComponent_list().get(i).getHostName(), this.mycfg.getComponent_list().get(i).getComponentName());
            }
            if (this.mainController.get_state() == MainController.mcStateEnum.MC_RECONFIGURING) {
                this.mainController.configure(ConfigData.getConfigFileContent(this.config_file));
            }
        }
    }

    private void helpCallback(String arguments) {
        if (arguments == null || arguments.isEmpty()) {
            System.out.println("Help is available for the following commands:");
            for (MainControllerCommand command : this.command_list) {
                System.out.print(command.getName() + " ");
            }
            System.out.println();
        } else {
            for (MainControllerCommand command : this.command_list) {
                if (!arguments.equals(command.getName())) continue;
                System.out.printf("%s usage: %s\n%s\n", command.getName(), command.getSynopsis(), command.getDescription());
                return;
            }
            System.out.printf("No help for %s.\n", arguments);
        }
    }

    private void shellCallback(String arguments) {
    }

    private void exitCallback(String arguments) {
        if (arguments == null || arguments.isEmpty()) {
            switch (this.mainController.get_state()) {
                case MC_READY: 
                case MC_RECONFIGURING: {
                    this.mainController.exit_mtc();
                    this.waitMCState(waitStateEnum.WAIT_MTC_TERMINATED);
                    break;
                }
                case MC_LISTENING: 
                case MC_LISTENING_CONFIGURED: 
                case MC_HC_CONNECTED: 
                case MC_ACTIVE: {
                    this.mainController.shutdown_session();
                    this.waitMCState(waitStateEnum.WAIT_SHUTDOWN_COMPLETE);
                    this.exitFlag = true;
                    break;
                }
                default: {
                    System.out.println("Cannot exit until execution is finished.");
                    break;
                }
            }
        } else {
            this.helpCallback("quit");
        }
    }

    private static void cleanUp() {
    }

    private static void printWelcome() {
        System.out.printf("\n*************************************************************************\n* TTCN-3 Test Executor - Main Controller 2                              *\n* Version: %-40s                     *\n* Copyright (c) 2000-2024 Ericsson Telecom AB                           *\n* All rights reserved. This program and the accompanying materials      *\n* are made available under the terms of the Eclipse Public License v2.0 *\n* which accompanies this distribution, and is available at              *\n* https://www.eclipse.org/org/documents/epl-2.0/EPL-2.0.html            *\n*************************************************************************\n\n", "11.0.0");
    }

    private static void printUsage(String prg_name) {
        System.err.printf("TTCN-3 Test Executor - Main Controller 2\nVersion: 11.0.0\n\nusage: %s configuration_file\nwhere: the 'configuration_file' parameter specifies the name and \nlocation of the main controller configuration file\n", prg_name);
    }

    private int interactiveMode() {
        if (this.mainController.start_session(this.mycfg.getLocal_addr(), this.mycfg.getTcp_listen_port()) == 0) {
            System.out.println("Initialization of TCP server failed. Exiting.");
            return 1;
        }
        BufferedReader console_reader = new BufferedReader(new InputStreamReader(System.in));
        do {
            try {
                System.out.print(PROMPT);
                String line_read = console_reader.readLine();
                if (line_read != null) {
                    this.processCommand(line_read.trim());
                    continue;
                }
                System.out.println("exit");
                this.exitCallback("");
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } while (!this.exitFlag);
        return 0;
    }

    private int batchMode() {
        System.out.println(String.format("Entering batch mode. Waiting for %d HC%s to connect...", this.mycfg.getNum_hcs(), this.mycfg.getNum_hcs().compareTo(BigInteger.ONE) > 0 ? "s" : ""));
        if (this.mycfg.getExecuteItems() == null || this.mycfg.getExecuteItems().isEmpty()) {
            System.out.println("No [EXECUTE] section was given in the configuration file. Exiting.");
            return 1;
        }
        boolean error_flag = false;
        if (this.mainController.start_session(this.mycfg.getLocal_addr(), this.mycfg.getTcp_listen_port()) == 0) {
            System.out.println("Initialization of TCP server failed. Exiting.");
            return 1;
        }
        this.waitMCState(waitStateEnum.WAIT_HC_CONNECTED);
        this.mainController.configure(ConfigData.getConfigFileContent(this.config_file));
        this.waitMCState(waitStateEnum.WAIT_ACTIVE);
        if (this.mainController.get_state() != MainController.mcStateEnum.MC_ACTIVE) {
            System.out.println((Object)this.mainController.get_state());
            System.out.println("Error during initialization. Cannot continue in batch mode.");
            error_flag = true;
        }
        if (!error_flag) {
            this.mainController.create_mtc(this.mainController.get_hosts().get(0));
            this.waitMCState(waitStateEnum.WAIT_MTC_CREATED);
            if (this.mainController.get_state() != MainController.mcStateEnum.MC_READY) {
                System.out.println("Creation of MTC failed. Cannot continue in batch mode.");
                error_flag = true;
            }
        }
        if (!error_flag) {
            for (int i = 0; i < this.mycfg.getExecuteItems().size(); ++i) {
                this.executeFromList(i);
                this.waitMCState(waitStateEnum.WAIT_MTC_READY);
                if (this.mainController.get_state() == MainController.mcStateEnum.MC_READY) continue;
                System.out.println("MTC terminated unexpectedly. Cannot continue in batch mode.");
                error_flag = true;
                break;
            }
        }
        if (!error_flag) {
            this.mainController.exit_mtc();
            this.waitMCState(waitStateEnum.WAIT_MTC_TERMINATED);
        }
        this.mainController.shutdown_session();
        this.waitMCState(waitStateEnum.WAIT_SHUTDOWN_COMPLETE);
        if (error_flag) {
            return 1;
        }
        return 0;
    }

    private boolean conditionHolds(waitStateEnum askedState) {
        switch (askedState) {
            case WAIT_HC_CONNECTED: {
                if (this.mainController.get_state() == MainController.mcStateEnum.MC_HC_CONNECTED) {
                    if (this.mycfg.getNum_hcs().compareTo(BigInteger.ZERO) == 1) {
                        return this.mainController.get_nof_hosts() == this.mycfg.getNum_hcs().intValue() || this.mainController.get_nof_hosts() > this.mycfg.getNum_hcs().intValue();
                    }
                    return true;
                }
                return false;
            }
            case WAIT_ACTIVE: {
                switch (this.mainController.get_state()) {
                    case MC_LISTENING: 
                    case MC_HC_CONNECTED: 
                    case MC_ACTIVE: {
                        return true;
                    }
                }
                return false;
            }
            case WAIT_MTC_CREATED: 
            case WAIT_MTC_READY: {
                switch (this.mainController.get_state()) {
                    case MC_LISTENING_CONFIGURED: 
                    case MC_HC_CONNECTED: 
                    case MC_ACTIVE: 
                    case MC_READY: {
                        return true;
                    }
                }
                return false;
            }
            case WAIT_MTC_TERMINATED: {
                return this.mainController.get_state() == MainController.mcStateEnum.MC_ACTIVE;
            }
            case WAIT_SHUTDOWN_COMPLETE: {
                return this.mainController.get_state() == MainController.mcStateEnum.MC_INACTIVE;
            }
            case WAIT_EXECUTE_LIST: {
                if (this.mainController.get_state() == MainController.mcStateEnum.MC_READY) {
                    ++this.executeListIndex;
                    if (this.executeListIndex < this.mycfg.getExecuteItems().size()) {
                        this.executeFromList(this.executeListIndex);
                    } else {
                        System.out.println("Execution of [EXECUTE] section finished.");
                        this.waitState = waitStateEnum.WAIT_NOTHING;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private void waitMCState(waitStateEnum newWaitState) {
        this.lock();
        if (newWaitState != waitStateEnum.WAIT_NOTHING) {
            if (this.conditionHolds(newWaitState)) {
                this.waitState = waitStateEnum.WAIT_NOTHING;
            } else {
                this.waitState = newWaitState;
                this.await();
            }
        } else {
            System.err.println("Cli.waitMCState: invalid argument");
            this.unlock();
            return;
        }
        this.unlock();
    }

    private int getHostIndex(String hostname) {
        int found = -1;
        for (int i = 0; i < this.mainController.get_nof_hosts(); ++i) {
            MainController.Host host = this.mainController.get_host_data(i);
            if (host != null) {
                if (!host.hostname.equals(hostname) || !host.hostname_local.equals(hostname)) {
                    this.mainController.release_data();
                    if (found == -1) {
                        found = i;
                        continue;
                    }
                    System.out.printf("Hostname %s is ambiguous.\n", hostname);
                    found = -1;
                    break;
                }
                this.mainController.release_data();
                continue;
            }
            this.mainController.release_data();
            if (found != -1) break;
            System.out.printf("No such host: %s.\n", hostname);
            break;
        }
        return found;
    }

    private void lock() {
        this.mutex.lock();
    }

    private void unlock() {
        this.mutex.unlock();
    }

    private void signal() {
        this.wakeup_condition.signal();
    }

    private void await() {
        try {
            this.wakeup_condition.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void processCommand(String line_read) {
        if (line_read == null || line_read.isEmpty()) {
            return;
        }
        String[] splitted_line = line_read.split("\\s");
        String command = splitted_line[0];
        String argument = null;
        if (splitted_line.length == 2) {
            argument = splitted_line[1];
        }
        if (command.equals("cmtc")) {
            this.cmtcCallback(argument);
        } else if (command.equals("smtc")) {
            this.smtcCallback(argument);
        } else if (command.equals("stop")) {
            this.stopCallback(argument);
        } else if (command.equals("pause")) {
            this.pauseCallback(argument);
        } else if (command.equals("continue")) {
            this.continueCallback(argument);
        } else if (command.equals("emtc")) {
            this.emtcCallback(argument);
        } else if (command.equals("log")) {
            this.logCallback(argument);
        } else if (command.equals("reconf")) {
            this.reconfCallback(argument);
        } else if (command.equals("help")) {
            this.helpCallback(argument);
        } else if (command.equals("!")) {
            this.shellCallback(argument);
        } else if (command.equals("quit") || command.equals("exit")) {
            this.exitCallback(argument);
        } else if (command.equals("batch")) {
            this.executeBatchFile(argument);
        } else if (command.equals("info")) {
            this.infoCallback(argument);
        }
    }

    private void executeFromList(int index) {
        if (index >= this.mycfg.getExecuteItems().size()) {
            System.err.println("Cli.executeFromList: invalid argument");
            return;
        }
        if (this.mycfg.getExecuteItems().get(index).getTestcaseName() == null) {
            this.mainController.execute_control(this.mycfg.getExecuteItems().get(index).getModuleName());
        } else if (!this.mycfg.getExecuteItems().get(index).getTestcaseName().equals("*")) {
            this.mainController.execute_testcase(this.mycfg.getExecuteItems().get(index).getModuleName(), null);
        } else {
            this.mainController.execute_testcase(this.mycfg.getExecuteItems().get(index).getModuleName(), this.mycfg.getExecuteItems().get(index).getTestcaseName());
        }
    }

    private String verdict2str(TitanVerdictType.VerdictTypeEnum verdict) {
        switch (verdict) {
            case NONE: {
                return "none";
            }
            case PASS: {
                return "pass";
            }
            case INCONC: {
                return "inconc";
            }
            case FAIL: {
                return "fail";
            }
            case ERROR: {
                return "error";
            }
        }
        return "unknown";
    }

    private void printInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MC information:\n");
        buffer.append(String.format(" MC state: %s\n", MainController.get_mc_state_name(this.mainController.get_state())));
        buffer.append(" host information:\n");
        for (int i = 0; i < this.mainController.get_nof_hosts(); ++i) {
            MainController.Host host = this.mainController.get_host_data(i);
            if (host != null) {
                buffer.append(String.format("  - %s", host.hostname));
                String ip_addr = host.ip_address.getHostAddress();
                if (!ip_addr.equals(host.hostname)) {
                    buffer.append(String.format(" [%s]", ip_addr));
                }
                if (!host.hostname.equals(host.hostname_local)) {
                    buffer.append(String.format(" (%s)", host.hostname_local));
                }
                buffer.append(":\n");
                buffer.append(String.format("     operating system: %s %s on %s\n", host.system_name, host.system_release, host.machine_type));
                buffer.append(String.format("     HC state: %s\n", MainController.get_hc_state_name(host.hc_state)));
                buffer.append("     test component information:\n");
                int n_components = host.components.size();
                this.mainController.release_data();
                for (int j = 0; j < n_components; ++j) {
                    MainController.ComponentStruct component = this.mainController.get_component_data(host.components.get(j));
                    if (component == null) continue;
                    if (component.comp_name != null) {
                        buffer.append(String.format("      - name: %s, component reference: %d\n", component.comp_name, component.comp_ref));
                    } else {
                        buffer.append(String.format("      - component reference: %d\n", component.comp_ref));
                    }
                    if (component.comp_type != null && component.comp_type.definition_name != null) {
                        buffer.append("         component type: ");
                        if (component.comp_type.module_name != null) {
                            buffer.append(String.format("%s.", component.comp_type.module_name));
                        }
                        buffer.append(String.format("%s\n", component.comp_type.definition_name));
                    }
                    buffer.append(String.format("         state: %s\n", MainController.get_tc_state_name(component.tc_state)));
                    if (component.tc_fn_name != null && component.tc_fn_name.definition_name != null) {
                        buffer.append(String.format("         executed %s: ", component.comp_ref == 1 ? "test case" : "function"));
                        if (component.tc_fn_name.module_name != null) {
                            buffer.append(String.format("%s.", component.tc_fn_name.module_name));
                        }
                        buffer.append(String.format("%s\n", component.tc_fn_name.definition_name));
                    }
                    if (component.tc_state == MainController.tc_state_enum.TC_EXITING || component.tc_state == MainController.tc_state_enum.TC_EXITED) {
                        buffer.append(String.format("         local verdict: %s\n", this.verdict2str(component.local_verdict)));
                    }
                    this.mainController.release_data();
                }
                if (n_components != 0) continue;
                buffer.append("      no components on this host\n");
                continue;
            }
            this.mainController.release_data();
            break;
        }
        if (this.mainController.get_nof_hosts() == 0) {
            buffer.append("  no HCs are connected\n");
        }
        buffer.append(String.format(" pause function: %s\n", this.mainController.get_stop_after_testcase() ? "enabled" : "disabled"));
        buffer.append(String.format(" console logging: %s\n", this.loggingEnabled ? "enabled" : "disabled"));
        System.out.println(buffer.toString());
    }

    public static enum waitStateEnum {
        WAIT_NOTHING,
        WAIT_HC_CONNECTED,
        WAIT_ACTIVE,
        WAIT_MTC_CREATED,
        WAIT_MTC_READY,
        WAIT_MTC_TERMINATED,
        WAIT_SHUTDOWN_COMPLETE,
        WAIT_EXECUTE_LIST;

    }
}

