/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg.indices;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.common.parsers.cfg.indices.ConfigSectionHandlerBase;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingBit;

public final class LoggingSectionHandler
extends ConfigSectionHandlerBase {
    private Map<String, LoggerPluginsEntry> loggerPluginsTree = new HashMap<String, LoggerPluginsEntry>();
    private final Map<String, HashMap<String, LogParamEntry>> loggerTree = new HashMap<String, HashMap<String, LogParamEntry>>();

    public Set<String> getComponents() {
        return this.loggerTree.keySet();
    }

    public Set<String> getPlugins(String componentName) {
        Map pluginsMap = this.loggerTree.get(componentName);
        if (pluginsMap == null) {
            return new HashSet<String>();
        }
        return pluginsMap.keySet();
    }

    public LogParamEntry componentPlugin(String componentName, String pluginName) {
        Map pluginMap;
        String tempComponentName = componentName;
        if (componentName == null) {
            tempComponentName = "*";
        }
        String tempPluginName = pluginName;
        if (pluginName == null) {
            tempPluginName = "*";
        }
        if (!this.loggerTree.containsKey(tempComponentName)) {
            this.loggerTree.put(tempComponentName, new HashMap());
        }
        if (!(pluginMap = (Map)this.loggerTree.get(tempComponentName)).containsKey(tempPluginName)) {
            pluginMap.put(tempPluginName, new LogParamEntry());
        }
        return (LogParamEntry)pluginMap.get(tempPluginName);
    }

    public void removeTreeElement(LoggerTreeElement lte) {
        if (lte.pluginName == null) {
            this.loggerTree.remove(lte.componentName);
        } else {
            this.loggerTree.get(lte.componentName).remove(lte.pluginName);
        }
    }

    public Object[] getComponentsTreeElementArray() {
        ArrayList<LoggerTreeElement> rv = new ArrayList<LoggerTreeElement>();
        for (String s : this.loggerTree.keySet()) {
            rv.add(new LoggerTreeElement(this, s));
        }
        return rv.toArray();
    }

    public Object[] getPluginsTreeElementArray(String componentName) {
        Map pluginsMap = this.loggerTree.get(componentName);
        if (pluginsMap == null) {
            return new Object[0];
        }
        ArrayList<LoggerTreeElement> rv = new ArrayList<LoggerTreeElement>();
        for (String s : pluginsMap.keySet()) {
            rv.add(new LoggerTreeElement(this, componentName, s));
        }
        return rv.toArray();
    }

    public Map<String, LoggerPluginsEntry> getLoggerPluginsTree() {
        return this.loggerPluginsTree;
    }

    public void setLoggerPluginsTree(Map<String, LoggerPluginsEntry> loggerPluginsTree) {
        this.loggerPluginsTree = loggerPluginsTree;
    }

    public static class LoggerTreeElement {
        private LoggingSectionHandler lsh = null;
        private String componentName = null;
        private String pluginName = null;

        public LoggerTreeElement(LoggingSectionHandler lsh, String componentName, String pluginName) {
            this.lsh = lsh;
            this.componentName = componentName;
            this.pluginName = pluginName;
        }

        public LoggerTreeElement(LoggingSectionHandler lsh, String componentName) {
            this.lsh = lsh;
            this.componentName = componentName;
            this.pluginName = null;
        }

        public void writeNamePrefix(StringBuilder name) {
            name.append(this.componentName).append('.');
            if (this.pluginName != null) {
                name.append(this.pluginName).append('.');
            }
        }

        public LoggingSectionHandler getLsh() {
            return this.lsh;
        }

        public void setLsh(LoggingSectionHandler lsh) {
            this.lsh = lsh;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }
    }

    public static class LoggerPluginsEntry {
        private ParseTree loggerPluginsRoot = null;
        private ParseTree loggerPluginsListRoot = null;
        private Map<String, LoggerPluginEntry> pluginRoots = null;

        public ParseTree getLoggerPluginsRoot() {
            return this.loggerPluginsRoot;
        }

        public void setLoggerPluginsRoot(ParseTree loggerPluginsRoot) {
            this.loggerPluginsRoot = loggerPluginsRoot;
        }

        public ParseTree getLoggerPluginsListRoot() {
            return this.loggerPluginsListRoot;
        }

        public void setLoggerPluginsListRoot(ParseTree loggerPluginsListRoot) {
            this.loggerPluginsListRoot = loggerPluginsListRoot;
        }

        public Map<String, LoggerPluginEntry> getPluginRoots() {
            return this.pluginRoots;
        }

        public void setPluginRoots(Map<String, LoggerPluginEntry> pluginRoots) {
            this.pluginRoots = pluginRoots;
        }
    }

    public static class LoggerPluginEntry {
        private ParseTree loggerPluginRoot = null;
        private String name = null;
        private String path = null;

        public ParseTree getLoggerPluginRoot() {
            return this.loggerPluginRoot;
        }

        public void setLoggerPluginRoot(ParseTree loggerPluginRoot) {
            this.loggerPluginRoot = loggerPluginRoot;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class LogParamEntry {
        private ParseTree logFile = null;
        private ParseTree logFileRoot = null;
        private ParseTree appendFile = null;
        private ParseTree appendFileRoot = null;
        private ParseTree timestampFormat = null;
        private ParseTree timestampFormatRoot = null;
        private ParseTree consoleTimestampFormat = null;
        private ParseTree consoleTimestampFormatRoot = null;
        private ParseTree logeventTypes = null;
        private ParseTree logeventTypesRoot = null;
        private ParseTree sourceInfoFormat = null;
        private ParseTree sourceInfoFormatRoot = null;
        private ParseTree logEntityName = null;
        private ParseTree logEntityNameRoot = null;
        private ParseTree matchingHints = null;
        private ParseTree matchingHintsRoot = null;
        private ParseTree logfileNumber = null;
        private ParseTree logfileNumberRoot = null;
        private ParseTree logfileSize = null;
        private ParseTree logfileSizeRoot = null;
        private ParseTree diskFullAction = null;
        private ParseTree diskFullActionRoot = null;
        private Map<LoggingBit, ParseTree> fileMaskBits = new EnumMap<LoggingBit, ParseTree>(LoggingBit.class);
        private ParseTree fileMask = null;
        private ParseTree fileMaskRoot = null;
        private Map<LoggingBit, ParseTree> consoleMaskBits = new EnumMap<LoggingBit, ParseTree>(LoggingBit.class);
        private ParseTree consoleMask = null;
        private ParseTree consoleMaskRoot = null;
        private List<PluginSpecificParam> pluginSpecificParam = new ArrayList<PluginSpecificParam>();
        private String pluginPath = null;
        private ParseTree emergencyLogging = null;
        private ParseTree emergencyLoggingBehaviour = null;
        private ParseTree emergencyLoggingMask = null;
        private ParseTree emergencyLoggingForFailVerdict = null;

        public ParseTree getLogFile() {
            return this.logFile;
        }

        public void setLogFile(ParseTree logFile) {
            this.logFile = logFile;
        }

        public ParseTree getLogFileRoot() {
            return this.logFileRoot;
        }

        public void setLogFileRoot(ParseTree logFileRoot) {
            this.logFileRoot = logFileRoot;
        }

        public ParseTree getAppendFile() {
            return this.appendFile;
        }

        public void setAppendFile(ParseTree appendFile) {
            this.appendFile = appendFile;
        }

        public ParseTree getAppendFileRoot() {
            return this.appendFileRoot;
        }

        public void setAppendFileRoot(ParseTree appendFileRoot) {
            this.appendFileRoot = appendFileRoot;
        }

        public ParseTree getTimestampFormat() {
            return this.timestampFormat;
        }

        public void setTimestampFormat(ParseTree timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        public ParseTree getTimestampFormatRoot() {
            return this.timestampFormatRoot;
        }

        public void setTimestampFormatRoot(ParseTree timestampFormatRoot) {
            this.timestampFormatRoot = timestampFormatRoot;
        }

        public ParseTree getConsoleTimestampFormat() {
            return this.consoleTimestampFormat;
        }

        public void setConsoleTimestampFormat(ParseTree timestampFormat) {
            this.consoleTimestampFormat = timestampFormat;
        }

        public ParseTree getConsoleTimestampFormatRoot() {
            return this.consoleTimestampFormatRoot;
        }

        public void setConsoleTimestampFormatRoot(ParseTree timestampFormatRoot) {
            this.consoleTimestampFormatRoot = timestampFormatRoot;
        }

        public ParseTree getLogeventTypes() {
            return this.logeventTypes;
        }

        public void setLogeventTypes(ParseTree logeventTypes) {
            this.logeventTypes = logeventTypes;
        }

        public ParseTree getLogeventTypesRoot() {
            return this.logeventTypesRoot;
        }

        public void setLogeventTypesRoot(ParseTree logeventTypesRoot) {
            this.logeventTypesRoot = logeventTypesRoot;
        }

        public ParseTree getSourceInfoFormat() {
            return this.sourceInfoFormat;
        }

        public void setSourceInfoFormat(ParseTree sourceInfoFormat) {
            this.sourceInfoFormat = sourceInfoFormat;
        }

        public ParseTree getSourceInfoFormatRoot() {
            return this.sourceInfoFormatRoot;
        }

        public void setSourceInfoFormatRoot(ParseTree sourceInfoFormatRoot) {
            this.sourceInfoFormatRoot = sourceInfoFormatRoot;
        }

        public ParseTree getLogEntityName() {
            return this.logEntityName;
        }

        public void setLogEntityName(ParseTree logEntityName) {
            this.logEntityName = logEntityName;
        }

        public ParseTree getLogEntityNameRoot() {
            return this.logEntityNameRoot;
        }

        public void setLogEntityNameRoot(ParseTree logEntityNameRoot) {
            this.logEntityNameRoot = logEntityNameRoot;
        }

        public ParseTree getMatchingHints() {
            return this.matchingHints;
        }

        public void setMatchingHints(ParseTree matchingHints) {
            this.matchingHints = matchingHints;
        }

        public ParseTree getMatchingHintsRoot() {
            return this.matchingHintsRoot;
        }

        public void setMatchingHintsRoot(ParseTree matchingHintsRoot) {
            this.matchingHintsRoot = matchingHintsRoot;
        }

        public ParseTree getLogfileNumber() {
            return this.logfileNumber;
        }

        public void setLogfileNumber(ParseTree logfileNumber) {
            this.logfileNumber = logfileNumber;
        }

        public ParseTree getLogfileNumberRoot() {
            return this.logfileNumberRoot;
        }

        public void setLogfileNumberRoot(ParseTree logfileNumberRoot) {
            this.logfileNumberRoot = logfileNumberRoot;
        }

        public ParseTree getLogfileSize() {
            return this.logfileSize;
        }

        public void setLogfileSize(ParseTree logfileSize) {
            this.logfileSize = logfileSize;
        }

        public ParseTree getLogfileSizeRoot() {
            return this.logfileSizeRoot;
        }

        public void setLogfileSizeRoot(ParseTree logfileSizeRoot) {
            this.logfileSizeRoot = logfileSizeRoot;
        }

        public ParseTree getDiskFullAction() {
            return this.diskFullAction;
        }

        public void setDiskFullAction(ParseTree diskFullAction) {
            this.diskFullAction = diskFullAction;
        }

        public ParseTree getDiskFullActionRoot() {
            return this.diskFullActionRoot;
        }

        public void setDiskFullActionRoot(ParseTree diskFullActionRoot) {
            this.diskFullActionRoot = diskFullActionRoot;
        }

        public Map<LoggingBit, ParseTree> getFileMaskBits() {
            return this.fileMaskBits;
        }

        public void setFileMaskBits(Map<LoggingBit, ParseTree> fileMaskBits) {
            this.fileMaskBits = fileMaskBits;
        }

        public ParseTree getFileMask() {
            return this.fileMask;
        }

        public void setFileMask(ParseTree fileMask) {
            this.fileMask = fileMask;
        }

        public ParseTree getFileMaskRoot() {
            return this.fileMaskRoot;
        }

        public void setFileMaskRoot(ParseTree fileMaskRoot) {
            this.fileMaskRoot = fileMaskRoot;
        }

        public Map<LoggingBit, ParseTree> getConsoleMaskBits() {
            return this.consoleMaskBits;
        }

        public void setConsoleMaskBits(Map<LoggingBit, ParseTree> consoleMaskBits) {
            this.consoleMaskBits = consoleMaskBits;
        }

        public ParseTree getConsoleMask() {
            return this.consoleMask;
        }

        public void setConsoleMask(ParseTree consoleMask) {
            this.consoleMask = consoleMask;
        }

        public ParseTree getConsoleMaskRoot() {
            return this.consoleMaskRoot;
        }

        public void setConsoleMaskRoot(ParseTree consoleMaskRoot) {
            this.consoleMaskRoot = consoleMaskRoot;
        }

        public List<PluginSpecificParam> getPluginSpecificParam() {
            return this.pluginSpecificParam;
        }

        public void setPluginSpecificParam(List<PluginSpecificParam> pluginSpecificParam) {
            this.pluginSpecificParam = pluginSpecificParam;
        }

        public String getPluginPath() {
            return this.pluginPath;
        }

        public void setPluginPath(String pluginPath) {
            this.pluginPath = pluginPath;
        }

        public ParseTree getEmergencyLogging() {
            return this.emergencyLogging;
        }

        public void setEmergencyLogging(ParseTree emergencyLogging) {
            this.emergencyLogging = emergencyLogging;
        }

        public ParseTree getEmergencyLoggingBehaviour() {
            return this.emergencyLoggingBehaviour;
        }

        public void setEmergencyLoggingBehaviour(ParseTree emergencyLoggingBehaviour) {
            this.emergencyLoggingBehaviour = emergencyLoggingBehaviour;
        }

        public ParseTree getEmergencyLoggingMask() {
            return this.emergencyLoggingMask;
        }

        public void setEmergencyLoggingMask(ParseTree emergencyLoggingMask) {
            this.emergencyLoggingMask = emergencyLoggingMask;
        }

        public ParseTree getEmergencyLoggingForFailVerdict() {
            return this.emergencyLoggingForFailVerdict;
        }

        public void setEmergencyLoggingForFailVerdict(ParseTree emergencyLoggingForFailVerdict) {
            this.emergencyLoggingForFailVerdict = emergencyLoggingForFailVerdict;
        }
    }

    public static final class PluginSpecificParam {
        private ParseTree root = null;
        private ParseTree param = null;
        private ParseTree value = null;
        private String paramName = null;

        public PluginSpecificParam(ParseTree root, ParseTree param, ParseTree value, String paramName) {
            this.setRoot(root);
            this.setParam(param);
            this.setValue(value);
            this.setParamName(paramName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            PluginSpecificParam p = (PluginSpecificParam)o;
            return this.getParam().equals(p.getParam()) && this.getValue().equals(p.getValue());
        }

        public int hashCode() {
            return this.getParam().hashCode() + 31 * this.getValue().hashCode();
        }

        public ParseTree getRoot() {
            return this.root;
        }

        public void setRoot(ParseTree root) {
            this.root = root;
        }

        public ParseTree getParam() {
            return this.param;
        }

        public void setParam(ParseTree param) {
            this.param = param;
        }

        public ParseTree getValue() {
            return this.value;
        }

        public void setValue(ParseTree value) {
            this.value = value;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }
    }
}

