/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.IOException;
import java.text.ParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ValueReader;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.DetailsView;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.details.DetailData;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventSelection;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenValueViewMenuAction
extends SelectionProviderAction {
    private static final String NAME = Messages.getString("OpenValueViewMenuAction.0");
    private EventSelection eventSelection;
    private final ISelectionProvider view;
    private final boolean forceEditorOpening;
    private ISelection delayedSelection = null;
    private final InternalRunnable runnable = new InternalRunnable();

    public OpenValueViewMenuAction(ISelectionProvider view, boolean forceEditorOpening) {
        super(view, NAME);
        this.view = view;
        this.forceEditorOpening = forceEditorOpening;
    }

    public void delayedRun(ISelection selection) {
        this.delayedSelection = selection;
        if (this.runnable.isRunning()) {
            return;
        }
        Display.getDefault().asyncExec((Runnable)this.runnable);
    }

    public void run() {
        LogRecord logrecord;
        LogFileMetaData logFileMetaData;
        if (this.eventSelection == null) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (this.view instanceof MSCView) {
            logFileMetaData = ((MSCView)this.view).getLogFileMetaData();
        } else if (this.view instanceof TextTableView) {
            logFileMetaData = ((TextTableView)this.view).getLogFileMetaData();
        } else {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(logFileMetaData.getProjectName());
        IFile logFile = project.getFile(logFileMetaData.getProjectRelativePath().substring(logFileMetaData.getProjectName().length() + 1));
        if (!logFile.exists()) {
            IViewReference[] viewReferences = activePage.getViewReferences();
            ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
            if (this.view instanceof TextTableView) {
                TitanLogExceptionHandler.handleException(new UserException("The log file could not be found.\n Please perform the Open Text Table action again."));
            } else {
                TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenValueViewMenuAction.1")));
            }
            return;
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        DetailsView detailsview = (DetailsView)activePage.findView("org.eclipse.titan.log.viewer.views.DetailsView");
        if (detailsview == null && !this.forceEditorOpening) {
            return;
        }
        if (this.forceEditorOpening) {
            try {
                detailsview = (DetailsView)activePage.showView("org.eclipse.titan.log.viewer.views.DetailsView");
            }
            catch (PartInitException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("MSCView.1") + e.getMessage()));
                return;
            }
        }
        detailsview.setLogFileMetaData(logFileMetaData);
        EventObject eventObject = this.eventSelection.getEventObject();
        String testCase = this.eventSelection.getTestCaseName();
        if (eventObject == null || testCase == null) {
            return;
        }
        try {
            logrecord = ValueReader.getInstance().readLogRecordFromLogFile(logFileMetaData.getFilePath(), eventObject);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("MSCView.8")));
            return;
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("MSCView.8")));
            return;
        }
        String message = logrecord.getMessage();
        DetailData detailData = new DetailData(eventObject.getName(), eventObject.getPort(), message, testCase, eventObject.getEventType(), logrecord.getSourceInformation());
        detailsview.setData(detailData, false);
        detailsview.setFocus();
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof EventSelection) {
            this.eventSelection = (EventSelection)selection;
            this.setEnabled(!this.eventSelection.isEmpty());
        }
        super.selectionChanged(selection);
    }

    class InternalRunnable
    implements Runnable {
        private boolean running = false;

        InternalRunnable() {
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            if (OpenValueViewMenuAction.this.delayedSelection == null) {
                return;
            }
            this.running = true;
            OpenValueViewMenuAction.this.selectionChanged(OpenValueViewMenuAction.this.delayedSelection);
            OpenValueViewMenuAction.this.delayedSelection = null;
            OpenValueViewMenuAction.this.run();
            this.running = false;
            Display.getDefault().asyncExec((Runnable)OpenValueViewMenuAction.this.runnable);
        }
    }
}

