/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Frame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public class LifelineHeader
extends MSCNode {
    private final Lifeline lifeline;
    private final Frame frame;
    private boolean dragAndDrop;

    public LifelineHeader(Lifeline lifeline, Frame frame) {
        super(0);
        this.lifeline = lifeline;
        this.frame = frame;
    }

    public void setDragAndDropMode(boolean dragAndDrop) {
        this.dragAndDrop = dragAndDrop;
    }

    public boolean getDragAndDropMode() {
        return this.dragAndDrop;
    }

    public int getIndex() {
        return this.lifeline.getIndex();
    }

    public Lifeline getLifeline() {
        return this.lifeline;
    }

    @Override
    public int getX() {
        return this.lifeline.getIndex() * MSCConstants.COLUMN_WIDTH + 3;
    }

    @Override
    public int getY() {
        return this.frame.getVisibleAreaY() + 5;
    }

    @Override
    public int getWidth() {
        return MSCConstants.COLUMN_WIDTH - 6 + 1;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 10 + 1;
    }

    @Override
    public void draw(IGC context) {
        if (this.dragAndDrop) {
            return;
        }
        this.draw(context, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void draw(IGC context, int dragX, int dragY) {
        this.draw(context, dragX, this.getY(), this.getWidth(), this.getHeight());
    }

    private void draw(IGC context, int x, int y, int width, int height) {
        context.setLineStyle(context.getLineSolidStyle());
        context.setLineWidth(1);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_GREY"));
        context.fillRectangle(x + 1, y + 1, width, height);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.setGradientColor((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillGradientRectangle(x, y, width - 1, height - 1, true);
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
        context.drawRectangle(x, y, width - 1, height - 1);
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
        context.setFont((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"));
        context.drawTextTruncatedCentred(this.getName(), x, y, width - 1, height - 1, true);
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.LIFE_LINE_HEADER;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return true;
    }
}

